/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.expedicao;

import com.touchcomp.basementor.model.vo.EmbalagemExpedicao;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementorservice.dao.impl.DaoExpedicaoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.pedido.web.auxiliar.TempManutencaoSituacaoPedidos;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceExpedicaoImpl
extends ServiceGenericEntityImpl<Expedicao, Long, DaoExpedicaoImpl> {
    @Autowired
    public ServiceExpedicaoImpl(DaoExpedicaoImpl genericDao) {
        super(genericDao);
    }

    public List<TempManutencaoSituacaoPedidos.TempManutencaoSituacaoPedidosExp> findExpedicoesPedido(Long idPedido) {
        return ((DaoExpedicaoImpl)this.getGenericDao()).findExpedicoesPedido(idPedido);
    }

    public Expedicao atualizarExpedicao(Expedicao expedicao, WmsSeparacaoPedido aux, Short replicarEmb) {
        if (expedicao == null) {
            return null;
        }
        if (!this.isAffimative(replicarEmb)) {
            return expedicao;
        }
        Expedicao exp = expedicao;
        exp.getEmbalagemExpedicao().clear();
        if (this.isAffimative(aux.getConferenciaFinalizada())) {
            exp.setTipoConferencia(Short.valueOf((short)3));
            exp.setJustificativa("WMS");
            exp.setConferida(Short.valueOf((short)1));
            int nrEmb = 1;
            for (WmsSeparacaoPedidoEmb embWms : aux.getEmbalagens()) {
                EmbalagemExpedicao ee = new EmbalagemExpedicao();
                ee.setDataConferencia(aux.getDataSeparacao());
                ee.setEmbalagem(embWms.getEmbalagem());
                ee.setExpedicao(exp);
                ee.setLacraEmbalagem(Short.valueOf((short)1));
                ee.setOpcaoCaixa(Short.valueOf((short)1));
                ee.setPesoBruto(Double.valueOf(embWms.getPesoUtilizado() + embWms.getEmbalagem().getPeso()));
                ee.setPesoLiquido(embWms.getPesoUtilizado());
                ee.setUsuario(aux.getUsuarioSeparacao());
                ee.setVolume(embWms.getCapacidadeVolume());
                ee.setVolumeUtilizado(embWms.getVolumeUtilizado());
                ee.setNrEmbalagem(Integer.valueOf(nrEmb));
                exp.getEmbalagemExpedicao().add(ee);
                ++nrEmb;
            }
        } else {
            exp.setConferida(Short.valueOf((short)0));
        }
        return this.saveOrUpdate(exp);
    }
}

