/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.exportadadosbi;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.HelperBusinessIntelligence;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import com.touchcomp.touchvomodel.vo.exportacaodadosbi.DTOExportacaoDadosBI;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceExportaDadosBI {
    @Autowired
    ServiceBuildBusinessIntelligenceImpl serviceBuild;
    @Autowired
    ServiceBusinessIntelligenceImpl serviceBI;
    @Autowired
    HelperBusinessIntelligence helperBusinessIntelligence;

    public File buildPainel(DTOExportacaoDadosBI dtoParam, DefaultBIParamsMap params) throws ExceptionBuildBI, ExceptionObjNotFound {
        if (ToolMethods.isNull((Object)dtoParam.getFormatoBI()).booleanValue()) {
            dtoParam.setFormatoBI(String.valueOf(ConstEnumFormImprBI.JSON_DIRETO.getValue()));
        }
        BusinessIntelligence bi = (BusinessIntelligence)this.serviceBI.getOrThrow(dtoParam.getIdBi());
        DTOBusinessIntelligenceDet dto = this.helperBusinessIntelligence.buildToDTO(bi, EnumConstTipoSistema.WEB, params);
        dto.getDadosAdicionais().forEach(i -> this.popularParamentros((DTOBusinessIntelligenceDet.DTODadoAdicional)i, dtoParam));
        dto.setTipoSistema(EnumConstTipoSistema.WEB);
        DataOutputBI out = this.serviceBuild.gerarConverterFormatoImpBI(dto, ConstEnumFormImprBI.get((Object)dtoParam.getFormatoBI()), null, (DefaultBIParamsMap<String, Object>)params);
        return out.getFile();
    }

    private void popularParamentros(DTOBusinessIntelligenceDet.DTODadoAdicional dados, DTOExportacaoDadosBI dtoParamentos) {
        Object vKey = dtoParamentos.getParametros().get(dados.getChave());
        if (!ToolMethods.isNull(vKey).booleanValue()) {
            String v;
            Number vPrimitive;
            if (vKey instanceof Long) {
                vPrimitive = (Long)vKey;
                String string = ((Long)vPrimitive).toString();
            }
            if (vKey instanceof Integer) {
                vPrimitive = (Integer)vKey;
                v = ((Integer)vPrimitive).toString();
            } else {
                v = (String)vKey;
            }
            dados.setValorInformado(this.tratarStrDate(v));
        }
        if (!ToolMethods.isNull((Object)dados.getDadosAdicionais()).booleanValue()) {
            dados.getDadosAdicionais().forEach(i -> this.popularParamentros((DTOBusinessIntelligenceDet.DTODadoAdicional)i, dtoParamentos));
        }
    }

    public String tratarStrDate(String date) {
        String dia = "(0[1-9]|[12][0-9]|3[01])";
        String mes = "(0[1-9]|1[012])";
        String ano = "(19|20)\\d{2}";
        String horas = "([01][0-9]|2[0-3])";
        String minutos = "[0-5][0-9]";
        String milisegundos = "\\d{13}";
        String formato = "";
        String formatoBI = "dd/MM/yyyy HH:mm";
        Object strDate = "";
        Pattern padrao = Pattern.compile(milisegundos);
        if (padrao.matcher(date).find()) {
            Date d = new Date(Long.valueOf(date));
            return ToolDate.dateToStr((Date)d, (String)formatoBI);
        }
        strDate = ano + "-" + mes + "-" + dia + "T" + horas + "-" + minutos;
        padrao = Pattern.compile((String)strDate);
        if (padrao.matcher(date).find()) {
            if (date.length() > 17) {
                date = date.substring(0, 16);
            }
            formato = "yyyy-MM-dd HH-mm";
            date = date.replace("T", " ");
            Date d = ToolDate.strToDate((String)date, (String)formato);
            return ToolDate.dateToStr((Date)d, (String)formatoBI);
        }
        strDate = ano + "-" + mes + "-" + dia + "T" + horas;
        padrao = Pattern.compile((String)strDate);
        if (padrao.matcher(date).find()) {
            formato = "yyyy-MM-dd HH";
            date = date.replace("T", " ");
            Date d = ToolDate.strToDate((String)date, (String)formato);
            return ToolDate.dateToStr((Date)d, (String)formatoBI);
        }
        strDate = ano + "-" + mes + "-" + dia;
        padrao = Pattern.compile((String)strDate);
        if (padrao.matcher(date).find()) {
            formato = "yyyy-MM-dd";
            Date d = ToolDate.strToDate((String)date, (String)formato);
            return ToolDate.dateToStr((Date)d, (String)formatoBI);
        }
        return date;
    }

    public HashMap refinar(String str) {
        String[] list;
        if (ToolMethods.isNull((Object)str).booleanValue()) {
            return new HashMap();
        }
        HashMap<String, String> h = new HashMap<String, String>();
        for (String s : list = ToolString.stringToArray((String)str, (String)"&")) {
            String[] l = ToolString.stringToArray((String)s, (String)"=");
            if (l.length != 2) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("", new String[]{"Paramentos chave valor informado de forma incorreta!"}));
            }
            h.put(l[0].trim(), l[1].trim());
        }
        return h;
    }
}

