/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fabricante;

import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.FabricanteFornecedor;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoFabricanteImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.touchvomodel.vo.fabricantefornecedor.web.DTOFabricanteFornecedor;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFabricanteImpl
extends ServiceGenericEntityImpl<Fabricante, Long, DaoFabricanteImpl> {
    ServiceFornecedorImpl serviceFornecedorImpl;

    @Autowired
    public ServiceFabricanteImpl(DaoFabricanteImpl genericDao, ServiceFornecedorImpl serviceFornecedorImpl) {
        super(genericDao);
        this.serviceFornecedorImpl = serviceFornecedorImpl;
    }

    public List<Fabricante> getAltCriaVincProdTabBase(Date lastSinc, TabelaPrecoBase tabBase, int firstRes, Integer maxRegs) {
        return ((DaoFabricanteImpl)this.getDao()).getAltCriaVincProdTabBase(lastSinc, tabBase, firstRes, maxRegs);
    }

    public DTOFabricanteFornecedor getFornecedorDoFabricante(Long idFornecedor) throws ExceptionObjNotFound {
        Fornecedor fornecedor = (Fornecedor)this.serviceFornecedorImpl.getOrThrow(idFornecedor);
        FabricanteFornecedor vo = new FabricanteFornecedor();
        vo.setFornecedor(fornecedor);
        return this.buildToDTOGeneric(vo, DTOFabricanteFornecedor.class);
    }

    @Override
    public Fabricante beforeSave(Fabricante aux) {
        aux.getFornecedores().forEach(i -> i.setFabricante(aux));
        return aux;
    }
}

