/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentoadiantamentoviagem;

import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.BloqueioAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.DespesaViagem;
import com.touchcomp.basementor.model.vo.DespesasAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.FechamAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.FechamentoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.ParametrizacaoDespesasAdiantViagem;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoFechamentoAdiantamentoViagemImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.adiantamentoviagem.ServiceAdiantamentoViagemImpl;
import com.touchcomp.basementorservice.service.impl.baixatitulo.ServiceBaixaTituloImpl;
import com.touchcomp.basementorservice.service.impl.bloqueioadiantamentoviagem.ServiceBloqueioAdiantamentoViagemImpl;
import com.touchcomp.basementorservice.service.impl.borderotitulos.ServiceBorderoTitulosImpl;
import com.touchcomp.basementorservice.service.impl.despesaviagem.ServiceDespesaViagemImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.basementorservice.service.impl.opcoesgerenciais.ServiceOpcoesGerenciaisImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaodespesasadiantviagem.ServiceParametrizacaoDespesasAdiantViagemImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.fechamadiantamentoviagem.web.DTOFechamAdiantamentoViagem;
import com.touchcomp.touchvomodel.vo.fechamentoadiantamentoviagem.DTOFechamentoAdiantamentoViagem;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFechamentoAdiantamentoViagemImpl
extends ServiceGenericEntityImpl<FechamentoAdiantamentoViagem, Long, DaoFechamentoAdiantamentoViagemImpl> {
    @Autowired
    private ServiceParametrizacaoDespesasAdiantViagemImpl serviceParamDespAdViagem;
    @Autowired
    private ServiceAdiantamentoViagemImpl serviceAdiantamentoViagem;
    @Autowired
    private ServiceDespesaViagemImpl serviceDespesaViagem;
    @Autowired
    private ServiceBaixaTituloImpl serviceBaixaTitulo;
    @Autowired
    private ServiceBorderoTitulosImpl serviceBorderoTitulos;
    @Autowired
    private ServiceTituloImpl serviceTitulo;
    @Autowired
    private ServiceOpcoesGerenciaisImpl serviceOpcoesGerenciais;
    @Autowired
    private ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceiras;
    @Autowired
    private ServiceOpcoesContabeisImpl serviceOpcoesContabeis;
    @Autowired
    private ServiceBloqueioAdiantamentoViagemImpl serviceBloqueioAdiantamentoViagemImpl;
    @Autowired
    private CompGeracaoTitulos builderTitulos;

    @Autowired
    public ServiceFechamentoAdiantamentoViagemImpl(DaoFechamentoAdiantamentoViagemImpl genericDao) {
        super(genericDao);
    }

    @Override
    public FechamentoAdiantamentoViagem beforeSaveEntity(FechamentoAdiantamentoViagem vo) {
        OpcoesContabeis opcoesContabeis;
        if (ServiceFechamentoAdiantamentoViagemImpl.isWithData(vo.getDespesas())) {
            vo.getDespesas().forEach(i -> i.setAdiantamentoViagem(vo));
        }
        if (TMethods.isNull((Object)(opcoesContabeis = this.serviceOpcoesContabeis.findByEmpresa(vo.getEmpresa())).getPlanoContaAdViagem()).booleanValue()) {
            throw new ExceptionRuntimeBase("E.ERP.0478.001");
        }
        if (TMethods.isNull((Object)opcoesContabeis.getPlanoContaGerAdViagem()).booleanValue()) {
            throw new ExceptionRuntimeBase("E.ERP.0478.002");
        }
        Titulo titulo = this.serviceTitulo.findTituloFechamentoAdiantamentoViagem(vo);
        if (this.isNull(vo.getDataFechamento()).booleanValue() && this.isNotNull(titulo).booleanValue()) {
            throw new ExceptionRuntimeBase("E.ERP.2012.001");
        }
        List<BloqueioAdiantamentoViagem> bloqueioAdiantamentoViagem = this.serviceBloqueioAdiantamentoViagemImpl.verificaBloqueio(vo.getDataFechamento(), vo.getEmpresa());
        if (ServiceFechamentoAdiantamentoViagemImpl.isWithData(bloqueioAdiantamentoViagem)) {
            String idBloqueios = bloqueioAdiantamentoViagem.stream().map(i -> i.getIdentificador().toString()).collect(Collectors.joining(", "));
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.2012.003", new String[]{idBloqueios}));
        }
        return vo;
    }

    @Override
    public FechamentoAdiantamentoViagem afterSaveEntity(FechamentoAdiantamentoViagem vo) {
        this.builderTitulos.gerarTitulosFechamentoAdiantamentoViagem(vo, this.serviceOpcoesGerenciais.findByEmpresa(vo.getEmpresa()), this.serviceOpcoesFinanceiras.findByEmpresa(vo.getEmpresa()), this.serviceOpcoesContabeis.findByEmpresa(vo.getEmpresa()));
        return vo;
    }

    public DTOFechamentoAdiantamentoViagem iniciarFechamentoViagem(DTOFechamentoAdiantamentoViagem dto, Long idAdiantamentoViagem) throws ExceptionValidacaoDados, ExceptionObjNotFound {
        AdiantamentoViagem adiantamentoViagem = (AdiantamentoViagem)this.serviceAdiantamentoViagem.getOrThrow(idAdiantamentoViagem);
        FechamentoAdiantamentoViagem fechamento = ((DaoFechamentoAdiantamentoViagemImpl)this.getGenericDao()).findFechamentoByAdiantamento(adiantamentoViagem.getIdentificador());
        if (this.isNotNull(fechamento).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.2012.002", new Object[]{String.valueOf(fechamento)});
        }
        fechamento = this.isNotNull(dto) != false ? (FechamentoAdiantamentoViagem)this.buildToEntity(dto) : new FechamentoAdiantamentoViagem();
        fechamento.setAdiantamentoViagem(adiantamentoViagem);
        if (this.isNotNull(adiantamentoViagem.getParametrizacaoAdiantViagem()).booleanValue()) {
            this.novasDespesasParametrizadas(fechamento);
        }
        fechamento.setValorAdiantamento(adiantamentoViagem.getValorAdiantamento());
        fechamento.setSaldoAdiantamento(Double.valueOf(fechamento.getValorAdiantamento() - fechamento.getValorDespesas()));
        return this.buildToDTO(fechamento, DTOFechamentoAdiantamentoViagem.class);
    }

    public FechamentoAdiantamentoViagem novasDespesasParametrizadas(FechamentoAdiantamentoViagem fechamento) {
        ParametrizacaoAdiantamentoViagem parametrizacao = fechamento.getAdiantamentoViagem().getParametrizacaoAdiantViagem();
        if (ServiceFechamentoAdiantamentoViagemImpl.isWithData(parametrizacao.getDespesas())) {
            List despesasViagem = ServiceFechamentoAdiantamentoViagemImpl.isWithData(fechamento.getDespesas()) ? fechamento.getDespesas() : new LinkedList();
            Double totalDespesas = 0.0;
            for (DespesasAdiantamentoViagem despesa : parametrizacao.getDespesas()) {
                FechamAdiantamentoViagem f = new FechamAdiantamentoViagem();
                f.setDespesaViagem(despesa.getDespesaViagem());
                f.setVrDespesa(despesa.getValorPrevisto());
                f.setDataFechamento(new Date());
                ParametrizacaoDespesasAdiantViagem parametrizacaoDesp = this.serviceParamDespAdViagem.findParametrizacaoByDespesa(despesa.getDespesaViagem());
                if (this.isNotNull(parametrizacaoDesp).booleanValue()) {
                    f.setCentroCusto(parametrizacaoDesp.getCentroCusto());
                }
                totalDespesas = totalDespesas + f.getVrDespesa();
                despesasViagem.add(f);
            }
            fechamento.setDespesas(despesasViagem);
            fechamento.setValorDespesas(totalDespesas);
        }
        return fechamento;
    }

    public List<DTOFechamAdiantamentoViagem> novasDespesas(Long[] idsDespesas) throws ExceptionValidacaoDados, ExceptionObjNotFound {
        LinkedList<FechamAdiantamentoViagem> despesasViagem = new LinkedList<FechamAdiantamentoViagem>();
        List despesas = this.serviceDespesaViagem.gets(idsDespesas);
        for (DespesaViagem despesa : despesas) {
            FechamAdiantamentoViagem f = new FechamAdiantamentoViagem();
            f.setDespesaViagem(despesa);
            f.setVrDespesa(Double.valueOf(0.0));
            f.setDataFechamento(new Date());
            ParametrizacaoDespesasAdiantViagem parametrizacaoDesp = this.serviceParamDespAdViagem.findParametrizacaoByDespesa(despesa);
            if (this.isNotNull(parametrizacaoDesp).booleanValue()) {
                f.setCentroCusto(parametrizacaoDesp.getCentroCusto());
            }
            despesasViagem.add(f);
        }
        return this.buildToDTOGeneric(despesasViagem, DTOFechamAdiantamentoViagem.class);
    }

    public DTOFechamentoAdiantamentoViagem recalcularFechamento(DTOFechamentoAdiantamentoViagem dto) throws ExceptionValidacaoDados, ExceptionObjNotFound {
        FechamentoAdiantamentoViagem vo = (FechamentoAdiantamentoViagem)this.buildToEntity(dto);
        if (ServiceFechamentoAdiantamentoViagemImpl.isWithData(vo.getDespesas())) {
            Double totalDespesas = vo.getDespesas().stream().mapToDouble(FechamAdiantamentoViagem::getVrDespesa).sum();
            vo.setValorDespesas(totalDespesas);
            if (this.isNotNull(vo.getAdiantamentoViagem()).booleanValue()) {
                vo.setValorAdiantamento(vo.getAdiantamentoViagem().getValorAdiantamento());
            }
            vo.setSaldoAdiantamento(Double.valueOf(vo.getValorAdiantamento() - vo.getValorDespesas()));
        }
        return this.buildToDTO(vo, DTOFechamentoAdiantamentoViagem.class);
    }

    public Boolean habilitarFechamentoParaEdicao(Long idFechamento) throws ExceptionObjNotFound {
        FechamentoAdiantamentoViagem fechamento = (FechamentoAdiantamentoViagem)this.getOrThrow(idFechamento);
        if (this.isNull(fechamento.getTituloFechamento()).booleanValue()) {
            return true;
        }
        if (ServiceFechamentoAdiantamentoViagemImpl.isWithData(this.serviceBaixaTitulo.findBaixaTituloByTitulo(fechamento.getTituloFechamento().getIdentificador()))) {
            return false;
        }
        return this.isNotNull(this.serviceBorderoTitulos.pesquisarBorderoTitulosPorTitulo(fechamento.getTituloFechamento())) == false;
    }
}

