/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentobeneficiova;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.CadastroBeneficioRefeicaoCesta;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.FechamentoBeneficioVA;
import com.touchcomp.basementor.model.vo.FechamentoVAColaborador;
import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.PeriodoFolhaPagamento;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorservice.service.interfaces.ServiceAfastamentoColaborador;
import com.touchcomp.basementorservice.service.interfaces.ServiceCadastroBeneficioRefeicaoCesta;
import com.touchcomp.basementorservice.service.interfaces.ServiceFeriado;
import com.touchcomp.basementorservice.service.interfaces.ServiceFeriasColaborador;
import com.touchcomp.basementorservice.service.interfaces.ServiceMovPtoColaborador;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchvomodel.VOProcessResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AuxFechamentoBeneficioVA {
    private final FechamentoBeneficioVA fechamentoBeneficioVA;
    private final PeriodoFolhaPagamento periodoFolha;
    private final ServiceCadastroBeneficioRefeicaoCesta serviceCadBeneficioCesta = (ServiceCadastroBeneficioRefeicaoCesta)ConfApplicationContext.getBean(ServiceCadastroBeneficioRefeicaoCesta.class);
    private final ServiceFeriado serviceFeriado = (ServiceFeriado)ConfApplicationContext.getBean(ServiceFeriado.class);
    private final ServiceFeriasColaborador serviceFeriasColaborador = (ServiceFeriasColaborador)ConfApplicationContext.getBean(ServiceFeriasColaborador.class);
    private final ServiceMovPtoColaborador serviceMovPtoColaborador = (ServiceMovPtoColaborador)ConfApplicationContext.getBean(ServiceMovPtoColaborador.class);
    private final ServiceAfastamentoColaborador serviceAfastamentoColaborador = (ServiceAfastamentoColaborador)ConfApplicationContext.getBean(ServiceAfastamentoColaborador.class);
    private final VOProcessResult<FechamentoBeneficioVA> result = new VOProcessResult();
    private HashMap hashFeriados = new HashMap();
    private HashMap hashFeriadosMunicipais = new HashMap();

    public AuxFechamentoBeneficioVA(FechamentoBeneficioVA fechamentoBeneficioVA) {
        this.fechamentoBeneficioVA = fechamentoBeneficioVA;
        this.periodoFolha = fechamentoBeneficioVA.getPeriodoFolhaPagamento();
    }

    VOProcessResult processar() {
        List<TempFechamentoBeneficioVA> beneficios = this.processarPagamentoBeneficioVA();
        this.processar(beneficios);
        this.result.setResult((Object)this.fechamentoBeneficioVA);
        return this.result;
    }

    private List<FechamentoVAColaborador> processar(List<TempFechamentoBeneficioVA> beneficios) {
        int cont = 1;
        LinkedList<FechamentoVAColaborador> ret = new LinkedList<FechamentoVAColaborador>();
        for (TempFechamentoBeneficioVA cadBeneficio : beneficios) {
            System.out.println("\n\nCONTADOR BENEFICIOS:" + cont + " - " + cadBeneficio.getBeneficio().getColaborador().toString());
            if (cadBeneficio.getBeneficio().getDiasApuracaoVA() <= 0.0) {
                this.getDiasApuracaoVale(cadBeneficio);
            }
            ret.add(this.criarVA(cadBeneficio));
            ++cont;
        }
        return ret;
    }

    public VOProcessResult personalizado(List<CadastroBeneficioRefeicaoCesta> ret) {
        List<TempFechamentoBeneficioVA> beneficios = this.convertToTemp(ret);
        this.processar(beneficios);
        this.result.setResult((Object)this.fechamentoBeneficioVA);
        return this.result;
    }

    private List<TempFechamentoBeneficioVA> convertToTemp(List<CadastroBeneficioRefeicaoCesta> beneficios) {
        LinkedList<TempFechamentoBeneficioVA> list = new LinkedList<TempFechamentoBeneficioVA>();
        for (CadastroBeneficioRefeicaoCesta cadBeneficio : beneficios) {
            TempFechamentoBeneficioVA temp = new TempFechamentoBeneficioVA(this, cadBeneficio);
            if (cadBeneficio.getDiasApuracaoVA() > 0.0) {
                temp.setDiasAPagar(cadBeneficio.getDiasApuracaoVA());
                temp.setDiasCompetencia(cadBeneficio.getDiasApuracaoVA());
                temp.setDiasAfastamentos(0.0);
                temp.setDiasFerias(0.0);
                temp.setDiasPonto(0.0);
                temp.setDiasAviso(0.0);
            }
            list.add(temp);
        }
        return list;
    }

    private FechamentoVAColaborador getFechamentoVA(CadastroBeneficioRefeicaoCesta b, List<FechamentoVAColaborador> fechamentos) {
        Optional<FechamentoVAColaborador> found = fechamentos.stream().filter(i -> Objects.equals(i.getColaborador(), b.getColaborador()) && Objects.equals(i.getTipoTicket(), b.getTipoTicket())).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    private FechamentoVAColaborador criarVA(TempFechamentoBeneficioVA temp) {
        CadastroBeneficioRefeicaoCesta b = temp.getBeneficio();
        FechamentoVAColaborador va = this.getFechamentoVA(b, this.fechamentoBeneficioVA.getFechamentos());
        boolean found = false;
        if (va == null) {
            va = new FechamentoVAColaborador();
            va.setInformarValoresManuais(Short.valueOf((short)0));
            this.fechamentoBeneficioVA.getFechamentos().add(va);
        } else {
            found = true;
        }
        va.setSomarCesta(b.getSomarCestaBasicaAlimentacao());
        va.setColaborador(b.getColaborador());
        va.setCentroCusto(b.getColaborador().getCentroCusto());
        va.setLocal(b.getColaborador().getLocalTrabalhoColaboradorCidade());
        va.setTipoTicket(b.getTipoTicket());
        va.setDescontarFolha(b.getDescontarFolha());
        va.setFornecedorTicket(b.getFornecedor());
        va.setFechamentoVA(this.fechamentoBeneficioVA);
        double valorVale = b.getValorVale();
        double valorCestaBasica = b.getValorCestaBasica();
        double valorSomadoArquivo = b.getValorSomadoArquivo();
        double dias = temp.getDiasAPagar();
        double diasCompetencia = temp.getDiasCompetencia();
        double diasDescontoFerias = temp.getDiasFerias();
        double diasDescontoAfastamento = temp.getDiasAfastamentos();
        double diasDescontoPonto = temp.getDiasPonto();
        double valorDescontoFolha = 0.0;
        double diasAviso = temp.getDiasAviso();
        double valorDescontoVA = b.getValorDescVA();
        double valorTotalFixo = b.getValorTotalFixo();
        double percDescontoVA = b.getPercDescontoVA();
        double valorTotal = 0.0;
        if (dias < 0.0) {
            dias = 0.0;
        }
        double qtdValesPeriodo = dias;
        if (b.getDescontarFolha().equals((short)0)) {
            valorDescontoFolha = 0.0;
        } else if (b.getValorDescontoFixo() > 0.0) {
            valorDescontoFolha = b.getValorDescontoFixo();
        } else if (b.getValorDescVA() > 0.0) {
            valorDescontoFolha = ToolFormatter.arrredondarNumero((Double)(valorDescontoVA * qtdValesPeriodo), (int)2);
        } else if (b.getPercDescontoVA() > 0.0) {
            valorDescontoFolha = ToolFormatter.arrredondarNumero((Double)(valorVale * qtdValesPeriodo * (percDescontoVA / 100.0)), (int)2);
        }
        valorTotal = b.getValorTotalFixo() > 0.0 ? (valorSomadoArquivo += valorTotalFixo) : ToolFormatter.arrredondarNumero((Double)(valorVale * qtdValesPeriodo + valorSomadoArquivo), (int)2);
        if (!found) {
            va.setQuantidadeValesPeriodo(Double.valueOf(qtdValesPeriodo));
            va.setValorVale(Double.valueOf(valorVale));
            va.setDiasCompetencia(Double.valueOf(diasCompetencia));
            va.setValorDiferenca(Double.valueOf(0.0));
            va.setValorSomarArquivo(Double.valueOf(valorSomadoArquivo));
            va.setValorCesta(Double.valueOf(valorCestaBasica));
            va.setValorTotal(Double.valueOf(valorTotal));
            va.setValorDescontoVA(Double.valueOf(valorDescontoVA));
            va.setPercDescontoVA(Double.valueOf(percDescontoVA));
            va.setValorDescontoFolha(Double.valueOf(valorDescontoFolha));
            va.setDiasDescontoAfastamento(Double.valueOf(diasDescontoAfastamento));
            va.setDiasDescontoFerias(Double.valueOf(diasDescontoFerias));
            va.setDiasDescontoPonto(Double.valueOf(diasDescontoPonto));
            va.setDiasAviso(Double.valueOf(diasAviso));
        } else {
            va.setQuantidadeValesPeriodoRecalc(Double.valueOf(qtdValesPeriodo));
            va.setValorValeRecalc(Double.valueOf(valorVale));
            va.setDiasCompetenciaRecalc(Double.valueOf(diasCompetencia));
            va.setValorDiferencaRecalc(Double.valueOf(0.0));
            va.setValorSomarArquivoRecalc(Double.valueOf(valorSomadoArquivo));
            va.setValorCestaRecalc(Double.valueOf(valorCestaBasica));
            va.setValorTotalRecalc(Double.valueOf(valorTotal));
            va.setValorDescontoVARecalc(Double.valueOf(valorDescontoVA));
            va.setPercDescontoVARecalc(Double.valueOf(percDescontoVA));
            va.setValorDescontoFolhaRecalc(Double.valueOf(valorDescontoFolha));
            va.setDiasDescontoAfastamento(Double.valueOf(diasDescontoAfastamento));
            va.setDiasDescontoFerias(Double.valueOf(diasDescontoFerias));
            va.setDiasDescontoPonto(Double.valueOf(diasDescontoPonto));
            va.setDiasAviso(Double.valueOf(diasAviso));
        }
        if (va.getInformarValoresManuais() != 1 && va.getIdentificador() != null) {
            boolean aux = true;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getQuantidadeValesPeriodo() - va.getQuantidadeValesPeriodoRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getValorVale() - va.getValorValeRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getDiasCompetencia() - va.getDiasCompetenciaRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getValorDiferenca() - va.getValorDiferencaRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getValorSomarArquivo() - va.getValorSomarArquivoRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getValorCesta() - va.getValorCestaRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getValorTotal() - va.getValorTotalRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getValorDescontoVA() - va.getValorDescontoVARecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getValorDescontoFolha() - va.getValorDescontoFolhaRecalc()), (int)2) == 0.0;
            boolean bl = aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(va.getPercDescontoVA() - va.getPercDescontoVARecalc()), (int)2) == 0.0;
            if (!aux) {
                va.setDetecDifRecalc(Short.valueOf((short)1));
            } else {
                va.setDetecDifRecalc(Short.valueOf((short)0));
            }
        }
        return va;
    }

    private List<TempFechamentoBeneficioVA> processarPagamentoBeneficioVA() {
        List<CadastroBeneficioRefeicaoCesta> beneficios = this.serviceCadBeneficioCesta.getBeneficiosColabAtivos(this.periodoFolha);
        return this.convertToTemp(beneficios);
    }

    private void getDiasApuracaoVale(TempFechamentoBeneficioVA temp) {
        Date inicioApuracao = this.periodoFolha.getDataInicialFolha();
        Date finalApuracao = this.periodoFolha.getDataFinalFolha();
        finalApuracao = ToolDate.highDateTime((Date)finalApuracao);
        Date inicioApuracaoPonto = this.periodoFolha.getDataInicialVA();
        Date finalApuracaoPonto = this.periodoFolha.getDataFinalVA();
        finalApuracaoPonto = ToolDate.highDateTime((Date)finalApuracaoPonto);
        CadastroBeneficioRefeicaoCesta cadBeneficio = temp.getBeneficio();
        if (cadBeneficio.getColaborador().getDataDemissao() != null && cadBeneficio.getColaborador().getDataDemissao().before(this.periodoFolha.getDataFinalVA())) {
            finalApuracao = cadBeneficio.getColaborador().getDataDemissao();
        }
        Double referenciaGeral = 0.0;
        Double diasFerias = 0.0;
        Double diasAfastados = 0.0;
        Double diasAviso = 0.0;
        Long diasDesconto = 0L;
        Colaborador colaborador = cadBeneficio.getColaborador();
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario() == null) {
            VOProcessResult.VOPRocessErro erro = new VOProcessResult.VOPRocessErro();
            erro.setDescricao("Verifique o cadastro do Horario: " + colaborador.getHorarioTrabalho().getIdentificador() + " do colaborador: " + colaborador.toString());
            this.result.addErro(erro);
            return;
        }
        if (colaborador.getHorarioTrabalho() == null || colaborador.getHorarioTrabalho().getTurnoDeTrabalho() == null) {
            temp.setDiasAPagar(0.0);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
            referenciaGeral = this.calculoSemanalSemDiaDiferente(cadBeneficio, inicioApuracao, finalApuracao);
            if (colaborador.getLocalTrabalhoColaboradorCidade().getLocalTrabalhoColaborador().getEfetuaPagamentoCestaFerias().equals((short)0)) {
                diasFerias = this.getDiasFerias(cadBeneficio, inicioApuracao, finalApuracao);
            }
            diasAfastados = this.getDiasAfastamentos(cadBeneficio, inicioApuracao, finalApuracao);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
            referenciaGeral = this.calcularReferenciaJornadaRevezamento(colaborador, inicioApuracao, finalApuracao);
            if (colaborador.getLocalTrabalhoColaboradorCidade().getLocalTrabalhoColaborador().getEfetuaPagamentoCestaFerias().equals((short)0)) {
                diasFerias = this.getDiasFerias(cadBeneficio, inicioApuracao, finalApuracao);
            }
            diasAfastados = this.getDiasAfastamentos(cadBeneficio, inicioApuracao, finalApuracao);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) {
            referenciaGeral = this.calcularReferenciaJornada1236(colaborador, inicioApuracao, finalApuracao);
            if (colaborador.getLocalTrabalhoColaboradorCidade().getLocalTrabalhoColaborador().getEfetuaPagamentoCestaFerias().equals((short)0)) {
                diasFerias = this.getDiasFerias(cadBeneficio, inicioApuracao, finalApuracao);
            }
            diasAfastados = this.getDiasAfastamentos(cadBeneficio, inicioApuracao, finalApuracao);
        }
        diasDesconto = this.getDiasDesconto(colaborador, inicioApuracaoPonto, finalApuracaoPonto);
        diasAviso = this.getDiasAviso(cadBeneficio, this.periodoFolha.getDataInicialFolha());
        temp.setDiasCompetencia(referenciaGeral);
        Double total = referenciaGeral - diasFerias - diasAfastados - (double)diasDesconto.longValue() - diasAviso;
        if (total <= 0.0) {
            total = 0.0;
        }
        temp.setDiasAPagar(total);
        temp.setDiasPonto(diasDesconto.doubleValue());
        temp.setDiasFerias(diasFerias);
        temp.setDiasAfastamentos(diasAfastados);
        temp.setDiasAviso(diasAviso);
    }

    private Double calculoSemanalSemDiaDiferente(CadastroBeneficioRefeicaoCesta b, Date inicioApuracao, Date finalApuracao) {
        Colaborador colaborador = b.getColaborador();
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date dataCorrente = colaborador.getDataAdmissao().after(inicioApuracao) ? colaborador.getDataAdmissao() : inicioApuracao;
        Integer contador = 0;
        block0: do {
            Integer diaParametro = this.getDiaSemanal(dataCorrente);
            if (!this.diaNaoFeriado(dataCorrente, colaborador.getLocalTrabalhoColaboradorCidade().getCidade())) continue;
            for (InfoHorarioTrabalho diaHorario : horario.getEsocCadastroHorario().getListaHorario()) {
                if (!diaHorario.getDiaSemana().getDia().equals(diaParametro.shortValue()) || !diaHorario.getFolga().equals((short)0)) continue;
                Double ref = ToolDate.calcularDifHoras((Date)diaHorario.getHorarioInicial(), (Date)diaHorario.getHorarioFinal());
                if (!b.getNaoValidarDias().equals((short)1) && !(ref >= 7.0)) continue block0;
                contador = contador + 1;
                continue block0;
            }
        } while (finalApuracao.after(dataCorrente = ToolDate.nextDays((Date)dataCorrente, (int)1)) || finalApuracao.equals(dataCorrente));
        return contador.doubleValue();
    }

    private Integer getDiaSemanal(Date inicioParametro) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(inicioParametro);
        return g.get(7);
    }

    private boolean diaNaoFeriado(Date data, Cidade cidade) {
        Boolean diaEhFeriado = (Boolean)this.hashFeriados.get(data.getTime());
        Feriado feriado = null;
        Boolean buscaRealizada = false;
        if (diaEhFeriado == null) {
            feriado = this.serviceFeriado.findFeriadoPorDataAndCidade(data, cidade);
            buscaRealizada = true;
            diaEhFeriado = feriado == null || feriado.getTipoFeriado().equals((short)0) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            this.hashFeriados.put(data.getTime(), diaEhFeriado);
        }
        if (!diaEhFeriado.booleanValue() && (diaEhFeriado = (Boolean)this.hashFeriadosMunicipais.get(cidade.getIdentificador() + data.getTime())) == null) {
            if (!buscaRealizada.booleanValue()) {
                feriado = this.serviceFeriado.findFeriadoPorDataAndCidade(data, cidade);
            }
            if (feriado == null) {
                diaEhFeriado = false;
                this.hashFeriadosMunicipais.put(cidade.getIdentificador() + data.getTime(), diaEhFeriado);
            } else {
                diaEhFeriado = true;
                this.hashFeriadosMunicipais.put(cidade.getIdentificador() + data.getTime(), diaEhFeriado);
            }
        }
        return diaEhFeriado == false;
    }

    private Double getDiasFerias(CadastroBeneficioRefeicaoCesta b, Date inicioApuracao, Date finalApuracao) {
        Colaborador colaborador = b.getColaborador();
        List<FeriasColaborador> feriasColab = this.serviceFeriasColaborador.getFerias(colaborador, inicioApuracao, finalApuracao);
        Double diasFerias = 0.0;
        for (FeriasColaborador ferias : feriasColab) {
            Date parametroInicial = ferias.getDataGozoInicial().after(inicioApuracao) ? ferias.getDataGozoInicial() : inicioApuracao;
            Date parametroFinal = ferias.getDataGozoFinal().after(finalApuracao) ? finalApuracao : ferias.getDataGozoFinal();
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasFerias = this.calculoSemanalSemDiaDiferente(b, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasFerias = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasFerias = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasFerias;
    }

    private Double getDiasAfastamentos(CadastroBeneficioRefeicaoCesta b, Date inicioApuracao, Date finalApuracao) {
        Colaborador colaborador = b.getColaborador();
        Double diasAfastamento = 0.0;
        List<AfastamentoColaborador> aux = this.serviceAfastamentoColaborador.getAfastamentosColaborador(colaborador, inicioApuracao, finalApuracao);
        for (AfastamentoColaborador af : aux) {
            Date parametroInicial = af.getDataAfastamento().after(inicioApuracao) ? af.getDataAfastamento() : inicioApuracao;
            Date parametroFinal = af.getDataRetorno() == null ? finalApuracao : (af.getDataRetorno().after(finalApuracao) ? finalApuracao : ToolDate.nextDays((Date)af.getDataRetorno(), (int)-1));
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasAfastamento = this.calculoSemanalSemDiaDiferente(b, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasAfastamento = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasAfastamento = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasAfastamento;
    }

    private Double calcularReferenciaJornadaRevezamento(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        Date dataAdmissao;
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date inicioParametro = dataAdmissao = colaborador.getDataAdmissao();
        Integer contador = 0;
        Integer diasTrabalho = horario.getHorasTrabalhadasRevezamento().intValue();
        Integer diasFolga = horario.getHorasFolgasRevezamento().intValue();
        Integer diasAContar = diasTrabalho + diasFolga;
        Date dataProjecao = inicioParametro;
        if (dataAdmissao.before(inicioApuracao)) {
            boolean menor;
            while (menor = (dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(inicioApuracao)) {
            }
            if (dataProjecao.equals(inicioApuracao)) {
                do {
                    Date dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(finalApuracao)) {
                        contador = contador + horario.getHorasTrabalhadasRevezamento().intValue();
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        contador = contador + 1;
                        menor = false;
                        continue;
                    }
                    Integer difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)finalApuracao);
                    if (difDias.intValue() == diasAContar.intValue()) {
                        difDias = difDias - 1;
                    }
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
            }
            if (dataProjecao.after(inicioApuracao)) {
                contador = 0;
                Date dataUltimaProjecao = ToolDate.nextDays((Date)dataProjecao, (int)(-diasAContar.intValue()));
                Integer difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)inicioApuracao) + 1;
                Integer aux = 0;
                if (difDias.intValue() == diasAContar.intValue()) {
                    contador = contador + 0;
                } else {
                    aux = diasAContar - difDias;
                    contador = contador + aux;
                }
                dataProjecao = inicioApuracao;
                dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)(aux - 1));
                do {
                    dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(finalApuracao)) {
                        contador = contador + diasTrabalho;
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        menor = false;
                        continue;
                    }
                    difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)finalApuracao);
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
            }
        } else {
            boolean menor;
            contador = 0;
            dataProjecao = dataAdmissao;
            do {
                Date dataUltimaProjecao = dataProjecao;
                if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(finalApuracao)) {
                    contador = contador + diasTrabalho;
                    menor = true;
                    continue;
                }
                if (dataProjecao.equals(finalApuracao)) {
                    menor = false;
                    continue;
                }
                Integer difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)finalApuracao) + 1;
                if (difDias.intValue() == diasAContar.intValue()) {
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                    continue;
                }
                contador = contador + difDias;
                menor = false;
            } while (menor);
            return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
        }
        return 0.0;
    }

    private Double calcularReferenciaJornada1236(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        boolean menor;
        Date dataAdmissao;
        Date inicioParametro;
        Date dataProjecao = inicioParametro = (dataAdmissao = colaborador.getDataAdmissao());
        Integer contador = 0;
        if (dataAdmissao.before(inicioApuracao)) {
            while (menor = (dataProjecao = ToolDate.nextDays((Date)ToolDate.dataSemHora((Date)dataProjecao), (int)2)).before(inicioApuracao)) {
            }
        }
        contador = contador + 1;
        do {
            if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)2)).before(finalApuracao)) {
                contador = contador + 1;
                menor = true;
                continue;
            }
            if (dataProjecao.equals(finalApuracao)) {
                contador = contador + 1;
                menor = false;
                continue;
            }
            menor = false;
        } while (menor);
        return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
    }

    private Long getDiasDesconto(Colaborador colaborador, Date inicioApuracaoPonto, Date finalApuracaoPonto) {
        return this.serviceMovPtoColaborador.getDiasDesconto(colaborador, inicioApuracaoPonto, finalApuracaoPonto, (short)0);
    }

    VOProcessResult reprocessar(Colaborador colaborador, Short tipoTicket) {
        List<TempFechamentoBeneficioVA> beneficios = this.reprocessarPagamentoBeneficioVA(colaborador, tipoTicket);
        this.processar(beneficios);
        this.result.setResult((Object)this.fechamentoBeneficioVA);
        return this.result;
    }

    private List<TempFechamentoBeneficioVA> reprocessarPagamentoBeneficioVA(Colaborador colaborador, Short tipoTicket) {
        CadastroBeneficioRefeicaoCesta beneficio = this.serviceCadBeneficioCesta.getBeneficiosColabAtivosPorColaboradorAndTipoTicket(this.periodoFolha, colaborador, tipoTicket);
        ArrayList<CadastroBeneficioRefeicaoCesta> beneficios = new ArrayList<CadastroBeneficioRefeicaoCesta>();
        beneficios.add(beneficio);
        return this.convertToTemp(beneficios);
    }

    private Double getDiasAviso(CadastroBeneficioRefeicaoCesta cadBeneficio, Date dataInicio) {
        if (cadBeneficio.getColaborador().getDataDemissao() == null) {
            return 0.0;
        }
        if (cadBeneficio.getColaborador().getNumeroRegistro().equals("999")) {
            System.out.println("");
        }
        Double referenciaGeral = 0.0;
        for (Recisao r : cadBeneficio.getColaborador().getRecisoes()) {
            if (!r.getRecisaoComplementar().equals((short)0)) continue;
            if (!r.getAvisoIndenizado().equals((short)1)) {
                return 0.0;
            }
            if (!r.getEmissaoAviso().getTipoAviso().getCodigo().equals("2")) continue;
            Date inicioAviso = null;
            Date finalAviso = cadBeneficio.getColaborador().getDataDemissao();
            inicioAviso = ToolDate.nextDays((Date)finalAviso, (int)-6);
            if (cadBeneficio.getColaborador().getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                referenciaGeral = this.calculoSemanalSemDiaDiferente(cadBeneficio, inicioAviso, finalAviso);
            }
            if (cadBeneficio.getColaborador().getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                referenciaGeral = this.calcularReferenciaJornadaRevezamento(cadBeneficio.getColaborador(), inicioAviso, finalAviso);
            }
            if (cadBeneficio.getColaborador().getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) {
                referenciaGeral = this.calcularReferenciaJornada1236(cadBeneficio.getColaborador(), inicioAviso, finalAviso);
            }
            return referenciaGeral;
        }
        return 0.0;
    }

    class TempFechamentoBeneficioVA {
        private CadastroBeneficioRefeicaoCesta beneficio;
        private double diasAPagar;
        private double diasCompetencia;
        private double diasFerias;
        private double diasAfastamentos;
        private Double diasPonto;
        private double diasAviso;

        public TempFechamentoBeneficioVA(AuxFechamentoBeneficioVA this$0, CadastroBeneficioRefeicaoCesta beneficio) {
            this.beneficio = beneficio;
            this.diasAPagar = 0.0;
            this.diasCompetencia = 0.0;
            this.diasFerias = 0.0;
            this.diasAfastamentos = 0.0;
            this.diasPonto = 0.0;
            this.diasAviso = 0.0;
        }

        public CadastroBeneficioRefeicaoCesta getBeneficio() {
            return this.beneficio;
        }

        public void setBeneficio(CadastroBeneficioRefeicaoCesta beneficio) {
            this.beneficio = beneficio;
        }

        public double getDiasAPagar() {
            return this.diasAPagar;
        }

        public void setDiasAPagar(double diasAPagar) {
            this.diasAPagar = diasAPagar;
        }

        public double getDiasCompetencia() {
            return this.diasCompetencia;
        }

        public void setDiasCompetencia(double diasCompetencia) {
            this.diasCompetencia = diasCompetencia;
        }

        public double getDiasFerias() {
            return this.diasFerias;
        }

        public void setDiasFerias(double diasFerias) {
            this.diasFerias = diasFerias;
        }

        public double getDiasAfastamentos() {
            return this.diasAfastamentos;
        }

        public void setDiasAfastamentos(double diasAfastamentos) {
            this.diasAfastamentos = diasAfastamentos;
        }

        public Double getDiasPonto() {
            return this.diasPonto;
        }

        public void setDiasPonto(Double diasPonto) {
            this.diasPonto = diasPonto;
        }

        public double getDiasAviso() {
            return this.diasAviso;
        }

        public void setDiasAviso(double diasAviso) {
            this.diasAviso = diasAviso;
        }
    }
}

