/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentobeneficiovt;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.FechamentoBeneficioVT;
import com.touchcomp.basementor.model.vo.FechamentoColaboradorVT;
import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.ItemLinhaTransporteColaborador;
import com.touchcomp.basementor.model.vo.LinhaTransporteColaborador;
import com.touchcomp.basementor.model.vo.LinhaTransporteFechamento;
import com.touchcomp.basementor.model.vo.PeriodoFolhaPagamento;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorservice.service.interfaces.ServiceAfastamentoColaborador;
import com.touchcomp.basementorservice.service.interfaces.ServiceFeriado;
import com.touchcomp.basementorservice.service.interfaces.ServiceFeriasColaborador;
import com.touchcomp.basementorservice.service.interfaces.ServiceLinhaTransporteColaborador;
import com.touchcomp.basementorservice.service.interfaces.ServiceMovPtoColaborador;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.touchvomodel.VOProcessResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AuxFechamentoBeneficioVT {
    private final FechamentoBeneficioVT fechamentoBeneficioVT;
    private final PeriodoFolhaPagamento periodoFolha;
    private final ServiceLinhaTransporteColaborador serviceLinhaTransporteColaborador = (ServiceLinhaTransporteColaborador)ConfApplicationContext.getBean(ServiceLinhaTransporteColaborador.class);
    private final ServiceFeriado serviceFeriado = (ServiceFeriado)ConfApplicationContext.getBean(ServiceFeriado.class);
    private final ServiceFeriasColaborador serviceFeriasColaborador = (ServiceFeriasColaborador)ConfApplicationContext.getBean(ServiceFeriasColaborador.class);
    private final ServiceMovPtoColaborador serviceMovPtoColaborador = (ServiceMovPtoColaborador)ConfApplicationContext.getBean(ServiceMovPtoColaborador.class);
    private final ServiceAfastamentoColaborador serviceAfastamentoColaborador = (ServiceAfastamentoColaborador)ConfApplicationContext.getBean(ServiceAfastamentoColaborador.class);
    private final VOProcessResult<FechamentoBeneficioVT> result = new VOProcessResult();
    private HashMap hashFeriados = new HashMap();
    private HashMap hashFeriadosMunicipais = new HashMap();

    public AuxFechamentoBeneficioVT(FechamentoBeneficioVT fechamentoBeneficioVT) {
        this.fechamentoBeneficioVT = fechamentoBeneficioVT;
        this.periodoFolha = fechamentoBeneficioVT.getPeriodoFolhaPagamento();
    }

    VOProcessResult processar() {
        List<TempFechamentoBeneficioVT> beneficios = this.processarPagamentoBeneficioVT();
        this.processar(beneficios);
        this.result.setResult((Object)this.fechamentoBeneficioVT);
        return this.result;
    }

    private List<FechamentoColaboradorVT> processar(List<TempFechamentoBeneficioVT> beneficios) {
        LinkedList<FechamentoColaboradorVT> ret = new LinkedList<FechamentoColaboradorVT>();
        for (TempFechamentoBeneficioVT temp : beneficios) {
            ret.add(this.criarVT(temp));
        }
        return ret;
    }

    private FechamentoColaboradorVT criarVT(TempFechamentoBeneficioVT temp) {
        LinhaTransporteColaborador linha = temp.getLinha();
        FechamentoColaboradorVT vt = this.getFechamentoVT(linha, this.fechamentoBeneficioVT.getFechamentos());
        boolean found = false;
        if (vt == null) {
            vt = new FechamentoColaboradorVT();
            this.fechamentoBeneficioVT.getFechamentos().add(vt);
        } else {
            found = true;
        }
        Double qtdeDias = temp.getDiasAPagar();
        Double qtdeDiaria = linha.getQuantidadeTotalDiaria().doubleValue();
        Double valorPorDia = this.getTotalPorDia(linha);
        Double diasCompetencia = temp.getDiasCompetencia();
        Double valorTotal = 0.0;
        Double diasFerias = temp.getDiasDescontoFerias();
        Double diasAfastamento = temp.getDiasDescontoAfastamento();
        Double diasDesconto = temp.getDiasDescontoPonto();
        Double diasAviso = temp.getDiasAviso();
        this.getLinhasFechamento(linha, vt, qtdeDias, diasCompetencia);
        vt.setColaborador(linha.getColaborador());
        vt.setCentroCusto(linha.getColaborador().getCentroCusto());
        vt.setLocal(linha.getColaborador().getLocalTrabalhoColaboradorCidade());
        vt.setFechamentoBeneficioVT(this.fechamentoBeneficioVT);
        vt.setDescontar(linha.getDescontar());
        vt.setPossuiValorFixo(Short.valueOf(temp.getPossuiValorFixo()));
        vt.setSaldoCartao(Double.valueOf(0.0));
        vt.setValorDiferenca(Double.valueOf(0.0));
        valorTotal = vt.getPossuiValorFixo() == 0 ? Double.valueOf(qtdeDias * valorPorDia) : (temp.getDiasAPagar() == diasCompetencia.doubleValue() && (linha.getColaborador().getDataDemissao() == null || linha.getColaborador().getDataDemissao().after(this.fechamentoBeneficioVT.getPeriodoPagamento())) ? (linha.getColaborador().getDataAdmissao().before(this.fechamentoBeneficioVT.getPeriodoPagamento()) && linha.getColaborador().getDataAdmissao().after(ToolDate.getDateFirstMonthDay((Date)this.fechamentoBeneficioVT.getPeriodoPagamento())) ? Double.valueOf(this.getValorFixo(linha) / 30.0 * qtdeDias) : this.getValorFixo(linha)) : (temp.getDiasAPagar() == diasCompetencia.doubleValue() && linha.getColaborador().getDataDemissao() != null && linha.getColaborador().getDataDemissao().before(this.fechamentoBeneficioVT.getPeriodoPagamento()) ? Double.valueOf(this.getValorFixo(linha) / 30.0 * qtdeDias) : Double.valueOf(this.getValorFixo(linha) / diasCompetencia * qtdeDias)));
        if (!found) {
            vt.setQuantidadeDias(qtdeDias);
            vt.setDiasDescontoAfastamento(diasAfastamento);
            vt.setDiasDescontoFerias(diasFerias);
            vt.setDiasDescontoPonto(diasDesconto);
            vt.setDiasAviso(diasAviso);
            vt.setQuantidadeDiaria(qtdeDiaria);
            vt.setDiasCompetencia(diasCompetencia);
            vt.setValorPorDia(valorPorDia);
            vt.setValorTotal(ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2));
            vt.setTotalCredito(ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2));
        } else {
            vt.setQuantidadeDiasRecalc(qtdeDias);
            vt.setDiasDescontoAfastamento(diasAfastamento);
            vt.setDiasDescontoFerias(diasFerias);
            vt.setDiasDescontoPonto(diasDesconto);
            vt.setDiasAviso(diasAviso);
            vt.setQuantidadeDiariaRecalc(qtdeDiaria);
            vt.setDiasCompetenciaRecalc(diasCompetencia);
            vt.setValorPorDiaRecalc(valorPorDia);
            vt.setValorTotalRecalc(ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2));
            vt.setTotalCreditoRecalc(Double.valueOf(ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2) - ToolFormatter.arrredondarNumero((Double)this.getSaldoCartaoRecalculado(vt), (int)2)));
        }
        if (vt.getLinhas() == null || vt.getLinhas().isEmpty()) {
            this.fechamentoBeneficioVT.getFechamentos().remove(vt);
        }
        if (!this.valoresInformadosManuais(vt.getLinhas()) && vt.getIdentificador() != null) {
            boolean aux = true;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(vt.getQuantidadeDias() - vt.getQuantidadeDiasRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(vt.getQuantidadeDiaria() - vt.getQuantidadeDiariaRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(vt.getDiasCompetencia() - vt.getDiasCompetenciaRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(vt.getValorPorDia() - vt.getValorPorDiaRecalc()), (int)2) == 0.0;
            aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(vt.getValorTotal() - vt.getValorTotalRecalc()), (int)2) == 0.0;
            boolean bl = aux = aux && ToolFormatter.arrredondarNumero((Double)Math.abs(vt.getTotalCredito() - vt.getTotalCreditoRecalc()), (int)2) == 0.0;
            if (!aux) {
                vt.setDetecDifRecalc(Short.valueOf((short)1));
            } else {
                vt.setDetecDifRecalc(Short.valueOf((short)0));
            }
        }
        return vt;
    }

    private FechamentoColaboradorVT getFechamentoVT(LinhaTransporteColaborador b, List<FechamentoColaboradorVT> fechamentos) {
        Optional<FechamentoColaboradorVT> found = fechamentos.stream().filter(i -> Objects.equals(i.getColaborador(), b.getColaborador())).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    private Double getTotalPorDia(LinhaTransporteColaborador linha) {
        Double retorno = 0.0;
        Integer quantidade = 0;
        Double geral = 0.0;
        for (ItemLinhaTransporteColaborador l : linha.getLinhasTransporte()) {
            if (!l.getAtiva().equals((short)1)) continue;
            retorno = l.getLinhaTransporte().getTarifa();
            quantidade = l.getQtdadeDiaria();
            geral = geral + ToolFormatter.arrredondarNumero((Double)(retorno * quantidade.doubleValue()), (int)2);
        }
        return ToolFormatter.arrredondarNumero((Double)geral, (int)2);
    }

    private void getLinhasFechamento(LinhaTransporteColaborador linha, FechamentoColaboradorVT fechamento, Double qtdeDias, Double diasCompetencia) {
        if (linha.getColaborador().getIdentificador() == 372L) {
            System.out.println("");
        }
        Object obs = "";
        for (ItemLinhaTransporteColaborador item : linha.getLinhasTransporte()) {
            if (!item.getAtiva().equals((short)1) || !this.validarPeriodo(item)) continue;
            LinhaTransporteFechamento linhaFechamento = this.getLinhaTransporteFechamentoExiste(fechamento, item);
            if (linhaFechamento == null) {
                linhaFechamento = new LinhaTransporteFechamento();
                linhaFechamento.setFechamento(fechamento);
                linhaFechamento.setItemLinha(item);
                linhaFechamento.setDiasApuracao(qtdeDias);
                linhaFechamento.setValorDiario(item.getLinhaTransporte().getTarifa());
                linhaFechamento.setQuantidade(Double.valueOf(item.getQtdadeDiaria().doubleValue()));
                linhaFechamento.setValorTotal(Double.valueOf(item.getQtdadeDiaria().doubleValue() * qtdeDias * item.getLinhaTransporte().getTarifa()));
                if (linhaFechamento.getInformarValoresManuais() == 0 && !linhaFechamento.getItemLinha().getLinhaTransporte().getPossuiValorFixo().equals((short)0)) {
                    if (qtdeDias.equals(diasCompetencia)) {
                        linhaFechamento.setValorTotal(linhaFechamento.getValorDiario());
                    } else {
                        linhaFechamento.setValorTotal(ToolFormatter.arrredondarNumero((Double)(linhaFechamento.getValorDiario() / diasCompetencia * qtdeDias), (int)2));
                    }
                }
                if (item.getObservacao() != null && item.getObservacao().length() > 0) {
                    obs = (String)obs + item.getObservacao() + " ";
                }
                fechamento.getLinhas().add(linhaFechamento);
                continue;
            }
            obs = linhaFechamento.getFechamento().getObservacoes();
            linhaFechamento.setSaldoCartaoRecalc(linhaFechamento.getSaldoCartao());
            linhaFechamento.setDiasApuracaoRecalc(qtdeDias);
            linhaFechamento.setValorDiarioRecalc(item.getLinhaTransporte().getTarifa());
            linhaFechamento.setQuantidadeRecalc(Double.valueOf(item.getQtdadeDiaria().doubleValue()));
            linhaFechamento.setValorTotalRecalc(Double.valueOf(item.getQtdadeDiaria().doubleValue() * qtdeDias * item.getLinhaTransporte().getTarifa()));
            if (!linhaFechamento.getItemLinha().getLinhaTransporte().getPossuiValorFixo().equals((short)0)) {
                if (qtdeDias.equals(diasCompetencia)) {
                    linhaFechamento.setValorTotalRecalc(linhaFechamento.getValorDiarioRecalc());
                } else {
                    linhaFechamento.setValorTotalRecalc(ToolFormatter.arrredondarNumero((Double)(linhaFechamento.getValorDiarioRecalc() / diasCompetencia * qtdeDias), (int)2));
                }
            }
            linhaFechamento.setValorTotalRecalc(Double.valueOf(linhaFechamento.getValorTotalRecalc() - linhaFechamento.getSaldoCartaoRecalc()));
        }
        fechamento.setObservacoes((String)obs);
    }

    private List<TempFechamentoBeneficioVT> processarPagamentoBeneficioVT() {
        List<LinhaTransporteColaborador> linhas = this.serviceLinhaTransporteColaborador.getBeneficiosColabAtivos(this.periodoFolha);
        return this.convertToTemp(linhas);
    }

    private List<TempFechamentoBeneficioVT> convertToTemp(List<LinhaTransporteColaborador> linhas) {
        ArrayList<TempFechamentoBeneficioVT> lista = new ArrayList<TempFechamentoBeneficioVT>();
        for (LinhaTransporteColaborador linha : linhas) {
            TempFechamentoBeneficioVT temp = new TempFechamentoBeneficioVT(this, linha);
            Date dataFinalAux = null;
            dataFinalAux = linha.getColaborador().getDataDemissao() != null && linha.getColaborador().getDataDemissao().before(this.periodoFolha.getDataFinalFolha()) ? linha.getColaborador().getDataDemissao() : this.periodoFolha.getDataFinalFolha();
            temp.setPossuiValorFixo(this.getPossuiValorFixo(linha));
            this.getDiasRecebimento(temp, this.periodoFolha.getDataInicialFolha(), dataFinalAux);
            lista.add(temp);
        }
        return lista;
    }

    private void getDiasRecebimento(TempFechamentoBeneficioVT temp, Date dataInicialFolha, Date dataFinalFolha) {
        dataFinalFolha = ToolDate.highDateTime((Date)dataFinalFolha);
        Double referenciaGeral = 0.0;
        Double diasFerias = 0.0;
        Double diasAfastados = 0.0;
        Long diasDesconto = 0L;
        Double diasAviso = 0.0;
        LinhaTransporteColaborador linha = temp.getLinha();
        System.out.println(temp.getLinha().getColaborador().toString());
        Colaborador colaborador = temp.getLinha().getColaborador();
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario() == null) {
            VOProcessResult.VOPRocessErro erro = new VOProcessResult.VOPRocessErro();
            erro.setDescricao("Verifique o cadastro do Horario: " + colaborador.getHorarioTrabalho().getIdentificador() + " do colaborador: " + colaborador.toString());
            this.result.addErro(erro);
            return;
        }
        if (colaborador == null || colaborador.getHorarioTrabalho() == null || colaborador.getHorarioTrabalho().getTurnoDeTrabalho() == null) {
            temp.setDiasCompetencia(0.0);
            temp.setDiasAPagar(0.0);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
            referenciaGeral = this.calcularReferenciaJornadaSemanal(colaborador, dataInicialFolha, dataFinalFolha);
            diasFerias = this.getDiasFerias(linha, dataInicialFolha, dataFinalFolha);
            diasAfastados = this.getDiasAfastamentos(linha, dataInicialFolha, dataFinalFolha);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
            referenciaGeral = this.calcularReferenciaJornadaRevezamento(colaborador, dataInicialFolha, dataFinalFolha);
            diasFerias = this.getDiasFerias(linha, dataInicialFolha, dataFinalFolha);
            diasAfastados = this.getDiasAfastamentos(linha, dataInicialFolha, dataFinalFolha);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) {
            referenciaGeral = this.calcularReferenciaJornada1236(colaborador, dataInicialFolha, dataFinalFolha);
            diasFerias = this.getDiasFerias(linha, dataInicialFolha, dataFinalFolha);
            diasAfastados = this.getDiasAfastamentos(linha, dataInicialFolha, dataFinalFolha);
        }
        diasDesconto = this.getDiasDesconto(colaborador, this.periodoFolha.getDataInicialVT(), this.periodoFolha.getDataFinalVT());
        diasAviso = this.getDiasAviso(colaborador, this.periodoFolha.getDataInicialFolha());
        temp.setDiasCompetencia(referenciaGeral);
        Double total = referenciaGeral - diasFerias - diasAfastados - (double)diasDesconto.longValue() - diasAviso;
        if (total <= 0.0) {
            total = 0.0;
        }
        temp.setDiasAPagar(total);
        temp.setDiasDescontoAfastamento(diasAfastados);
        temp.setDiasDescontoFerias(diasFerias);
        temp.setDiasDescontoPonto(diasDesconto.longValue());
        temp.setDiasAviso(diasAviso);
    }

    private Double calcularReferenciaJornadaSemanal(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        return this.calculoSemanalSemDiaDiferente(colaborador, inicioApuracao, finalApuracao);
    }

    private Double calculoSemanalSemDiaDiferente(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date inicioParametro = null;
        inicioParametro = colaborador.getDataAdmissao().after(inicioApuracao) ? colaborador.getDataAdmissao() : inicioApuracao;
        Integer contador = 0;
        do {
            Integer diaParametro = this.getDiaSemanal(inicioParametro);
            if (!this.diaNaoFeriado(inicioParametro, colaborador.getLocalTrabalhoColaboradorCidade().getCidade())) continue;
            for (InfoHorarioTrabalho dia : horario.getEsocCadastroHorario().getListaHorario()) {
                if (!dia.getDiaSemana().getDia().equals(diaParametro.shortValue()) || !dia.getFolga().equals((short)0)) continue;
                contador = contador + 1;
            }
        } while (finalApuracao.after(inicioParametro = ToolDate.nextDays((Date)inicioParametro, (int)1)) || finalApuracao.equals(inicioParametro));
        return contador.doubleValue();
    }

    private Integer getDiaSemanal(Date inicioParametro) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(inicioParametro);
        return g.get(7);
    }

    private boolean diaNaoFeriado(Date data, Cidade cidade) {
        Boolean diaEhFeriado = (Boolean)this.hashFeriados.get(data.getTime());
        Feriado feriado = null;
        Boolean buscaRealizada = false;
        if (diaEhFeriado == null) {
            feriado = this.serviceFeriado.findFeriadoPorDataAndCidade(data, cidade);
            buscaRealizada = true;
            diaEhFeriado = feriado == null || feriado.getTipoFeriado().equals((short)0) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            this.hashFeriados.put(data.getTime(), diaEhFeriado);
        }
        if (!diaEhFeriado.booleanValue() && (diaEhFeriado = (Boolean)this.hashFeriadosMunicipais.get(cidade.getIdentificador() + data.getTime())) == null) {
            if (!buscaRealizada.booleanValue()) {
                feriado = this.serviceFeriado.findFeriadoPorDataAndCidade(data, cidade);
            }
            if (feriado == null) {
                diaEhFeriado = false;
                this.hashFeriadosMunicipais.put(cidade.getIdentificador() + data.getTime(), diaEhFeriado);
            } else {
                diaEhFeriado = true;
                this.hashFeriadosMunicipais.put(cidade.getIdentificador() + data.getTime(), diaEhFeriado);
            }
        }
        return diaEhFeriado == false;
    }

    private Double getDiasFerias(LinhaTransporteColaborador linha, Date inicioApuracao, Date finalApuracao) {
        Colaborador colaborador = linha.getColaborador();
        List<FeriasColaborador> feriasColab = this.serviceFeriasColaborador.getFerias(colaborador, inicioApuracao, finalApuracao);
        Double diasFerias = 0.0;
        for (FeriasColaborador ferias : feriasColab) {
            Date parametroInicial = ferias.getDataGozoInicial().after(inicioApuracao) ? ferias.getDataGozoInicial() : inicioApuracao;
            Date parametroFinal = ferias.getDataGozoFinal().after(finalApuracao) ? finalApuracao : ferias.getDataGozoFinal();
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasFerias = this.calculoSemanalSemDiaDiferente(colaborador, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasFerias = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasFerias = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasFerias;
    }

    private Double getDiasAfastamentos(LinhaTransporteColaborador b, Date inicioApuracao, Date finalApuracao) {
        Colaborador colaborador = b.getColaborador();
        Double diasAfastamento = 0.0;
        List<AfastamentoColaborador> aux = this.serviceAfastamentoColaborador.getAfastamentosColaborador(colaborador, inicioApuracao, finalApuracao);
        for (AfastamentoColaborador af : aux) {
            Date parametroInicial = af.getDataAfastamento().after(inicioApuracao) ? af.getDataAfastamento() : inicioApuracao;
            Date parametroFinal = af.getDataRetorno() == null ? finalApuracao : (af.getDataRetorno().after(finalApuracao) ? finalApuracao : ToolDate.nextDays((Date)af.getDataRetorno(), (int)-1));
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasAfastamento = this.calculoSemanalSemDiaDiferente(colaborador, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasAfastamento = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasAfastamento = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasAfastamento;
    }

    private Double calcularReferenciaJornadaRevezamento(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        Date dataAdmissao;
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date inicioParametro = dataAdmissao = colaborador.getDataAdmissao();
        Integer contador = 0;
        Integer diasTrabalho = horario.getHorasTrabalhadasRevezamento().intValue();
        Integer diasFolga = horario.getHorasFolgasRevezamento().intValue();
        Integer diasAContar = diasTrabalho + diasFolga;
        boolean menor = true;
        Date dataProjecao = inicioParametro;
        if (dataAdmissao.before(inicioApuracao)) {
            while (menor = (dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(inicioApuracao)) {
            }
            menor = true;
            if (dataProjecao.equals(inicioApuracao)) {
                do {
                    Date dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(finalApuracao)) {
                        contador = contador + horario.getHorasTrabalhadasRevezamento().intValue();
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        contador = contador + 1;
                        menor = false;
                        continue;
                    }
                    Integer difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)finalApuracao);
                    if (difDias == diasAContar) {
                        difDias = difDias - 1;
                    }
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
            }
            if (dataProjecao.after(inicioApuracao)) {
                contador = 0;
                menor = true;
                Date dataUltimaProjecao = ToolDate.nextDays((Date)dataProjecao, (int)(-diasAContar.intValue()));
                Integer difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)inicioApuracao) + 1;
                Integer aux = 0;
                if (difDias == diasAContar) {
                    contador = contador + 0;
                } else {
                    aux = diasAContar - difDias;
                    contador = contador + aux;
                }
                dataProjecao = inicioApuracao;
                dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)(aux - 1));
                do {
                    dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(finalApuracao)) {
                        contador = contador + diasTrabalho;
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        menor = false;
                        continue;
                    }
                    difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)finalApuracao);
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
            }
        } else {
            contador = 0;
            menor = true;
            dataProjecao = dataAdmissao;
            do {
                Date dataUltimaProjecao = dataProjecao;
                if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)diasAContar)).before(finalApuracao)) {
                    contador = contador + diasTrabalho;
                    menor = true;
                    continue;
                }
                if (dataProjecao.equals(finalApuracao)) {
                    menor = false;
                    continue;
                }
                Integer difDias = ToolDate.diferenceDayBetweenDates((Date)dataUltimaProjecao, (Date)finalApuracao) + 1;
                if (difDias == diasAContar) {
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                    continue;
                }
                contador = contador + difDias;
                menor = false;
            } while (menor);
            return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
        }
        return 0.0;
    }

    private Double calcularReferenciaJornada1236(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        Date dataAdmissao;
        Date inicioParametro;
        Date dataProjecao = inicioParametro = (dataAdmissao = colaborador.getDataAdmissao());
        Integer contador = 0;
        boolean menor = true;
        if (dataAdmissao.before(inicioApuracao)) {
            while (menor = (dataProjecao = ToolDate.nextDays((Date)ToolDate.dataSemHora((Date)dataProjecao), (int)2)).before(inicioApuracao)) {
            }
        }
        menor = true;
        contador = contador + 1;
        do {
            if ((dataProjecao = ToolDate.nextDays((Date)dataProjecao, (int)2)).before(finalApuracao)) {
                contador = contador + 1;
                menor = true;
                continue;
            }
            if (dataProjecao.equals(finalApuracao)) {
                contador = contador + 1;
                menor = false;
                continue;
            }
            menor = false;
        } while (menor);
        return ToolFormatter.arrredondarNumero((Double)contador.doubleValue(), (int)2);
    }

    private Long getDiasDesconto(Colaborador colaborador, Date inicioApuracaoPonto, Date finalApuracaoPonto) {
        return this.serviceMovPtoColaborador.getDiasDesconto(colaborador, inicioApuracaoPonto, finalApuracaoPonto, (short)1);
    }

    private boolean valoresInformadosManuais(List<LinhaTransporteFechamento> linhas) {
        for (LinhaTransporteFechamento linha : linhas) {
            if (linha.getInformarValoresManuais() == null || !linha.getInformarValoresManuais().equals((short)1)) continue;
            return true;
        }
        return false;
    }

    private LinhaTransporteFechamento getLinhaTransporteFechamentoExiste(FechamentoColaboradorVT fechamento, ItemLinhaTransporteColaborador item) {
        for (LinhaTransporteFechamento linha : fechamento.getLinhas()) {
            if (!linha.getItemLinha().equals((Object)item)) continue;
            return linha;
        }
        return null;
    }

    VOProcessResult<FechamentoBeneficioVT> personalizado(List<LinhaTransporteColaborador> colaboradores) {
        List<TempFechamentoBeneficioVT> beneficios = this.convertToTemp(colaboradores);
        this.processar(beneficios);
        this.result.setResult((Object)this.fechamentoBeneficioVT);
        return this.result;
    }

    private Double getSaldoCartaoRecalculado(FechamentoColaboradorVT vt) {
        Double valor = 0.0;
        for (LinhaTransporteFechamento linha : vt.getLinhas()) {
            valor = valor + linha.getSaldoCartaoRecalc();
        }
        return valor;
    }

    VOProcessResult reprocessar(Colaborador colaborador) {
        List<TempFechamentoBeneficioVT> beneficios = this.reprocessarPagamentoBeneficioVT(colaborador);
        this.processar(beneficios);
        this.result.setResult((Object)this.fechamentoBeneficioVT);
        return this.result;
    }

    private List<TempFechamentoBeneficioVT> reprocessarPagamentoBeneficioVT(Colaborador colaborador) {
        List<LinhaTransporteColaborador> linhas = this.serviceLinhaTransporteColaborador.getBeneficiosColabAtivosPorColaborador(this.periodoFolha, colaborador);
        return this.convertToTemp(linhas);
    }

    private Short getPossuiValorFixo(LinhaTransporteColaborador linha) {
        for (ItemLinhaTransporteColaborador itemLinha : linha.getLinhasTransporte()) {
            if (!itemLinha.getAtiva().equals((short)1)) continue;
            return itemLinha.getLinhaTransporte().getPossuiValorFixo();
        }
        return (short)0;
    }

    private Double getValorFixo(LinhaTransporteColaborador linha) {
        for (ItemLinhaTransporteColaborador itemLinha : linha.getLinhasTransporte()) {
            if (!itemLinha.getAtiva().equals((short)1)) continue;
            return itemLinha.getLinhaTransporte().getTarifa();
        }
        return 0.0;
    }

    private boolean validarPeriodo(ItemLinhaTransporteColaborador item) {
        PeriodoFolhaPagamento periodo = this.periodoFolha;
        if (item.getDataFinal() == null && (item.getDataInicio().equals(ToolDate.getDateLastMonthDay((Date)periodo.getDataInicialFolha())) || item.getDataInicio().before(ToolDate.getDateLastMonthDay((Date)periodo.getDataInicialFolha())))) {
            return true;
        }
        if (item.getDataInicio().after(periodo.getDataFinalFolha())) {
            return false;
        }
        if ((item.getDataInicio().equals(ToolDate.getDateFirstMonthDay((Date)periodo.getDataInicialFolha())) || item.getDataInicio().before(ToolDate.getDateLastMonthDay((Date)periodo.getDataInicialFolha()))) && item.getDataFinal().after(ToolDate.getDateLastMonthDay((Date)periodo.getDataInicialFolha()))) {
            return true;
        }
        return !item.getDataFinal().before(ToolDate.getDateLastMonthDay((Date)periodo.getDataInicialFolha()));
    }

    private Double getDiasAviso(Colaborador colaborador, Date dataInico) {
        if (colaborador.getNumeroRegistro().equals("999")) {
            System.out.println("");
        }
        if (colaborador.getDataDemissao() == null) {
            return 0.0;
        }
        Double referenciaGeral = 0.0;
        for (Recisao r : colaborador.getRecisoes()) {
            if (!r.getRecisaoComplementar().equals((short)0)) continue;
            if (!r.getAvisoIndenizado().equals((short)1)) {
                return 0.0;
            }
            if (!r.getEmissaoAviso().getTipoAviso().getCodigo().equals("2")) continue;
            Date inicioAviso = null;
            Date finalAviso = colaborador.getDataDemissao();
            inicioAviso = ToolDate.nextDays((Date)finalAviso, (int)-6);
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                referenciaGeral = this.calcularReferenciaJornadaSemanal(colaborador, inicioAviso, finalAviso);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                referenciaGeral = this.calcularReferenciaJornadaRevezamento(colaborador, inicioAviso, finalAviso);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) {
                referenciaGeral = this.calcularReferenciaJornada1236(colaborador, inicioAviso, finalAviso);
            }
            return referenciaGeral;
        }
        return 0.0;
    }

    class TempFechamentoBeneficioVT {
        private LinhaTransporteColaborador linha;
        private double diasAPagar;
        private double diasCompetencia;
        private short possuiValorFixo;
        private double diasDescontoFerias;
        private double diasDescontoAfastamento;
        private double diasDescontoPonto;
        private double diasAviso;

        public TempFechamentoBeneficioVT(AuxFechamentoBeneficioVT this$0, LinhaTransporteColaborador beneficio) {
            this.linha = beneficio;
            this.diasCompetencia = 0.0;
            this.diasDescontoPonto = 0.0;
            this.diasDescontoFerias = 0.0;
            this.diasAPagar = 0.0;
            this.diasAviso = 0.0;
        }

        public LinhaTransporteColaborador getLinha() {
            return this.linha;
        }

        public void setLinha(LinhaTransporteColaborador linha) {
            this.linha = linha;
        }

        public double getDiasAPagar() {
            return this.diasAPagar;
        }

        public void setDiasAPagar(double diasAPagar) {
            this.diasAPagar = diasAPagar;
        }

        public double getDiasCompetencia() {
            return this.diasCompetencia;
        }

        public void setDiasCompetencia(double diasCompetencia) {
            this.diasCompetencia = diasCompetencia;
        }

        public short getPossuiValorFixo() {
            return this.possuiValorFixo;
        }

        public void setPossuiValorFixo(short possuiValorFixo) {
            this.possuiValorFixo = possuiValorFixo;
        }

        public double getDiasDescontoFerias() {
            return this.diasDescontoFerias;
        }

        public void setDiasDescontoFerias(double diasDescontoFerias) {
            this.diasDescontoFerias = diasDescontoFerias;
        }

        public double getDiasDescontoAfastamento() {
            return this.diasDescontoAfastamento;
        }

        public void setDiasDescontoAfastamento(double diasDescontoAfastamento) {
            this.diasDescontoAfastamento = diasDescontoAfastamento;
        }

        public double getDiasDescontoPonto() {
            return this.diasDescontoPonto;
        }

        public void setDiasDescontoPonto(double diasDescontoPonto) {
            this.diasDescontoPonto = diasDescontoPonto;
        }

        public double getDiasAviso() {
            return this.diasAviso;
        }

        public void setDiasAviso(double diasAviso) {
            this.diasAviso = diasAviso;
        }
    }
}

