/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentoordemservico;

import com.touchcomp.basementor.constants.enums.fechamentoordemservico.status.EnumConstStatusServico;
import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.FechamOrdemServicoColeta;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.coleta.CompColeta;
import com.touchcomp.basementorservice.components.consumo.CompConsumoAtivo;
import com.touchcomp.basementorservice.helpers.impl.fechamentoordemservico.HelperFechamentoOrdemServico;
import com.touchcomp.basementorservice.service.impl.coleta.ServiceColetaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class AuxFechamentoOrdemServico {
    final ServiceColetaImpl serviceColetaImpl;
    final CompColeta compColeta;
    final CompConsumoAtivo compConsumoAtivo;
    final HelperFechamentoOrdemServico helperFechamentoOrdemServico;

    public AuxFechamentoOrdemServico(ServiceColetaImpl serviceColetaImpl, CompColeta compColeta, CompConsumoAtivo compConsumoAtivo, HelperFechamentoOrdemServico helperFechamentoOrdemServico) {
        this.serviceColetaImpl = serviceColetaImpl;
        this.compColeta = compColeta;
        this.compConsumoAtivo = compConsumoAtivo;
        this.helperFechamentoOrdemServico = helperFechamentoOrdemServico;
    }

    public void gerarDadosFechamentoOrdemServico(FechamentoOrdemServico vo, OpcoesManutencEquip opcoesManutencEquip) throws ExceptionValidacaoDados, ExceptionParamCtbRequisicao {
        if (TMethods.isNotNull((Object)vo.getDataFechamento()).booleanValue()) {
            this.gerarAtualizarConsumo(vo, opcoesManutencEquip);
            this.gerarColeta(vo);
            OrdemServico os = vo.getOrdemServico();
            if (ToolMethods.isAffirmative((Number)vo.getOsFechada())) {
                os.setStatus(Short.valueOf(EnumConstStatusOrdemServico.FECHADA.getValue()));
                if (os.getCronogramaOrdemServico() != null) {
                    os.getCronogramaOrdemServico().setStatus(Short.valueOf(EnumConstStatusOrdemServico.FECHADA.getValue()));
                }
            } else {
                os.setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
                if (os.getCronogramaOrdemServico() != null) {
                    os.getCronogramaOrdemServico().setStatus(Short.valueOf(EnumConstStatusOrdemServico.ABERTO.getValue()));
                }
            }
        }
        this.atualizaStatusExecucao(vo);
    }

    public void gerarColeta(FechamentoOrdemServico fechamento) throws ExceptionValidacaoDados {
        for (FechamOrdemServicoColeta f : fechamento.getFechamOrdemServicoColeta()) {
            Coleta c = this.compColeta.getColeta(fechamento, f);
            c = this.serviceColetaImpl.saveOrUpdate(c);
            f.setColeta(c);
        }
    }

    public void gerarAtualizarConsumo(FechamentoOrdemServico fechamento, OpcoesManutencEquip opcoesManutencEquip) throws ExceptionParamCtbRequisicao {
        ConsumoAtivo consumo = this.compConsumoAtivo.criarAtualizarConsumoAtivo(fechamento, opcoesManutencEquip);
        fechamento.setConsumoAtivo(consumo);
    }

    private void atualizaStatusExecucao(FechamentoOrdemServico vo) {
        for (ServicoProcedimento s : vo.getServicoProcedimentos()) {
            EnumConstStatusServico status = this.helperFechamentoOrdemServico.getStatusServico(s.getProcedimento());
            if (status == null) continue;
            s.setExecutado(Short.valueOf(status.getValue()));
        }
    }
}

