/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentoordemservico;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.fechamentoordemservico.status.EnumConstStatusServico;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.OcorrenciaCausa;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementorservice.helpers.impl.ordemservico.HelperOrdemServico;
import com.touchcomp.basementorservice.service.impl.ordemservico.ServiceOrdemServicoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuxGerarOSServicosPendentes {
    final ServiceOrdemServicoImpl serviceOrdemServicoImpl;
    final HelperOrdemServico helperOrdemServico;

    public AuxGerarOSServicosPendentes(ServiceOrdemServicoImpl serviceOrdemServicoImpl, HelperOrdemServico helperOrdemServico) {
        this.serviceOrdemServicoImpl = serviceOrdemServicoImpl;
        this.helperOrdemServico = helperOrdemServico;
    }

    FechamentoOrdemServico gerarOrdemServico(FechamentoOrdemServico fechamento, OpcoesManutencEquip opcoesManutencEquip) {
        ArrayList<ServicoProcedimento> servicosPendentes = new ArrayList<ServicoProcedimento>();
        for (ServicoProcedimento servicoProcedimento : fechamento.getServicoProcedimentos()) {
            if (!servicoProcedimento.getExecutado().equals(EnumConstStatusServico.PENDENTE.getValue())) continue;
            servicosPendentes.add(servicoProcedimento);
        }
        if (servicosPendentes.isEmpty()) {
            return null;
        }
        OrdemServico ordemServicoGerada = this.helperOrdemServico.build(fechamento, opcoesManutencEquip);
        ordemServicoGerada = this.serviceOrdemServicoImpl.saveOrUpdate(ordemServicoGerada);
        FechamentoOrdemServico fechamentoGerado = this.buildFechamentoOS(ordemServicoGerada, fechamento, servicosPendentes);
        fechamento.setFechamentoGerado(fechamentoGerado);
        return fechamento;
    }

    public FechamentoOrdemServico buildFechamentoOS(OrdemServico ordemServicoGerada, FechamentoOrdemServico fechamento, List<ServicoProcedimento> servicosPendentes) {
        FechamentoOrdemServico fechamentoGerado = new FechamentoOrdemServico();
        fechamentoGerado.setDataCadastro(new Date());
        fechamentoGerado.setEmpresa(fechamento.getEmpresa());
        fechamentoGerado.setOrdemServico(ordemServicoGerada);
        fechamentoGerado.setOsFechada(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        fechamentoGerado.setServicoProcedimentos(this.getServicosProcedimentos(servicosPendentes, fechamentoGerado));
        fechamentoGerado.setFechamentoOrigem(fechamento);
        ordemServicoGerada.setFechamentoOrdemServico(fechamentoGerado);
        return fechamentoGerado;
    }

    private List<ServicoProcedimento> getServicosProcedimentos(List<ServicoProcedimento> servicosPendentes, FechamentoOrdemServico fechamentoGerado) {
        ArrayList<ServicoProcedimento> servicoProcedimentoToReturn = new ArrayList<ServicoProcedimento>();
        for (ServicoProcedimento servicoProcedimento : servicosPendentes) {
            ServicoProcedimento servicoProcedimentoToAdd = new ServicoProcedimento();
            servicoProcedimentoToAdd.setDataCadastro(new Date());
            servicoProcedimentoToAdd.setEmpresa(servicoProcedimento.getEmpresa());
            servicoProcedimentoToAdd.setFechamentoOrdemServico(fechamentoGerado);
            servicoProcedimentoToAdd.setServico(servicoProcedimento.getServico());
            servicoProcedimentoToAdd.setOcorrenciaCausa(this.getOcorrenciasCausas(servicoProcedimento, servicoProcedimentoToAdd));
            servicoProcedimentoToAdd.setProcedimento(AuxGerarOSServicosPendentes.getProcedimentos(servicoProcedimento, servicoProcedimentoToAdd));
            servicoProcedimentoToReturn.add(servicoProcedimentoToAdd);
        }
        return servicoProcedimentoToReturn;
    }

    private static List<Procedimento> getProcedimentos(ServicoProcedimento servicoProcedimento, ServicoProcedimento servicoProcedimentoToAdd) {
        ArrayList<Procedimento> procedimentosToReturn = new ArrayList<Procedimento>();
        for (Procedimento procedimento : servicoProcedimento.getProcedimento()) {
            if (procedimento.getExecutado() == null || !ToolMethods.isEquals((Object)procedimento.getExecutado(), (Object)EnumConstStatusServico.PENDENTE.getValue())) continue;
            Procedimento procedimentoToAdd = new Procedimento();
            procedimentoToAdd.setDataCadastro(new Date());
            procedimentoToAdd.setDescricao(procedimento.getDescricao());
            procedimentoToAdd.setEmpresa(procedimento.getEmpresa());
            procedimentoToAdd.setServicoProcedimento(servicoProcedimentoToAdd);
            procedimentosToReturn.add(procedimentoToAdd);
        }
        return procedimentosToReturn;
    }

    private List<OcorrenciaCausa> getOcorrenciasCausas(ServicoProcedimento servicoProcedimento, ServicoProcedimento servicoProcedimentoToAdd) {
        ArrayList<OcorrenciaCausa> ocorrenciasCausasToReturn = new ArrayList<OcorrenciaCausa>();
        for (OcorrenciaCausa ocorrenciaCausa : servicoProcedimento.getOcorrenciaCausa()) {
            OcorrenciaCausa ocorrenciaCausaToAdd = new OcorrenciaCausa();
            ocorrenciaCausaToAdd.setCausa(ocorrenciaCausa.getCausa());
            ocorrenciaCausaToAdd.setDataCadastro(new Date());
            ocorrenciaCausaToAdd.setEmpresa(ocorrenciaCausa.getEmpresa());
            ocorrenciaCausaToAdd.setOcorrencia(ocorrenciaCausa.getOcorrencia());
            ocorrenciaCausaToAdd.setServicoProcedimento(servicoProcedimentoToAdd);
            ocorrenciasCausasToReturn.add(ocorrenciaCausaToAdd);
        }
        return ocorrenciasCausasToReturn;
    }
}

