/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentoordemservico;

import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.service.impl.fechamentoordemservico.ServiceFechamentoOrdemServicoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AuxValidarExecOutrasOS {
    final ServiceFechamentoOrdemServicoImpl serviceFechamentoOrdemServico;

    public AuxValidarExecOutrasOS(ServiceFechamentoOrdemServicoImpl serviceFechamentoOrdemServico) {
        this.serviceFechamentoOrdemServico = serviceFechamentoOrdemServico;
    }

    public void validaExecutantesOutrasOS(List<Executante> executantes, Long idFechamentoOrdemServico) throws ExceptionValidacaoDados {
        List<HashMap> listaInvalida = this.validaExecutanteEmOutrasOS(executantes, idFechamentoOrdemServico);
        if (listaInvalida != null && !listaInvalida.isEmpty()) {
            Object horarios = "";
            for (HashMap hashMap : listaInvalida) {
                FechamentoOrdemServico fechamento = (FechamentoOrdemServico)hashMap.get("fechamento");
                Executante executante = (Executante)hashMap.get("executante");
                horarios = (String)horarios + "\n-Fechamento " + (String)(fechamento.getIdentificador() != null ? "Id. " + fechamento.getIdentificador() : "novo") + "\nExecutante " + executante.getPessoa().getNome() + "\nHor\u00e1rio: " + ToolDate.dateToStr((Date)new Date(executante.getDataHoraInicio().getTime()), (String)"dd/MM/yyyy-HH:mm") + " - " + ToolDate.dateToStr((Date)new Date(executante.getDataHoraFinal().getTime()), (String)"dd/MM/yyyy-HH:mm") + "\n";
            }
            throw new ExceptionValidacaoDados("E.ERP.0742.001", new Object[]{horarios});
        }
    }

    public void validaExecutanteOutrasOS(Executante executante, Long idFechamentoOrdemServico) throws ExceptionValidacaoDados {
        HashMap conflitoHorarios = this.findExecutanteOcupadoEmOutraOS(executante, idFechamentoOrdemServico);
        if (conflitoHorarios != null) {
            FechamentoOrdemServico fechamento = (FechamentoOrdemServico)conflitoHorarios.get("fechamento");
            Executante exec = (Executante)conflitoHorarios.get("executante");
            String horarios = "\n-Fechamento " + (String)(fechamento.getIdentificador() != null ? "Id. " + fechamento.getIdentificador() : "novo") + "\nExecutante " + exec.getPessoa().getNome() + "\nHor\u00e1rio: " + ToolDate.dateToStr((Date)new Date(exec.getDataHoraInicio().getTime()), (String)"dd/MM/yyyy-HH:mm") + " - " + ToolDate.dateToStr((Date)new Date(exec.getDataHoraFinal().getTime()), (String)"dd/MM/yyyy-HH:mm") + "\n";
            throw new ExceptionValidacaoDados("E.ERP.0742.001", new Object[]{horarios});
        }
    }

    private List<HashMap> validaExecutanteEmOutrasOS(List<Executante> executantes, Long idFechamentoOrdemServico) {
        ArrayList<HashMap> toReturn = new ArrayList<HashMap>();
        if (executantes.size() > 1) {
            for (Executante executante1 : executantes) {
                for (Executante executante2 : executantes) {
                    if (executante1.equals((Object)executante2) || !executante1.getPessoa().equals((Object)executante2.getPessoa()) || !ToolDate.dateBetween((Date)executante1.getDataHoraInicio(), (Date)executante2.getDataHoraInicio(), (Date)executante2.getDataHoraFinal()).booleanValue() && !ToolDate.dateBetween((Date)executante1.getDataHoraFinal(), (Date)executante2.getDataHoraInicio(), (Date)executante2.getDataHoraFinal()).booleanValue()) continue;
                    HashMap<String, Executante> hashMap = new HashMap<String, Executante>();
                    hashMap.put("executante", executante1);
                    hashMap.put("fechamento", null);
                    if (toReturn.contains(hashMap)) continue;
                    toReturn.add(hashMap);
                }
            }
        }
        toReturn.addAll(this.findExecutanteOcupadoEmOutraOS(executantes, idFechamentoOrdemServico));
        return toReturn;
    }

    public List<HashMap> findExecutanteOcupadoEmOutraOS(List<Executante> executantes, Long idFechamentoOrdemServico) {
        ArrayList<HashMap> hashsToReturn = new ArrayList<HashMap>();
        for (Executante executante : executantes) {
            HashMap hash = this.findExecutanteOcupadoEmOutraOS(executante, idFechamentoOrdemServico);
            if (hash == null) continue;
            hashsToReturn.add(hash);
        }
        return hashsToReturn;
    }

    public HashMap findExecutanteOcupadoEmOutraOS(Executante executante, Long idFechamentoOrdemServico) {
        Iterator<FechamentoOrdemServico> iterator;
        List<FechamentoOrdemServico> listFecham = this.serviceFechamentoOrdemServico.findFechamentoOSporExecutanteOcupado(executante, idFechamentoOrdemServico);
        if (listFecham != null && !listFecham.isEmpty() && (iterator = listFecham.iterator()).hasNext()) {
            FechamentoOrdemServico f = iterator.next();
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("fechamento", f);
            hash.put("executante", executante);
            return hash;
        }
        return null;
    }
}

