/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentoordemservico;

import com.touchcomp.basementor.constants.enums.fechamentoordemservico.status.EnumConstStatusProcedimento;
import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamOrdemServicoColeta;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.HoraParadaRetornoAtivo;
import com.touchcomp.basementor.model.vo.OcorrenciaCausa;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.Procedimento;
import com.touchcomp.basementor.model.vo.ProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.ServicoManutencao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.coleta.CompColeta;
import com.touchcomp.basementorservice.components.consumo.CompConsumoAtivo;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.impl.fechamentoordemservico.CompFechamentoOrdemServicoLancGer;
import com.touchcomp.basementorservice.dao.impl.DaoFechamentoOrdemServicoImpl;
import com.touchcomp.basementorservice.helpers.impl.fechamentoordemservico.HelperFechamentoOrdemServico;
import com.touchcomp.basementorservice.helpers.impl.ordemservico.HelperOrdemServico;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.coleta.ServiceColetaImpl;
import com.touchcomp.basementorservice.service.impl.fechamentoordemservico.AuxFechamentoOrdemServico;
import com.touchcomp.basementorservice.service.impl.fechamentoordemservico.AuxGerarOSServicosPendentes;
import com.touchcomp.basementorservice.service.impl.fechamentoordemservico.AuxValidarExecOutrasOS;
import com.touchcomp.basementorservice.service.impl.ordemservico.ServiceOrdemServicoImpl;
import com.touchcomp.basementorservice.service.impl.servicomanutencao.ServiceServicoManutencaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.fechamentoordemservico.web.DTOFechamentoOrdemServico;
import com.touchcomp.touchvomodel.vo.procedimento.web.DTOProcedimento;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceFechamentoOrdemServicoImpl
extends ServiceGenericEntityImpl<FechamentoOrdemServico, Long, DaoFechamentoOrdemServicoImpl> {
    final CompFechamentoOrdemServicoLancGer compFechamentoOrdemServicoLancGer;
    final HelperFechamentoOrdemServico helperFechamentoOrdemServico;
    final ServiceOrdemServicoImpl serviceOrdemServicoImpl;
    final ServiceServicoManutencaoImpl serviceServicoManutencao;
    final HelperOrdemServico helperOrdemServico;
    final ServiceColetaImpl serviceColetaImpl;
    final CompColeta compColeta;
    final CompConsumoAtivo compConsumoAtivo;
    final ServiceColaboradorImpl serviceColaborador;

    public ServiceFechamentoOrdemServicoImpl(CompFechamentoOrdemServicoLancGer compFechamentoOrdemServicoLancGer, HelperFechamentoOrdemServico helperFechamentoOrdemServico, ServiceOrdemServicoImpl serviceOrdemServicoImpl, HelperOrdemServico helperOrdemServico, ServiceColetaImpl serviceColetaImpl, CompColeta compColeta, CompConsumoAtivo compConsumoAtivo, ServiceServicoManutencaoImpl serviceServicoManutencao, ServiceColaboradorImpl serviceColaborador, DaoFechamentoOrdemServicoImpl genericDao) {
        super(genericDao);
        this.compFechamentoOrdemServicoLancGer = compFechamentoOrdemServicoLancGer;
        this.helperFechamentoOrdemServico = helperFechamentoOrdemServico;
        this.serviceOrdemServicoImpl = serviceOrdemServicoImpl;
        this.helperOrdemServico = helperOrdemServico;
        this.serviceColetaImpl = serviceColetaImpl;
        this.compColeta = compColeta;
        this.compConsumoAtivo = compConsumoAtivo;
        this.serviceServicoManutencao = serviceServicoManutencao;
        this.serviceColaborador = serviceColaborador;
    }

    public List<FechamentoOrdemServico> findFechamentoOSporExecutanteOcupado(Executante executante, Long idFechamentoOrdemServico) {
        return ((DaoFechamentoOrdemServicoImpl)this.getGenericDao()).findFechamentoOSporExecutanteOcupado(executante, idFechamentoOrdemServico);
    }

    public FechamentoOrdemServico getFechamentoByOrdemServico(OrdemServico ordem) {
        return ((DaoFechamentoOrdemServicoImpl)this.getGenericDao()).getFechamentoByOrdemServico(ordem);
    }

    @Override
    public FechamentoOrdemServico beforeSave(FechamentoOrdemServico vo) {
        if (this.isNotNull(vo.getServicoProcedimentos()).booleanValue()) {
            for (ServicoProcedimento sp : vo.getServicoProcedimentos()) {
                sp.setFechamentoOrdemServico(vo);
                for (OcorrenciaCausa o : sp.getOcorrenciaCausa()) {
                    o.setServicoProcedimento(sp);
                }
                for (Procedimento p : sp.getProcedimento()) {
                    p.setServicoProcedimento(sp);
                    if (p.getProdutosPrevisaoManutencao() == null) continue;
                    for (ProdutoPrevManutencao pm : p.getProdutosPrevisaoManutencao()) {
                        pm.setProcedimento(p);
                    }
                }
            }
        }
        if (this.isNotNull(vo.getExecutantes()).booleanValue()) {
            for (Executante e : vo.getExecutantes()) {
                e.setFechamentoOrdemServico(vo);
            }
        }
        if (this.isNotNull(vo.getHoraParadaRetornoAtivo()).booleanValue()) {
            for (HoraParadaRetornoAtivo h : vo.getHoraParadaRetornoAtivo()) {
                h.setFechamentoOS(vo);
            }
        }
        if (this.isNotNull(vo.getFechamOrdemServicoColeta()).booleanValue()) {
            for (FechamOrdemServicoColeta fo : vo.getFechamOrdemServicoColeta()) {
                fo.setFechamentoOrdemServico(vo);
            }
        }
        this.helperFechamentoOrdemServico.build(vo).calculaVlrExecutantes();
        this.helperFechamentoOrdemServico.build(vo).calculaVlrCustoTotal();
        try {
            new AuxFechamentoOrdemServico(this.serviceColetaImpl, this.compColeta, this.compConsumoAtivo, this.helperFechamentoOrdemServico).gerarDadosFechamentoOrdemServico(vo, this.getSharedData().getOpcoesManutencaoEquip(vo.getEmpresa()));
        }
        catch (ExceptionParamCtbRequisicao | ExceptionValidacaoDados ex) {
            throw new ExceptionRuntimeBase(ex.getFormattedMessage());
        }
        return vo;
    }

    public Executante getExecutanteByColaborador(String matricula, Long fechamentoOSIdentificador, Long dataAb, Long horaAb, Long dataFec, Long horaFec, Empresa empresa) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        Colaborador colaborador = this.serviceColaborador.getColaboradorPorNumeroRegistro(matricula);
        if (this.isNotNull(colaborador).booleanValue()) {
            this.reload(empresa);
            Executante executante = this.helperFechamentoOrdemServico.buildExecutante(colaborador, empresa, dataAb, horaAb, dataFec, horaFec);
            new AuxValidarExecOutrasOS(this).validaExecutanteOutrasOS(executante, fechamentoOSIdentificador);
            return executante;
        }
        throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0516.001", new String[]{matricula}));
    }

    public Executante getExecutanteByColaborador(Long idColaborador, Long fechamentoOSIdentificador, Long dataAb, Long horaAb, Long dataFec, Long horaFec, Empresa empresa) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        Colaborador colaborador = (Colaborador)this.serviceColaborador.getOrThrow(idColaborador);
        if (this.isNotNull(colaborador).booleanValue()) {
            Executante executante = this.helperFechamentoOrdemServico.buildExecutante(colaborador, empresa, dataAb, horaAb, dataFec, horaFec);
            new AuxValidarExecOutrasOS(this).validaExecutanteOutrasOS(executante, fechamentoOSIdentificador);
            return executante;
        }
        throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0516.001", new Object[]{idColaborador}));
    }

    public Executante getExecutanteByColaborador(Long idColaborador, Long fechamentoOSIdentificador, Long dataAb, Long dataFec, Empresa empresa) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        Colaborador colaborador = (Colaborador)this.serviceColaborador.getOrThrow(idColaborador);
        if (this.isNotNull(colaborador).booleanValue()) {
            Executante executante = this.helperFechamentoOrdemServico.buildExecutante(colaborador, empresa, new Date(dataAb), new Date(dataFec));
            new AuxValidarExecOutrasOS(this).validaExecutanteOutrasOS(executante, fechamentoOSIdentificador);
            return executante;
        }
        throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0516.001", new Object[]{idColaborador}));
    }

    public DTOFechamentoOrdemServico.DTOServicoProcedimento adicionarServico(Long servicoIdentificador, EnumConstStatusProcedimento status, String procedimento, Empresa empresa) throws ExceptionObjNotFound, ExceptionInvalidData {
        ServicoManutencao servico = (ServicoManutencao)this.serviceServicoManutencao.getOrThrow(servicoIdentificador);
        ServicoProcedimento servicoProcedimento = this.helperFechamentoOrdemServico.buildServicoProcedimento(servico, status, procedimento, empresa);
        return this.buildToDTOGeneric(servicoProcedimento, DTOFechamentoOrdemServico.DTOServicoProcedimento.class);
    }

    public DTOFechamentoOrdemServico.DTOServicoProcedimento adicionarProcedimento(DTOFechamentoOrdemServico.DTOServicoProcedimento dto, EnumConstStatusProcedimento status, String procedimento, Empresa empresa) throws ExceptionObjNotFound, ExceptionInvalidData {
        Procedimento vo = this.helperFechamentoOrdemServico.buildProcedimento(status, procedimento, empresa);
        if (TMethods.isNull((Object)dto.getProcedimento()).booleanValue()) {
            dto.setProcedimento(new LinkedList());
        }
        dto.getProcedimento().add(this.buildToDTOGeneric(vo, DTOProcedimento.class));
        return dto;
    }

    @Override
    public FechamentoOrdemServico afterSaveEntity(FechamentoOrdemServico vo) {
        if (this.isNotNull(vo.getDataFechamento()).booleanValue()) {
            OpcoesManutencEquip opManu = this.getSharedData().getOpcoesManutencaoEquip(vo.getEmpresa());
            this.compFechamentoOrdemServicoLancGer.gerarLancGerenciais(vo, opManu);
            if (ToolMethods.isAffirmative((Number)opManu.getGerarNovaOS()) && TMethods.isEquals((Object)EnumConstStatusOrdemServico.FECHADA.getValue(), (Object)vo.getOrdemServico().getStatus())) {
                FechamentoOrdemServico ordemServico = new AuxGerarOSServicosPendentes(this.serviceOrdemServicoImpl, this.helperOrdemServico).gerarOrdemServico(vo, opManu);
                vo.setFechamentoOrigem(ordemServico);
            }
        }
        return vo;
    }
}

