/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fechamentoperiodo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.CalculoInssAberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoPeriodo;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoFechamentoPeriodoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.calculoinssempresa.ServiceCalculoInssEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.itemmovimentoferias.ServiceItemMovimentoFeriasImpl;
import com.touchcomp.basementorservice.service.impl.itemmovimentofolha.ServiceItemMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.remessafolhafechamentoperiodo.ServiceRemessaFolhaFechamentoPeriodoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.calculoinssempresa.web.DTOCalculoInssEmpresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFechamentoPeriodoImpl
extends ServiceGenericEntityImpl<FechamentoPeriodo, Long, DaoFechamentoPeriodoImpl> {
    ServiceItemMovimentoFeriasImpl serviceItemMovimentoFeriasImpl;
    ServiceRemessaFolhaFechamentoPeriodoImpl serviceRemessaFolhaFechamentoPeriodoImpl;
    ServiceItemMovimentoFolhaImpl serviceItemMovimentoFolhaImpl;
    ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl;
    ServiceCalculoInssEmpresaImpl serviceCalculoInssEmpresaImpl;

    @Autowired
    public ServiceFechamentoPeriodoImpl(DaoFechamentoPeriodoImpl dao, ServiceItemMovimentoFeriasImpl serviceItemMovimentoFeriasImpl, ServiceRemessaFolhaFechamentoPeriodoImpl serviceRemessaFolhaFechamentoPeriodoImpl, ServiceItemMovimentoFolhaImpl serviceItemMovimentoFolhaImpl, ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl, ServiceCalculoInssEmpresaImpl serviceCalculoInssEmpresaImpl) {
        super(dao);
        this.serviceItemMovimentoFeriasImpl = serviceItemMovimentoFeriasImpl;
        this.serviceRemessaFolhaFechamentoPeriodoImpl = serviceRemessaFolhaFechamentoPeriodoImpl;
        this.serviceItemMovimentoFolhaImpl = serviceItemMovimentoFolhaImpl;
        this.serviceMovimentoFolhaImpl = serviceMovimentoFolhaImpl;
        this.serviceCalculoInssEmpresaImpl = serviceCalculoInssEmpresaImpl;
    }

    public List<Recisao> finfRecisoesNaoIntegradas(Date dataInicial, Date dataFinal, Empresa empresa) {
        return ((DaoFechamentoPeriodoImpl)this.getGenericDao()).findRecisoesNaoIntegradas(dataInicial, dataFinal, empresa);
    }

    public FechamentoPeriodo getFechamentoByCalculoInss(CalculoInssEmpresa calculo) {
        return ((DaoFechamentoPeriodoImpl)this.getDao()).getFechamentoByCalculoInss(calculo);
    }

    public List<FechamentoPeriodo> getFechamentosPeriodosByCalculoInss(CalculoInssEmpresa calculo) {
        return ((DaoFechamentoPeriodoImpl)this.getGenericDao()).getFechamentosPeriodosByCalculoInss(calculo.getIdentificador());
    }

    @Override
    public FechamentoPeriodo beforeSaveEntity(FechamentoPeriodo vo) {
        if (this.isEquals(vo.getAtivo(), EnumConstantsMentorSimNao.SIM.getValue())) {
            vo.setLogExclusaoFechamentoPeriodo(null);
            Date periodoFolha = vo.getCalculoInss().getPeriodoFolha();
            Date dataInicial = ToolDate.getDateFirstMonthDay((Date)periodoFolha);
            Date dataFinal = ToolDate.getDateLastMonthDay((Date)periodoFolha);
            if (ServiceFechamentoPeriodoImpl.isWithData(this.getFechamentosPeriodosByCalculoInss(vo.getCalculoInss()))) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1098.001"));
            }
            List<Object> recisoesNaoIntegradas = new ArrayList();
            List<Object> feriasNaoIntegradas = new ArrayList();
            if (vo.getCalculoInss().getTipoCalculo() != null && this.isEquals(vo.getCalculoInss().getTipoCalculo().getTipoFolha(), EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                recisoesNaoIntegradas = this.finfRecisoesNaoIntegradas(dataInicial, dataFinal, vo.getEmpresa());
                feriasNaoIntegradas = this.serviceItemMovimentoFeriasImpl.findFeriasNaoIntegradas(dataInicial, dataFinal, vo.getEmpresa());
            }
            if (ServiceFechamentoPeriodoImpl.isWithData(recisoesNaoIntegradas)) {
                String aux = recisoesNaoIntegradas.stream().map(r -> MessagesBaseMentor.getMsg((String)"E.ERP.1098.002", (Object[])new Object[]{r.getIdentificador(), r.getColaborador().getPessoa().getNome()})).collect(Collectors.joining("|"));
                throw new ExceptionRuntimeBase(aux);
            }
            if (ServiceFechamentoPeriodoImpl.isWithData(feriasNaoIntegradas)) {
                String aux = feriasNaoIntegradas.stream().map(f -> MessagesBaseMentor.getMsg((String)"E.ERP.1098.003", (Object[])new Object[]{f.getFerias().getIdentificador(), f.getEventoColaborador().getColaborador().getPessoa().getNome()})).collect(Collectors.joining("|"));
                throw new ExceptionRuntimeBase(aux);
            }
            for (CalculoInssAberturaPeriodo c : vo.getCalculoInss().getAberturasPeriodo()) {
                if (!ServiceFechamentoPeriodoImpl.isWithData(this.serviceItemMovimentoFolhaImpl.getFolhasAbertasByAberturaPeriodo(c.getAberturaPeriodo().getIdentificador()))) continue;
                this.serviceMovimentoFolhaImpl.fecharFolhasPagamento(c.getAberturaPeriodo().getIdentificador());
            }
        } else {
            if (ServiceFechamentoPeriodoImpl.isWithData(this.serviceRemessaFolhaFechamentoPeriodoImpl.getRemessaFolhaFechamentoPeriodoByFechamentoPeriodo(vo.getIdentificador()))) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1098.004"));
            }
            String descricaoAbertura = vo.getCalculoInss().getAberturasPeriodo().stream().map(a -> a.getAberturaPeriodo().toString()).collect(Collectors.joining(","));
            vo.getLogExclusaoFechamentoPeriodo().setAbertura(descricaoAbertura);
            vo.setCalculoInss(null);
            vo.setTitulos(new ArrayList());
        }
        return vo;
    }

    public DTOCalculoInssEmpresa getCalculoInssEmpresa(Long idCalculoInssEmpresa) throws ExceptionObjNotFound {
        CalculoInssEmpresa calculoInssEmpresa = (CalculoInssEmpresa)this.serviceCalculoInssEmpresaImpl.getOrThrow(idCalculoInssEmpresa);
        if (this.isNotNull(this.getFechamentoByCalculoInss(calculoInssEmpresa)).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1098.006"));
        }
        return this.buildToDTOGeneric(calculoInssEmpresa, DTOCalculoInssEmpresa.class);
    }
}

