/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.feriado;

import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementor.model.vo.FeriadoAno;
import com.touchcomp.basementortools.tools.date.FeriadoInterface;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;

public class FeriadosNacionaisImpl
implements FeriadoInterface {
    private final List<Feriado> feriados;

    public FeriadosNacionaisImpl(List<Feriado> feriados) {
        this.feriados = feriados;
    }

    public boolean isFeriado(Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        int diaD = g.get(5);
        int mesD = g.get(2);
        int anoD = g.get(1);
        for (Feriado feriado : this.feriados) {
            int mes = feriado.getMes();
            int dia = feriado.getDia();
            if (!TMethods.isEquals((Object)1, (Object)feriado.getTipoFeriado()) || dia != diaD || mes != mesD) continue;
            if (TMethods.isAffirmative((Number)feriado.getTodoAno())) {
                return true;
            }
            Optional<FeriadoAno> found = feriado.getAnos().stream().filter(i -> TMethods.isEquals((Object)i.getAno(), (Object)anoD)).findFirst();
            if (!found.isPresent()) continue;
            return true;
        }
        return false;
    }
}

