/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.feriado;

import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementor.model.vo.FeriadoAno;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.FeriadoInterface;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SCompFeriadoCacheHelper
extends ServiceGenericImpl {
    private ServiceFeriadoImpl serviceFeriadoImpl;
    List<Feriado> feriados;

    public SCompFeriadoCacheHelper(ServiceFeriadoImpl serviceFeriadoImpl) {
        this.serviceFeriadoImpl = serviceFeriadoImpl;
    }

    public boolean isDiaUtil(Date data) {
        if (ToolDate.isSaturday((Date)data)) {
            return false;
        }
        if (ToolDate.isSunday((Date)data)) {
            return false;
        }
        return this.isFeriadoNacional(data);
    }

    public boolean isFeriadoNacional(Date data) {
        LocalDate localData = ToolDate.formatarLocalDate((Date)ToolDate.dataSemHora((Date)data));
        int ano = localData.getYear();
        int mes = localData.getMonthValue();
        int dia = localData.getDayOfMonth();
        if (this.feriados == null) {
            this.feriados = this.serviceFeriadoImpl.getFeriadosNacionais();
        }
        Optional<Feriado> found = this.feriados.stream().filter(i -> {
            if (!i.getMes().equals(mes)) {
                return false;
            }
            if (!i.getDia().equals(dia)) {
                return false;
            }
            for (FeriadoAno ferAno : i.getAnos()) {
                if (!ferAno.getAno().equals(ano)) continue;
                return true;
            }
            return false;
        }).findFirst();
        return found.isPresent();
    }

    public static class FeriadosDiasUteis
    implements FeriadoInterface {
        SCompFeriadoCacheHelper helper = (SCompFeriadoCacheHelper)Context.get(SCompFeriadoCacheHelper.class);

        public boolean isFeriado(Date data) {
            return this.helper.isDiaUtil(data);
        }
    }

    public static class FeriadosNacionais
    implements FeriadoInterface {
        SCompFeriadoCacheHelper helper = (SCompFeriadoCacheHelper)Context.get(SCompFeriadoCacheHelper.class);

        public boolean isFeriado(Date data) {
            return this.helper.isFeriadoNacional(data);
        }
    }
}

