/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.feriado;

import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementorservice.dao.impl.DaoFeriadoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceFeriado;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFeriadoImpl
extends ServiceGenericEntityImpl<Feriado, Long, DaoFeriadoImpl>
implements ServiceFeriado {
    @Autowired
    public ServiceFeriadoImpl(DaoFeriadoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public Feriado beforeSave(Feriado vo) {
        if (vo.getAnos() != null) {
            vo.getAnos().forEach(fa -> fa.setFeriado(vo));
        }
        if (vo.getCidades() != null) {
            vo.getCidades().forEach(fa -> fa.setFeriado(vo));
        }
        if (vo.getEmpresas() != null) {
            vo.getEmpresas().forEach(fa -> fa.setFeriado(vo));
        }
        return vo;
    }

    @Override
    public Boolean findFeriadoPorData(int dia, int mes, int ano, Empresa empresa) {
        return ((DaoFeriadoImpl)this.getGenericDao()).findFeriadoPorData(dia, mes, ano, empresa);
    }

    @Override
    public List<Feriado> findFeriadosNacionalPorPeriodo(Date periodoInicial, Date periodoFinal, Long idEmpresa) {
        return ((DaoFeriadoImpl)this.getGenericDao()).findFeriadosNacionalPorPeriodo(periodoInicial, periodoFinal, idEmpresa);
    }

    @Override
    public Boolean isFeriado(Date data, Empresa empresa) {
        return ((DaoFeriadoImpl)this.getGenericDao()).isFeriadoNacional(data, empresa);
    }

    @Override
    public Feriado findFeriadoPorDataAndCidade(Date data, Cidade cidade) {
        return ((DaoFeriadoImpl)this.getGenericDao()).findFeriadoPorDataAndCidade(data, cidade);
    }

    public boolean isFeriadoNacional(Date data) {
        return ((DaoFeriadoImpl)this.getGenericDao()).isFeriadoNacional(data);
    }

    public List<Feriado> getFeriadosNacionais() {
        return ((DaoFeriadoImpl)this.getDao()).getFeriadosNacionais();
    }

    public static class FeriadoHelperCache {
    }
}

