/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.feriascolaborador;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.SCompDadosPeriodoAquisitivo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompCalculoAvos2
extends ServiceGenericImpl {
    @Autowired
    SCompDadosPeriodoAquisitivo compDadosPeriodoAquisitivo;
    private static final int METADE_MES_15_DIAS = 15;
    private static final int UM_ANO_365_DIAS = 365;

    public ProvisaoFeriasAvos calcularAvosProvisao(Colaborador colaborador, Date dataLimite) {
        SCompDadosPeriodoAquisitivo.DadosPeriodoAquisitivo dados = this.compDadosPeriodoAquisitivo.getDadosPeriodoAquisitivoFerias(colaborador, dataLimite);
        int totalAvos = 0;
        Date dataUltimoPeriodoAquisitivoValido = null;
        LinkedList<ProvisaoFeriasAvosPeriodoAquisitivo> provisoes = new LinkedList<ProvisaoFeriasAvosPeriodoAquisitivo>();
        for (SCompDadosPeriodoAquisitivo.PeriodoAquisitivo periodoAquisitivo : dados.periodosAquisitivos()) {
            int avos = this.calcularAvos(colaborador, periodoAquisitivo, dataLimite);
            totalAvos += avos;
            provisoes.add(new ProvisaoFeriasAvosPeriodoAquisitivo(periodoAquisitivo, avos, dados.primeiroPeriodo().dataFimUltimaFerias()));
            if (!((double)avos > 0.0)) continue;
            dataUltimoPeriodoAquisitivoValido = periodoAquisitivo.dataFimPeriodo();
        }
        return new ProvisaoFeriasAvos(colaborador, dados, totalAvos, provisoes, dados.primeiroPeriodo().dataFimUltimaFerias(), dataUltimoPeriodoAquisitivoValido);
    }

    int calcularAvos(Colaborador colaborador, SCompDadosPeriodoAquisitivo.PeriodoAquisitivo periodoAquisitivo, Date dataLimite) {
        LocalDate effectiveEnd;
        LocalDate limite = ToolDate.formatarLocalDate((Date)dataLimite);
        LocalDate inicioPeriodo = ToolDate.formatarLocalDate((Date)periodoAquisitivo.dataInicioPeriodo());
        LocalDate fimPeriodo = ToolDate.formatarLocalDate((Date)periodoAquisitivo.dataFimPeriodo());
        LocalDate fim = ToolDate.formatarLocalDate((Date)periodoAquisitivo.dataFimPeriodo());
        if (fim.isAfter(limite)) {
            fim = limite;
        }
        if (periodoAquisitivo.perdaPeriodoAquisitivo()) {
            return 0;
        }
        long daysBetween = ChronoUnit.DAYS.between(inicioPeriodo, fim) + 1L;
        if (daysBetween >= 365L) {
            return 12;
        }
        LocalDate localDate = effectiveEnd = limite.isAfter(fimPeriodo) ? fimPeriodo : limite;
        if (effectiveEnd.isBefore(inicioPeriodo)) {
            return 0;
        }
        long fullMonths = ChronoUnit.MONTHS.between(inicioPeriodo, effectiveEnd);
        LocalDate afterFull = inicioPeriodo.plusMonths(fullMonths);
        long daysInFraction = ChronoUnit.DAYS.between(afterFull, effectiveEnd) + 1L;
        int avos = (int)fullMonths;
        if (daysInFraction >= 15L) {
            ++avos;
        }
        return avos;
    }

    public record ProvisaoFeriasAvosPeriodoAquisitivo(SCompDadosPeriodoAquisitivo.PeriodoAquisitivo periodoAquisitivo, Integer avos, Date ultimaDataFerias) {
    }

    public record ProvisaoFeriasAvos(Colaborador colaborador, SCompDadosPeriodoAquisitivo.DadosPeriodoAquisitivo dadosPeriodoAquisitivo, Integer totalAvos, List<ProvisaoFeriasAvosPeriodoAquisitivo> provisoes, Date ultimaDataFerias, Date ultimoPeriodoAquisitivoValido) {
    }
}

