/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.feriascolaborador;

import com.touchcomp.basementor.constants.enums.esocial.EnumConstEsocMotivoAfastamento;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDadosFerias;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.afastamentocolaborador.ServiceAfastamentoColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.colaboradordadosferias.ServiceColaboradorDadosFeriasImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.periodoaqferiascolab.ServicePeriodoAqFeriasColabImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.time.LocalDate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SCompDadosPeriodoAquisitivo
extends ServiceGenericImpl {
    static final int UM_ANO = 1;
    static final int DIAS_MES = 30;
    static final int DIAS_PAGAMENTO = 1;
    static final int SEIS_MESES_180_DIAS = 180;
    static final int DIAS_EM_UM_ANO = 365;
    final ServiceColaboradorDadosFeriasImpl serviceColaboradorDadosFerias;
    final ServiceFeriasColaboradorImpl serviceFeriasColaboradorImpl;
    final ServicePeriodoAqFeriasColabImpl servicePeriodoAqFeriasColabImpl;
    final ServiceAfastamentoColaboradorImpl serviceAfastamentoColaboradorImpl;
    final ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl;

    public SCompDadosPeriodoAquisitivo(ServiceColaboradorDadosFeriasImpl serviceColaboradorDadosFerias, ServiceFeriasColaboradorImpl serviceFeriasColaboradorImpl, ServicePeriodoAqFeriasColabImpl servicePeriodoAqFeriasColabImpl, ServiceAfastamentoColaboradorImpl serviceAfastamentoColaboradorImpl, ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl) {
        this.serviceColaboradorDadosFerias = serviceColaboradorDadosFerias;
        this.serviceFeriasColaboradorImpl = serviceFeriasColaboradorImpl;
        this.servicePeriodoAqFeriasColabImpl = servicePeriodoAqFeriasColabImpl;
        this.serviceAfastamentoColaboradorImpl = serviceAfastamentoColaboradorImpl;
        this.serviceMovimentoFolhaImpl = serviceMovimentoFolhaImpl;
    }

    public DadosPeriodoAquisitivo getDadosPeriodoAquisitivoFerias(Colaborador colaborador, Date dataLimite) {
        DadosPeriodoAquisitivo dadosPeriodoAquisitivo = this.getDadosPeriodoAtual(colaborador, dataLimite);
        if (dadosPeriodoAquisitivo != null) {
            return dadosPeriodoAquisitivo;
        }
        dadosPeriodoAquisitivo = this.getDadosFeriasAnterioresOutroSistema(colaborador, dataLimite);
        if (dadosPeriodoAquisitivo != null) {
            return dadosPeriodoAquisitivo;
        }
        return this.getDadosPeriodoNovoColaborador(colaborador, dataLimite);
    }

    private DadosPeriodoAquisitivo getDadosPeriodoAtual(Colaborador colaborador, Date dataLimite) {
        Date dataInicioPeriodo;
        PeriodoAqFeriasColab periodoAqFeriasColab = this.servicePeriodoAqFeriasColabImpl.pesquisarPeriodoAqFeriasColaboradorColaboradorDataProvisao(colaborador, dataLimite);
        if (periodoAqFeriasColab == null) {
            return null;
        }
        int diasGozados = 0;
        int diasAbono = 0;
        if (!this.isAffimative(periodoAqFeriasColab.getFechado())) {
            List<FeriasColaborador> ferias = this.serviceFeriasColaboradorImpl.getFeriasPorPeriodoAqFeriasColab(periodoAqFeriasColab);
            for (FeriasColaborador fer : ferias) {
                diasGozados = fer.getDiasGozoFerias().intValue();
            }
            diasAbono = periodoAqFeriasColab.getDiasAbonoPecuniario();
            diasGozados += diasAbono;
            dataInicioPeriodo = periodoAqFeriasColab.getDataInicial();
        } else {
            dataInicioPeriodo = ToolDate.nextDays((Date)periodoAqFeriasColab.getDataFinal(), (int)1);
        }
        FeriasColaborador ultimasFerias = this.serviceFeriasColaboradorImpl.getUltimaFerias(colaborador, dataLimite);
        Date dataInUltFerias = null;
        Date dataFimUltFerias = null;
        if (ultimasFerias != null) {
            dataInUltFerias = ultimasFerias.getDataGozoInicial();
            dataFimUltFerias = ultimasFerias.getDataGozoFinal();
        }
        return this.calculaPeriodos(colaborador, dataInicioPeriodo, dataLimite, diasGozados, diasAbono, dataInUltFerias, dataFimUltFerias);
    }

    private DadosPeriodoAquisitivo getDadosFeriasAnterioresOutroSistema(Colaborador colaborador, Date dataLimite) {
        Date dataInicioPeriodo = null;
        Date dataFimPeriodo = null;
        int diasGozados = 0;
        int diasAbono = 0;
        List<ColaboradorDadosFerias> feriasAnteriores = this.serviceColaboradorDadosFerias.pesquisarColaboradorDadosFeriasColaborador(colaborador);
        if (!ToolMethods.isWithData(feriasAnteriores)) {
            return null;
        }
        boolean periodoFechado = false;
        for (ColaboradorDadosFerias colabDadosFerias : feriasAnteriores) {
            diasGozados = ToolDate.diferenceDayBetweenDates((Date)colabDadosFerias.getInicioGozoFerias(), (Date)colabDadosFerias.getFimGozoFerias()) + 1;
            if (ToolMethods.isAffirmative((Number)colabDadosFerias.getFechado())) {
                periodoFechado = true;
            }
            if (dataFimPeriodo == null || dataFimPeriodo.before(colabDadosFerias.getDataFimPeriodo())) {
                dataFimPeriodo = colabDadosFerias.getDataFimPeriodo();
            }
            if (dataInicioPeriodo != null && !dataInicioPeriodo.after(colabDadosFerias.getDataInicioPeriodo())) continue;
            dataInicioPeriodo = colabDadosFerias.getDataFimPeriodo();
        }
        if (diasGozados >= 30) {
            periodoFechado = true;
        }
        ColaboradorDadosFerias colaboradorDadosFerias = feriasAnteriores.getFirst();
        if (periodoFechado) {
            dataInicioPeriodo = ToolDate.nextDays(dataFimPeriodo, (int)1);
        }
        return this.calculaPeriodos(colaborador, dataInicioPeriodo, dataLimite, diasGozados, diasAbono, colaboradorDadosFerias.getInicioGozoFerias(), colaboradorDadosFerias.getFimGozoFerias());
    }

    private DadosPeriodoAquisitivo getDadosPeriodoNovoColaborador(Colaborador colaborador, Date dataLimite) {
        int diasGozados = 0;
        int diasAbono = 0;
        Date dataInicioPeriodo = colaborador.getDataAdmissao();
        return this.calculaPeriodos(colaborador, dataInicioPeriodo, dataLimite, diasGozados, diasAbono, null, null);
    }

    Date getPeriodoFinal(Date dataFinal) {
        LocalDate aux = ToolDate.formatarLocalDate((Date)dataFinal);
        aux = aux.plusYears(1L);
        aux = aux.minusDays(1L);
        return ToolDate.asDate((LocalDate)aux);
    }

    Date getProximoPeriodoFinal(Date dataFinal) {
        LocalDate aux = ToolDate.formatarLocalDate((Date)dataFinal);
        aux = aux.plusYears(1L);
        return ToolDate.asDate((LocalDate)aux);
    }

    Date getPagamentoFerias(Date dataFinal) {
        return ToolDate.previousDays((Date)dataFinal, (int)31);
    }

    private Date getProximoPeriodo(Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.add(1, 1);
        return g.getTime();
    }

    private DadosPeriodoAquisitivo calculaPeriodos(Colaborador colaborador, Date dataInicioPeriodo, Date dataLimite, int diasGozados, int diasAbono, Date dataInicioUltimaFerias, Date dataFimUltimaFerias) {
        int diasAvencer = 0;
        PeriodoAquisitivo primeiro = null;
        PeriodoAquisitivo current = null;
        LinkedList<PeriodoAquisitivo> periodos = new LinkedList<PeriodoAquisitivo>();
        List<AfastamentoColaborador> afastamentos = this.serviceAfastamentoColaboradorImpl.getAfastamentoColaboradorDataProvisao(colaborador, dataInicioPeriodo);
        int countPeriodosAtivos = 0;
        do {
            boolean perdaPeriodo;
            Date novoPeriodoInicial;
            Date dataFimPeriodo = this.getPeriodoFinal(dataInicioPeriodo);
            int diasAfastados = this.getDiasAfastamentoGeral(afastamentos, dataInicioPeriodo, dataFimPeriodo);
            if (current != null && current.perdaPeriodoAquisitivo && (novoPeriodoInicial = this.getNovoPeriodoInicial(current.dataInicioPeriodo, dataFimPeriodo, afastamentos)) != null) {
                dataInicioPeriodo = novoPeriodoInicial;
                dataFimPeriodo = this.getPeriodoFinal(dataInicioPeriodo);
                diasAfastados = this.getDiasAfastamentoGeral(afastamentos, dataInicioPeriodo, dataFimPeriodo);
            }
            Date dataVencimentoFerias = this.getProximoPeriodoFinal(dataFimPeriodo);
            Date dataPagamentoFerias = this.getPagamentoFerias(dataVencimentoFerias);
            boolean feriasVencidas = dataVencimentoFerias.before(dataLimite);
            int diasFaltas = this.getDiasFaltas(colaborador, dataInicioPeriodo, dataFimPeriodo);
            int diasDireito = this.getDiasDireito(diasFaltas);
            diasAvencer = 0;
            if (diasDireito > 0) {
                diasAvencer = diasDireito - diasGozados;
            }
            boolean bl = perdaPeriodo = diasAfastados >= 180 || diasDireito == 0;
            if (perdaPeriodo) {
                diasDireito = 0;
                diasAvencer = 0;
            }
            current = new PeriodoAquisitivo(dataInicioPeriodo, dataFimPeriodo, dataVencimentoFerias, dataPagamentoFerias, dataInicioUltimaFerias, dataFimUltimaFerias, diasAvencer, diasGozados, diasAfastados, diasDireito, diasFaltas, diasAbono, perdaPeriodo, feriasVencidas, afastamentos);
            periodos.add(current);
            if (primeiro == null) {
                primeiro = current;
            }
            if (current.diasAvencer > 0) {
                ++countPeriodosAtivos;
            }
            diasGozados = 0;
            diasAbono = 0;
            dataInicioUltimaFerias = null;
            dataFimUltimaFerias = null;
        } while ((dataInicioPeriodo = this.getProximoPeriodo(dataInicioPeriodo)).before(dataLimite));
        return new DadosPeriodoAquisitivo(colaborador, primeiro, current, countPeriodosAtivos, periodos);
    }

    private int getDiasAfastamentoGeral(List<AfastamentoColaborador> afastamentos, Date dataInicioPeriodo, Date dataFimPeriodo) {
        int dias = 0;
        for (AfastamentoColaborador afastamento : afastamentos) {
            dias += this.getDiasAfastamentoGeral(afastamento, dataInicioPeriodo, dataFimPeriodo);
        }
        return dias;
    }

    private int getDiasAfastamentoGeral(AfastamentoColaborador afastamento, Date dataInicioPeriodo, Date dataFimPeriodo) {
        int dias = 0;
        EnumConstEsocMotivoAfastamento tipoAfast = EnumConstEsocMotivoAfastamento.get((Object)afastamento.getEsocMotivoAfastamento().getCodigo());
        if (tipoAfast.equals((Object)EnumConstEsocMotivoAfastamento.LICENCA_REMUNERADA) || tipoAfast.equals((Object)EnumConstEsocMotivoAfastamento.SERVICO_MILITAR)) {
            return dias;
        }
        Date dataAfastamento = afastamento.getDataAfastamento();
        Date dataRetorno = afastamento.getDataRetorno();
        if (dataAfastamento.after(dataFimPeriodo)) {
            return 0;
        }
        if (dataRetorno != null && dataRetorno.before(dataInicioPeriodo)) {
            return 0;
        }
        if (dataAfastamento.before(dataInicioPeriodo)) {
            dataAfastamento = dataInicioPeriodo;
        }
        if (dataRetorno == null || dataRetorno.after(dataFimPeriodo)) {
            dataRetorno = dataFimPeriodo;
        }
        dias = (int)((long)dias + (ToolDate.difBetweenDatesInDays((Date)dataAfastamento, (Date)dataRetorno) + 1L));
        return dias;
    }

    private int getDiasFaltas(Colaborador colaborador, Date dataInicioPeriodo, Date dataFimPeriodo) {
        return this.serviceMovimentoFolhaImpl.getDiasFaltasPeriodo(colaborador, dataInicioPeriodo, dataFimPeriodo, colaborador.getEmpresa());
    }

    private int getDiasDireito(int diasFaltas) {
        if (diasFaltas <= 5) {
            return 30;
        }
        if (diasFaltas <= 14) {
            return 24;
        }
        if (diasFaltas <= 23) {
            return 18;
        }
        if (diasFaltas <= 32) {
            return 12;
        }
        return 0;
    }

    private Date getNovoPeriodoInicial(Date dataInicioPeriodo, Date dataFimPeriodo, List<AfastamentoColaborador> afastamentos) {
        Date novaDataInicioPeriodo = null;
        for (AfastamentoColaborador afastamento : afastamentos) {
            if (afastamento.getDataRetorno() == null || !afastamento.getDataRetorno().after(dataInicioPeriodo) || !afastamento.getDataRetorno().before(dataFimPeriodo) || novaDataInicioPeriodo != null && !afastamento.getDataRetorno().after(novaDataInicioPeriodo)) continue;
            novaDataInicioPeriodo = afastamento.getDataRetorno();
        }
        return novaDataInicioPeriodo;
    }

    public record DadosPeriodoAquisitivo(Colaborador colaborador, PeriodoAquisitivo primeiroPeriodo, PeriodoAquisitivo ultimoPeriodo, Integer nrPeriodosAquisitivosAtivos, List<PeriodoAquisitivo> periodosAquisitivos) {
    }

    public record PeriodoAquisitivo(Date dataInicioPeriodo, Date dataFimPeriodo, Date dataVencimentoFerias, Date dataPagamentoFerias, Date dataInicioUltimaFerias, Date dataFimUltimaFerias, int diasAvencer, int diasGozados, int diasAfastados, int diasDireito, int diasFaltas, int diasAbonoPecuniario, boolean perdaPeriodoAquisitivo, boolean feriasVencidas, List<AfastamentoColaborador> afastamentos) {
    }
}

