/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.feriascolaborador;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.SCompCalculoAvos2;
import com.touchcomp.basementorservice.service.impl.opcoessistema.ServiceOpcoesSistemaImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.threadpool.TaskPoolExecutor;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SCompFeriasColaboradores
extends ServiceGenericImpl {
    ServiceColaboradorImpl serviceColaboradorImpl;
    ServiceOpcoesSistemaImpl servieOpcoesSistemaImpl;
    SCompCalculoAvos2 compCalculoAvos2;

    public SCompFeriasColaboradores(ServiceColaboradorImpl serviceColaboradorImpl, ServiceOpcoesSistemaImpl servieOpcoesSistemaImpl, SCompCalculoAvos2 compCalculoAvos2) {
        this.serviceColaboradorImpl = serviceColaboradorImpl;
        this.servieOpcoesSistemaImpl = servieOpcoesSistemaImpl;
        this.compCalculoAvos2 = compCalculoAvos2;
    }

    public List<ColaboradorFerias> analiseFeriasColaboradores(Date dataFinal, List<Long> centroCusto, List<Long> departamentos, List<String> nrRegColaboradores, Empresa empresa) throws ExceptionInvalidData {
        List<Colaborador> colaboradores = this.serviceColaboradorImpl.getColaboradoresAtivos(dataFinal, centroCusto, departamentos, nrRegColaboradores, empresa);
        List<ColaboradorFerias> resultado = Collections.synchronizedList(new LinkedList());
        int numThreads = this.servieOpcoesSistemaImpl.getNumeroProcessosSimultaneos();
        List[] data = ToolMethods.splitListNumberOfSubLists(colaboradores, (int)numThreads);
        LinkedList<TaskPoolExecutor.Task> runs = new LinkedList<TaskPoolExecutor.Task>();
        for (List list : data) {
            Runnable run = () -> {
                for (Colaborador colab : list) {
                    SCompCalculoAvos2.ProvisaoFeriasAvos provisao = this.compCalculoAvos2.calcularAvosProvisao(colab, dataFinal);
                    boolean afastado = false;
                    resultado.add(new ColaboradorFerias(colab, afastado, provisao));
                }
            };
            runs.add(new TaskPoolExecutor.Task(run));
        }
        TaskPoolExecutor pool = TaskPoolExecutor.getNew((int)numThreads).submitTasks(runs).waitForCompletion();
        pool.thowExceptionIfError();
        return resultado;
    }

    public record ColaboradorFerias(Colaborador colaborador, boolean estaAfastado, SCompCalculoAvos2.ProvisaoFeriasAvos provisao) {
    }
}

