/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.feriascolaborador;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import com.touchcomp.basementorclientwebservices.ponto.model.abono.DTOPontoFeriasColaborador;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.dao.impl.DaoFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceFeriasColaborador;
import com.touchcomp.touchvomodel.vo.feriascolaborador.web.DTOFeriasColaborador;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFeriasColaboradorImpl
extends ServiceGenericEntityImpl<FeriasColaborador, Long, DaoFeriasColaboradorImpl>
implements ServiceFeriasColaborador {
    @Autowired
    public ServiceFeriasColaboradorImpl(DaoFeriasColaboradorImpl genericDao) {
        super(genericDao);
    }

    @Override
    public List<FeriasColaborador> getFerias(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).getFerias(colaborador, inicioApuracao, finalApuracao);
    }

    public List<FeriasColaborador> getFeriasPorPeriodoAqFeriasColab(PeriodoAqFeriasColab periodoFerias) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).getFeriasPorPeriodoAqFeriasColab(periodoFerias);
    }

    public List<DTOFeriasColaborador> getFeriasColaboradorPorColaborador(Long idColaborador) {
        return this.buildToDTOGeneric(((DaoFeriasColaboradorImpl)this.getGenericDao()).getFeriasColaboradorPorColaborador(idColaborador), DTOFeriasColaborador.class);
    }

    public List<FeriasColaborador> getFerias(Long colaborador, Date dataParametro) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).getFerias(colaborador, dataParametro);
    }

    public List<FeriasColaborador> findFeriasNaoIntegradas(Date dataInicial, Date dataFinal, Long empresa) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).findFeriasNaoIntegradas(dataInicial, dataFinal, empresa);
    }

    public List<FeriasColaborador> findMovimentosS1200(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa);
    }

    public List<FeriasColaborador> findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa);
    }

    public List<DTOPontoFeriasColaborador> findFeriasColaboradorPonto(Date dataBaseSincDados, Date dataUltimaSincronizacao) throws ExceptionInvalidState {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).findFeriasColaboradorPonto(dataBaseSincDados, dataUltimaSincronizacao);
    }

    public List<FeriasColaborador> findFeriasColaboradorPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).findFeriasColaboradorPorDataPagamentoEmpresa(dataPagamento, empresa);
    }

    public FeriasColaborador getUltimaFerias(Colaborador colaborador, Date dataLimite) {
        return ((DaoFeriasColaboradorImpl)this.getGenericDao()).getUltimaFerias(colaborador, dataLimite);
    }
}

