/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fileuploaddownload;

import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorproperties.web.PropertiesWeb;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementortools.tools.aleatory.TAleatory;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ServiceFileDownloadImpl {
    final String DIR_WINDOWS = "c:\\touchcomp\\web\\file_download";
    final String DIR_LINUX = "/opt/touchcomp/web/file_download";
    final String DIR_MAC = "/Library/touchcomp/web/file_download";
    final String DIR_DATA = "data";
    final String FILE_CONFIG_MAP = "file_data_download_config.json";
    PropertiesWeb propertiesWeb = PropertiesWeb.get();

    public DTOUploadDownloadFileConfig.DTOItem registerCopyFile(File fileInput, boolean deleteSourceAfterCopy) throws ExceptionInvalidState {
        return this.registerCopyFile(fileInput, fileInput.getName(), deleteSourceAfterCopy);
    }

    public DTOUploadDownloadFileConfig.DTOItem registerCopyFile(File fileInput, String fileNameRegister, boolean deleteSourceAfterCopy) throws ExceptionInvalidState {
        try {
            DTOUploadDownloadFileConfig config = this.getConfig();
            if (!TMethods.isStrWithData((String)fileNameRegister)) {
                fileNameRegister = fileInput.getName();
            }
            String key = this.getKey(config, fileNameRegister);
            File fileData = this.getFilePathData(key);
            ToolFile.copyFile((File)fileInput, (File)fileData);
            DTOUploadDownloadFileConfig.DTOItem dTOItem = this.addItemConfig(fileNameRegister, fileData, config, key);
            return dTOItem;
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            throw new ExceptionInvalidState("E.GEN.000039", (Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (deleteSourceAfterCopy) {
                fileInput.delete();
            }
        }
    }

    protected File getFilePathConfig() {
        File dirTempWeb = this.getDirWeb();
        dirTempWeb = new File(String.valueOf(dirTempWeb) + File.separator + "file_data_download_config.json");
        return dirTempWeb;
    }

    protected File getFilePathData(String fileName) {
        fileName = ToolString.clearInvalidUTF8Char((String)fileName);
        fileName = ToolString.replaceAll((String)fileName, (String)" ", (String)"_");
        File filePath = this.getDirData();
        filePath = new File(String.valueOf(filePath) + File.separator + fileName);
        return filePath;
    }

    private File getDirData() {
        File dir = this.getDirWeb();
        dir = new File(dir.getAbsolutePath() + File.separator + "data");
        dir.mkdirs();
        return dir;
    }

    private File getDirWeb() {
        File dir = ToolSystem.isMac() ? new File("/Library/touchcomp/web/file_download") : (ToolSystem.isUnix() ? new File("/opt/touchcomp/web/file_download") : new File("c:\\touchcomp\\web\\file_download"));
        dir.mkdirs();
        return dir;
    }

    private DTOUploadDownloadFileConfig getConfig() throws ExceptionIO {
        File confFile = this.getFilePathConfig();
        if (!confFile.exists()) {
            return new DTOUploadDownloadFileConfig();
        }
        return (DTOUploadDownloadFileConfig)ToolJson.readJson((File)confFile, DTOUploadDownloadFileConfig.class, (Map.Entry[])new Map.Entry[]{ToolJson.propIgnoreUndefined()});
    }

    protected DTOUploadDownloadFileConfig.DTOItem addItemConfig(String fileName, File fileData, DTOUploadDownloadFileConfig config, String key) throws ExceptionIO {
        DTOUploadDownloadFileConfig.DTOItem item = new DTOUploadDownloadFileConfig.DTOItem();
        item.setChave(key);
        item.setFileName(fileName);
        item.setFilePath(fileData.getAbsolutePath());
        item.setFileExtension(ToolFile.getExtFileWithoutDot((String)fileName));
        item.setDataRegistro(TDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy hh:mm:ss"));
        config.getItens().add(item);
        this.writeConfig(config);
        return item;
    }

    public FileDetails getFile(String chaveArquivoDownload) throws ExceptionIO, ExceptionInvalidState {
        DTOUploadDownloadFileConfig conf = this.getConfig();
        Optional<DTOUploadDownloadFileConfig.DTOItem> found = conf.getItens().stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)chaveArquivoDownload)).findFirst();
        if (!found.isPresent()) {
            throw new ExceptionInvalidState("E.GEN.000037", new Object[]{chaveArquivoDownload});
        }
        File f = new File(found.get().getFilePath());
        if (!f.exists()) {
            throw new ExceptionInvalidState("E.GEN.000038", new Object[]{chaveArquivoDownload});
        }
        String url = this.getPathFile(chaveArquivoDownload);
        FileDetails ret = new FileDetails(chaveArquivoDownload, found.get().getFileName(), url, f);
        return ret;
    }

    public File removeFile(String chaveArquivoDownload) throws ExceptionIO, ExceptionInvalidState {
        DTOUploadDownloadFileConfig conf = this.getConfig();
        Optional<DTOUploadDownloadFileConfig.DTOItem> found = conf.getItens().stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)chaveArquivoDownload)).findFirst();
        if (!found.isPresent()) {
            throw new ExceptionInvalidState("E.GEN.000037", new Object[]{chaveArquivoDownload});
        }
        File f = new File(found.get().getFilePath());
        f.delete();
        f.deleteOnExit();
        conf.getItens().remove(found.get());
        this.writeConfig(conf);
        return f;
    }

    private void writeConfig(DTOUploadDownloadFileConfig config) throws ExceptionIO {
        this.cleanConfig(config);
        ToolJson.toJson((Object)config, (File)this.getFilePathConfig());
    }

    private void cleanConfig(DTOUploadDownloadFileConfig config) {
        config.getItens().removeIf(i -> !new File(i.getFilePath()).exists());
    }

    public List<FileDetails> getFiles(List<String> chavesArquivosAnexos) throws ExceptionIO, ExceptionInvalidState {
        LinkedList<FileDetails> files = new LinkedList<FileDetails>();
        if (chavesArquivosAnexos == null) {
            return files;
        }
        for (String arq : chavesArquivosAnexos) {
            FileDetails found = this.getFile(arq);
            files.add(found);
        }
        return files;
    }

    protected String getKey(DTOUploadDownloadFileConfig config, String file) {
        file = TString.trim((String)file);
        file = file.replaceAll("\\.", "_");
        String key = file + "_" + TDate.dateToStr((Date)new Date(), (String)"dd_MM_yy_HH_mm_ss");
        key = key + "_" + TAleatory.generateRandomString((int)5);
        boolean keyExists = true;
        while (keyExists) {
            String finalKey = key;
            Optional<DTOUploadDownloadFileConfig.DTOItem> found = config.getItens().stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)finalKey)).findFirst();
            keyExists = found.isPresent();
            if (!keyExists) continue;
            key = key + "_" + TAleatory.generateRandomString((int)5);
        }
        return key;
    }

    protected String getPathFile(String chaveArquivoDownload) throws ExceptionIO {
        Object enderecoApi = this.propertiesWeb.getIPApiExterno();
        String contexto = "touch-erp";
        Object ret = contexto + "//noauth/internal-services//file-download//download//" + chaveArquivoDownload;
        ret = ((String)ret).replaceAll("///", "/");
        ret = ((String)ret).replaceAll("//", "/");
        if (!((String)enderecoApi).endsWith("/")) {
            enderecoApi = (String)enderecoApi + "/";
        }
        ret = (String)enderecoApi + (String)ret;
        return ret;
    }

    public void clearOldFiles(int MAX_DAYS) throws ExceptionIO {
        DTOUploadDownloadFileConfig conf = this.getConfig();
        conf.getItens().removeIf(i -> {
            File f = new File(i.getFilePath());
            if (!f.exists()) {
                return true;
            }
            if (!TMethods.isStrWithData((String)i.getDataRegistro())) {
                return true;
            }
            Date data = TDate.strToDate((String)i.getDataRegistro(), (String)"dd/MM/yyyy hh:mm:ss");
            return TDate.daysBetweenInclusive((Date)data, (Date)new Date()) > MAX_DAYS;
        });
    }

    public static class FileDetails {
        private String fileName;
        private String chaveArquivo;
        private String urlArquivo;
        private File file;

        public FileDetails(String chaveArquivo, String fileName, String urlArquivo, File file) {
            this.fileName = fileName;
            this.file = file;
            this.urlArquivo = urlArquivo;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getChaveArquivo() {
            return this.chaveArquivo;
        }

        public void setChaveArquivo(String chaveArquivo) {
            this.chaveArquivo = chaveArquivo;
        }

        public String getUrlArquivo() {
            return this.urlArquivo;
        }

        public void setUrlArquivo(String urlArquivo) {
            this.urlArquivo = urlArquivo;
        }
    }
}

