/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fileuploaddownload;

import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementortools.tools.aleatory.TAleatory;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ServiceFileUploadImpl {
    final String DIR_WINDOWS = "c:\\touchcomp\\web\\file_upload";
    final String DIR_LINUX = "/opt/touchcomp/web/file_upload";
    final String DIR_MAC = "/Library/touchcomp/web/file_upload";
    final String DIR_DATA = "data";
    final String FILE_CONFIG_MAP = "file_data_upload_config.json";

    public DTOUploadDownloadFileConfig.DTOItem uploadFile(MultipartFile fileMultipart) throws ExceptionInvalidState {
        try {
            DTOUploadDownloadFileConfig config = this.getConfig();
            String fileName = fileMultipart.getOriginalFilename();
            String key = this.getKey(config, fileName);
            File fileData = this.getFilePathData(key);
            fileMultipart.transferTo(fileData);
            return this.addItemConfig(fileName, fileData, config, key);
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            throw new ExceptionInvalidState("E.GEN.000039", (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public DTOUploadDownloadFileConfig.DTOItem uploadFile(String fileName, byte[] fileContent) throws ExceptionInvalidState {
        try {
            DTOUploadDownloadFileConfig config = this.getConfig();
            String key = this.getKey(config, fileName);
            File fileData = this.getFilePathData(key);
            ToolFile.writeBytesOnFile((File)fileData, (byte[])fileContent);
            return this.addItemConfig(fileName, fileData, config, key);
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            throw new ExceptionInvalidState("E.GEN.000039", (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    protected File getFilePathConfig() {
        File dirTempWeb = this.getDirWeb();
        dirTempWeb = new File(String.valueOf(dirTempWeb) + File.separator + "file_data_upload_config.json");
        return dirTempWeb;
    }

    protected String getPath(String fileName) {
        int lastSeparatorUnix;
        fileName = ToolString.clearInvalidUTF8Char((String)fileName);
        fileName = ToolString.replaceAll((String)fileName, (String)" ", (String)"_");
        int lastSeparatorWindows = (fileName = ToolString.replaceAll((String)fileName, (String)":", (String)"_")).lastIndexOf(92);
        int lastSeparator = Math.max(lastSeparatorWindows, lastSeparatorUnix = fileName.lastIndexOf(47));
        if (lastSeparator != -1) {
            fileName = fileName.substring(lastSeparator + 1);
        }
        return fileName;
    }

    protected File getFilePathData(String fileName) {
        fileName = this.getPath(fileName);
        File filePath = this.getDirData();
        filePath = new File(String.valueOf(filePath) + File.separator + fileName);
        return filePath;
    }

    private File getDirData() {
        File dir = this.getDirWeb();
        dir = new File(dir.getAbsolutePath() + File.separator + "data");
        dir.mkdirs();
        return dir;
    }

    private File getDirWeb() {
        File dir = ToolSystem.isMac() ? new File("/Library/touchcomp/web/file_upload") : (ToolSystem.isUnix() ? new File("/opt/touchcomp/web/file_upload") : new File("c:\\touchcomp\\web\\file_upload"));
        dir.mkdirs();
        return dir;
    }

    private DTOUploadDownloadFileConfig getConfig() throws ExceptionIO {
        File confFile = this.getFilePathConfig();
        if (!confFile.exists()) {
            return new DTOUploadDownloadFileConfig();
        }
        return (DTOUploadDownloadFileConfig)ToolJson.readJson((File)confFile, DTOUploadDownloadFileConfig.class, (Map.Entry[])new Map.Entry[]{ToolJson.propIgnoreUndefined()});
    }

    protected DTOUploadDownloadFileConfig.DTOItem addItemConfig(String fileName, File fileData, DTOUploadDownloadFileConfig config, String key) throws ExceptionIO {
        DTOUploadDownloadFileConfig.DTOItem item = new DTOUploadDownloadFileConfig.DTOItem();
        item.setChave(key);
        item.setFileName(fileName);
        item.setFilePath(fileData.getAbsolutePath());
        item.setFileExtension(ToolFile.getExtFileWithoutDot((String)fileName));
        item.setDataRegistro(TDate.dateToStr((Date)new Date(), (String)"dd/MM/yyyy hh:mm:ss"));
        config.getItens().add(item);
        this.writeConfig(config);
        return item;
    }

    protected String getKey(DTOUploadDownloadFileConfig config, String file) {
        String key = file + "_" + TDate.dateToStr((Date)new Date(), (String)"dd_MM_yy_HH_mm_ss_SSS");
        boolean keyExists = true;
        while (keyExists) {
            String finalKey = key;
            Optional<DTOUploadDownloadFileConfig.DTOItem> found = config.getItens().stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)finalKey)).findFirst();
            keyExists = found.isPresent();
            if (!keyExists) continue;
            key = key + "_" + TAleatory.generateRandomString((int)5);
        }
        return key;
    }

    private void writeConfig(DTOUploadDownloadFileConfig config) throws ExceptionIO {
        this.cleanConfig(config);
        ToolJson.toJson((Object)config, (File)this.getFilePathConfig());
    }

    private void cleanConfig(DTOUploadDownloadFileConfig config) {
        config.getItens().removeIf(i -> !new File(i.getFilePath()).exists());
    }

    public List<File> getFiles(List<String> chavesArquivosAnexos) throws ExceptionIO, ExceptionInvalidState {
        LinkedList<File> files = new LinkedList<File>();
        if (chavesArquivosAnexos == null) {
            return files;
        }
        for (String chaveArquivo : chavesArquivosAnexos) {
            File found = this.getFile(chaveArquivo);
            files.add(found);
        }
        return files;
    }

    public void clearOldFiles(int MAX_DAYS) throws ExceptionIO {
        DTOUploadDownloadFileConfig conf = this.getConfig();
        conf.getItens().removeIf(i -> {
            File f = new File(i.getFilePath());
            if (!f.exists()) {
                return true;
            }
            if (!TMethods.isStrWithData((String)i.getDataRegistro())) {
                return true;
            }
            Date data = TDate.strToDate((String)i.getDataRegistro(), (String)"dd/MM/yyyy hh:mm:ss");
            return TDate.daysBetweenInclusive((Date)data, (Date)new Date()) > MAX_DAYS;
        });
    }

    public DTOUploadDownloadFileConfig.DTOItem getFileData(String chaveArquivoUpload) throws ExceptionInvalidState, ExceptionIO {
        DTOUploadDownloadFileConfig conf = this.getConfig();
        Optional<DTOUploadDownloadFileConfig.DTOItem> found = conf.getItens().stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)chaveArquivoUpload)).findFirst();
        if (!found.isPresent()) {
            throw new ExceptionInvalidState("E.GEN.000037", new Object[]{chaveArquivoUpload});
        }
        File f = new File(found.get().getFilePath());
        if (!f.exists()) {
            throw new ExceptionInvalidState("E.GEN.000038", new Object[]{chaveArquivoUpload});
        }
        return found.get();
    }

    public File getFile(String chaveArquivoUpload) throws ExceptionIO, ExceptionInvalidState {
        DTOUploadDownloadFileConfig.DTOItem item = this.getFileData(chaveArquivoUpload);
        File f = new File(item.getFilePath());
        return f;
    }

    public File removeFile(String chaveArquivoUpload) throws ExceptionIO, ExceptionInvalidState {
        DTOUploadDownloadFileConfig conf = this.getConfig();
        DTOUploadDownloadFileConfig.DTOItem item = this.getFileData(chaveArquivoUpload);
        File f = new File(item.getFilePath());
        f.delete();
        f.deleteOnExit();
        conf.getItens().remove(item);
        this.writeConfig(conf);
        return f;
    }
}

