/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.formulacaofases;

import com.touchcomp.basementor.model.vo.FormulacaoFases;
import com.touchcomp.basementor.model.vo.FormulacaoFasesTpProdSped;
import com.touchcomp.basementor.model.vo.ItemFormFasesProdutivas;
import com.touchcomp.basementor.model.vo.ItemFormulacaoFases;
import com.touchcomp.basementor.model.vo.ItemPerdaFormFasesProd;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoFormulacaoFasesImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceRoteiroProducaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFormulacaoFasesImpl
extends ServiceGenericEntityImpl<FormulacaoFases, Long, DaoFormulacaoFasesImpl> {
    @Autowired
    private ServiceRoteiroProducaoImpl serviceRoteiroProducao;

    @Autowired
    public ServiceFormulacaoFasesImpl(DaoFormulacaoFasesImpl dao) {
        super(dao);
    }

    public FormulacaoFases getByCodProdRevisao(String codigoAuxiliarProd, String revisao) {
        return ((DaoFormulacaoFasesImpl)this.getDao()).getByCodProdRevisao(codigoAuxiliarProd, revisao);
    }

    public FormulacaoFases getByCodProdRevisao(Long idProduto, String revisao) {
        return ((DaoFormulacaoFasesImpl)this.getDao()).getByCodProdRevisao(idProduto, revisao);
    }

    @Override
    public FormulacaoFases beforeSave(FormulacaoFases aux) {
        for (ItemFormulacaoFases item : aux.getItemFormulacaoFases()) {
            item.setFormulacaoFases(aux);
            for (ItemPerdaFormFasesProd itemp : item.getItemPerdaFormFaseProd()) {
                itemp.setItemFormulacaoFases(item);
            }
            for (ItemFormFasesProdutivas itemi : item.getItensFormFasesProdutivas()) {
                itemi.setItemFormulacaoFase(item);
                if (!TMethods.isWithData((Number)itemi.getAltura()) || !TMethods.isWithData((Number)itemi.getComprimento()) || !TMethods.isWithData((Number)itemi.getLargura())) continue;
                itemi.setVolume(Double.valueOf(itemi.getAltura() * itemi.getComprimento() * itemi.getLargura()));
            }
        }
        for (FormulacaoFasesTpProdSped t : aux.getTiposProducaoSped()) {
            t.setFormulacaoFases(aux);
        }
        return aux;
    }

    public List<FormulacaoFases> findFormulacoesByRoteiro(Long idRoteiro) throws ExceptionObjNotFound {
        RoteiroProducao roteiro = (RoteiroProducao)this.serviceRoteiroProducao.getOrThrow(idRoteiro);
        return ((DaoFormulacaoFasesImpl)this.getGenericDao()).findFormulacoesByRoteiro(roteiro);
    }

    public List<DTOEntidadeRes> findDTOFormulacoesByRoteiro(Long idRoteiro) throws ExceptionObjNotFound {
        RoteiroProducao roteiro = (RoteiroProducao)this.serviceRoteiroProducao.getOrThrow(idRoteiro);
        List<FormulacaoFases> formulacoes = ((DaoFormulacaoFasesImpl)this.getGenericDao()).findFormulacoesByRoteiro(roteiro);
        return this.buildToDTO(formulacoes, DTOEntidadeRes.class);
    }
}

