/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fornecedor;

import com.touchcomp.basementor.model.vo.FichaTecFornecedor;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.ValorFichaTecFornecedor;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.modelofichatecnica.ServiceModeloFichaTecnicaImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.fornecedor.web.DTOFornecedor;
import java.util.Collection;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompFornecedor
extends ServiceGenericImpl {
    private final ServiceFornecedorImpl serviceFornecedor;
    private final ServicePessoaImpl servicePessoa;
    private final ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnica;

    public UnidadeFatFornecedor criarUnidadeFatPadrao(Long idPessoa, Long idCategoriaPessoa) throws ExceptionObjNotFound, ExceptionInvalidData {
        Pessoa pessoa = (Pessoa)this.servicePessoa.getOrThrow(idPessoa);
        return this.serviceFornecedor.criarUnidadeFatPadrao(pessoa, idCategoriaPessoa);
    }

    public DTOFornecedor.DTOUnidadeFatFornecedor novaUnidadeFatFornecedor(Long idPessoa) throws ExceptionObjNotFound {
        Pessoa pessoa = (Pessoa)this.servicePessoa.getOrThrow(idPessoa);
        return this.buildToDTOGeneric(this.serviceFornecedor.novaUnidadeFatFornecedor(pessoa), DTOFornecedor.DTOUnidadeFatFornecedor.class);
    }

    public Boolean usarClassificacaoFornecedor(OpcoesCompraSuprimentos opcoes) {
        if (this.isNull(opcoes).booleanValue()) {
            return false;
        }
        return this.isNotNull(opcoes.getUsarClassificacaoFornecedor()) != false && this.isAffimative(opcoes.getUsarClassificacaoFornecedor());
    }

    public FichaTecFornecedor novaFichaTecFornecedor(Long idModeloFichaTec) throws ExceptionObjNotFound {
        ModeloFichaTecnica modelo = (ModeloFichaTecnica)this.serviceModeloFichaTecnica.getOrThrow(idModeloFichaTec);
        FichaTecFornecedor ficha = new FichaTecFornecedor();
        ficha.setModeloFichaTecnica(modelo);
        if (TMethods.isWithData((Collection)modelo.getItensModeloFichaTecnica())) {
            for (ItemModeloFichaTecnica item : modelo.getItensModeloFichaTecnica()) {
                ValorFichaTecFornecedor vo = new ValorFichaTecFornecedor();
                vo.setItemModeloFichaTecnica(item);
                ficha.getValoresFichasTecnicas().add(vo);
            }
        }
        return ficha;
    }

    @Generated
    public SCompFornecedor(ServiceFornecedorImpl serviceFornecedor, ServicePessoaImpl servicePessoa, ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnica) {
        this.serviceFornecedor = serviceFornecedor;
        this.servicePessoa = servicePessoa;
        this.serviceModeloFichaTecnica = serviceModeloFichaTecnica;
    }
}

