/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.fornecedor;

import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.FichaTecFornecedor;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoFornecedorImpl;
import com.touchcomp.basementorservice.helpers.impl.fornecedor.HelperFornecedor;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.categoriapessoa.ServiceCategoriaPessoaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFornecedorImpl
extends ServiceGenericEntityImpl<Fornecedor, Long, DaoFornecedorImpl> {
    @Autowired
    private HelperPessoa helperPessoa;
    @Autowired
    private HelperFornecedor compFornecedor;
    @Autowired
    private ServiceCategoriaPessoaImpl serviceCategoriaPessoa;

    @Autowired
    public ServiceFornecedorImpl(DaoFornecedorImpl genericDao) {
        super(genericDao);
    }

    @Override
    public Fornecedor beforeSave(Fornecedor fornecedor) {
        if (fornecedor.getDataCadastro() == null) {
            fornecedor.setDataCadastro(new Date());
        }
        if (TMethods.isStrWithData((String)fornecedor.getPessoa().getComplemento().getEmailPrincipal()) && !ToolMethods.isWithData((Collection)fornecedor.getPessoa().getComplemento().getEmails())) {
            this.helperPessoa.getNovo(fornecedor.getPessoa().getComplemento().getEmailPrincipal(), fornecedor.getPessoa());
        }
        if (!ToolMethods.isWithData((Collection)fornecedor.getUnidadesFatForn())) {
            UnidadeFatFornecedor unid = this.compFornecedor.criarUnidadeFatPadrao(fornecedor);
            unid.setFornecedor(fornecedor);
            fornecedor.getUnidadesFatForn().add(unid);
        }
        if (this.isNotNull(fornecedor.getUnidadesFatForn()).booleanValue()) {
            fornecedor.getUnidadesFatForn().forEach(i -> {
                i.setFornecedor(fornecedor);
                i.setCategoriaPessoa(fornecedor.getCategoriaPessoa());
            });
        }
        if (this.isNotNull(fornecedor.getFornecedores()).booleanValue()) {
            fornecedor.getFornecedores().forEach(i -> i.setFornecedor(fornecedor));
        }
        if (this.isNotNull(fornecedor.getFichasTecnicas()).booleanValue()) {
            for (FichaTecFornecedor ficha : fornecedor.getFichasTecnicas()) {
                ficha.setFornecedor(fornecedor);
                if (!this.isNotNull(ficha.getValoresFichasTecnicas()).booleanValue()) continue;
                ficha.getValoresFichasTecnicas().forEach(i -> i.setFichaTecFornecedor(ficha));
            }
        }
        return fornecedor;
    }

    public List<Fornecedor> getByCNPJCPF(String cnpjCpf) {
        return ((DaoFornecedorImpl)this.getGenericDao()).getByCNPJCPF(cnpjCpf);
    }

    public Fornecedor getFornecedorCpfCpnjAtivo(String cnpjCpf) {
        return ((DaoFornecedorImpl)this.getGenericDao()).getFornecedorCpfCpnjAtivo(cnpjCpf);
    }

    public Fornecedor getFornecedorCpfCpnjInscEstAtivo(String cnpjCpf, String inscEst) {
        return ((DaoFornecedorImpl)this.getGenericDao()).getFornecedorCpfCpnjInscEstAtivo(cnpjCpf, inscEst);
    }

    @Override
    public Fornecedor get(Pessoa pessoa) {
        return ((DaoFornecedorImpl)this.getGenericDao()).get(pessoa);
    }

    @Override
    public Fornecedor get(Usuario usuario) {
        this.reload(usuario);
        return ((DaoFornecedorImpl)this.getGenericDao()).get(usuario.getUsuarioBasico().getPessoa());
    }

    public List<Fornecedor> get(Pessoa pessoa, Short ativo) {
        return ((DaoFornecedorImpl)this.getGenericDao()).get(pessoa, ativo);
    }

    public PlanoConta getPCFornecedor(Pessoa pessoa) {
        return ((DaoFornecedorImpl)this.getDao()).getPCFornecedor(pessoa);
    }

    public UnidadeFatFornecedor criarUnidadeFatPadrao(Pessoa vo, Long idCategoriaPessoa) throws ExceptionObjNotFound, ExceptionInvalidData {
        Fornecedor fornecedor = this.get(vo);
        if (this.isNotNull(fornecedor).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0077.001", new Object[0]);
        }
        if (this.isNotNull(vo = this.helperPessoa.validarPessoa(vo)).booleanValue()) {
            UnidadeFatFornecedor unFat = this.compFornecedor.criarUnidadeFatPadrao(vo);
            if (this.isNotNull(idCategoriaPessoa).booleanValue()) {
                unFat.setCategoriaPessoa((CategoriaPessoa)this.serviceCategoriaPessoa.get(idCategoriaPessoa));
            }
            return unFat;
        }
        return null;
    }

    public UnidadeFatFornecedor novaUnidadeFatFornecedor(Pessoa vo) throws ExceptionObjNotFound {
        if (this.isNotNull(vo).booleanValue()) {
            return this.compFornecedor.criarUnidadeFat(vo);
        }
        return null;
    }

    public boolean exists(String cpfCnpj) {
        return ((DaoFornecedorImpl)this.getDao()).exists(cpfCnpj);
    }
}

