/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.funcao;

import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.DTOPontoCargo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoFuncaoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceFuncaoImpl
extends ServiceGenericEntityImpl<Funcao, Long, DaoFuncaoImpl> {
    @Autowired
    public ServiceFuncaoImpl(DaoFuncaoImpl genericDao) {
        super(genericDao);
    }

    public List<DTOPontoCargo> findFuncoesPonto(Date dataBaseSincDados, Date dataUltimaSincronizacao) {
        return ((DaoFuncaoImpl)this.getGenericDao()).findFuncoesPonto(dataBaseSincDados, dataUltimaSincronizacao);
    }

    public Funcao getFuncaoByCodigoCBO(String codigoCbo) throws ExceptionObjNotFound {
        if (!ToolMethods.isStrWithData((String)codigoCbo)) {
            return null;
        }
        return ((DaoFuncaoImpl)this.getDao()).getByCodigoCBO(codigoCbo);
    }

    public Funcao getFuncaoByCodigoCBOOrThrow(String codigoCbo) throws ExceptionObjNotFound {
        Funcao funcao = this.getFuncaoByCodigoCBO(codigoCbo);
        this.throwIfNull(funcao, (Serializable)((Object)codigoCbo));
        return funcao;
    }

    public Funcao getFuncaoByCodigo(String codCargo) throws ExceptionObjNotFound {
        if (!ToolMethods.isStrWithData((String)codCargo)) {
            return null;
        }
        Funcao funcao = ((DaoFuncaoImpl)this.getDao()).getByCodigo(codCargo);
        return funcao;
    }
}

