/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaoboletoenviomassa;

import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoBoletoEnvioMassa;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.borderocobranca.CompBorderoTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoGeracaoBoletoEnvioMassaImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.carteiracobranca.ServiceCarteiraCobrancaImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.meiopagamento.ServiceMeioPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.ramoatividade.ServiceRamoAtividadeImpl;
import com.touchcomp.basementorspringcontext.Context;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGeracaoBoletoEnvioMassaImpl
extends ServiceGenericEntityImpl<GeracaoBoletoEnvioMassa, Long, DaoGeracaoBoletoEnvioMassaImpl> {
    @Autowired
    private ServiceNotaFiscalPropriaImpl serviceNotaPropria;
    @Autowired
    private ServiceEmpresaImpl serviceEmpresa;
    @Autowired
    private ServiceRamoAtividadeImpl serviceRamoAtividade;
    @Autowired
    private ServiceMeioPagamentoImpl serviceMeioPagamento;
    @Autowired
    private ServiceCarteiraCobrancaImpl serviceCarteiraCobranca;
    @Autowired
    private CompBorderoTitulos compBorderoTitulos;

    @Autowired
    public ServiceGeracaoBoletoEnvioMassaImpl(DaoGeracaoBoletoEnvioMassaImpl genericDao) {
        super(genericDao);
    }

    public void gerarBoletosEmMassa(Long[] empresas, Date dataInicial, Date dataFinal, Long[] ramos, Long[] meiosPag, Long carteira, Long carteiraFinal, Integer intervaloDias) throws ExceptionObjNotFound {
        CarteiraCobranca carteiraCobTitulo = (CarteiraCobranca)this.serviceCarteiraCobranca.getOrThrow(carteira);
        CarteiraCobranca carteiraCobAtual = (CarteiraCobranca)this.serviceCarteiraCobranca.getOrThrow(carteiraFinal);
        if (this.isNull(dataInicial).booleanValue()) {
            dataInicial = new Date();
        }
        if (this.isNull(dataFinal).booleanValue()) {
            dataFinal = new Date();
        }
        this.gerarBoletosEmMassa(empresas, dataInicial, dataFinal, ramos, meiosPag, carteiraCobTitulo, carteiraCobAtual, intervaloDias);
    }

    public void gerarBoletosEmMassa(Long[] empresas, Date dataInicial, Date dataFinal, Long[] ramos, Long[] meiosPag, CarteiraCobranca carteira, CarteiraCobranca carteiraFinal, Integer intervaloDias) {
        LinkedList<GeracaoBoletoEnvioMassa> boletos = new LinkedList<GeracaoBoletoEnvioMassa>();
        List<NotaFiscalPropria> notas = this.serviceNotaPropria.findNotasEnvioBoletoEmMassa(empresas, dataInicial, dataFinal, ramos, meiosPag, carteira, intervaloDias);
        if (ServiceGeracaoBoletoEnvioMassaImpl.isWithData(notas)) {
            HashMap empresaVsTitulos = new HashMap();
            for (NotaFiscalPropria nota : notas) {
                for (InfPagamentoNfPropria infPag : nota.getInfPagamentoNfPropria()) {
                    for (Titulo titulo : infPag.getTitulos()) {
                        titulo.setCarteiraCobranca(carteiraFinal);
                        if (empresaVsTitulos.containsKey(titulo.getEmpresa())) {
                            if (((List)empresaVsTitulos.get(titulo.getEmpresa())).contains(titulo)) continue;
                            ((List)empresaVsTitulos.get(titulo.getEmpresa())).add(titulo);
                            continue;
                        }
                        LinkedList<Titulo> aux = new LinkedList<Titulo>();
                        aux.add(titulo);
                        empresaVsTitulos.put(titulo.getEmpresa(), aux);
                    }
                }
            }
            for (Empresa keyEmp : empresaVsTitulos.keySet()) {
                GeracaoBoletoEnvioMassa vo = new GeracaoBoletoEnvioMassa();
                vo.setCarteiraCobranca(carteira);
                vo.setDataCadastro(new Date());
                vo.setEmpresa(keyEmp);
                vo.setCarteiraCobranca(carteiraFinal);
                vo.setListTitulo((List)empresaVsTitulos.get(keyEmp));
                this.gerarBorderoTitulos(vo);
                boletos.add(vo);
            }
            if (ServiceGeracaoBoletoEnvioMassaImpl.isWithData(boletos)) {
                this.saveOrUpdate(boletos);
            }
        }
    }

    private void gerarBorderoTitulos(GeracaoBoletoEnvioMassa vo) {
        BorderoTitulos b = this.compBorderoTitulos.criarBordero(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(this.getSharedData().getOpcoesFinanceiras(vo.getEmpresa())).getCarteiraCobranca((short)1), vo.getCarteiraCobranca(), vo.getEmpresa(), vo.getListTitulo());
        vo.setBorderoTitulo(b);
    }
}

