/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoGeracaoNecCompra;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoNecCompra;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.ItemNecCompraDetalhes;
import com.touchcomp.basementor.model.vo.ItemPlanejProdSobEncPrevConsProd;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.PlanejProdSobEncPrevConsProd;
import com.touchcomp.basementor.model.vo.PlanejamentoProdSobEnc;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.gruponeccompra.ServiceGrupoNecCompraImpl;
import com.touchcomp.basementorservice.service.impl.necessidadecompra.ServiceNecessidadeCompraImpl;
import com.touchcomp.basementorservice.service.impl.planejamentoprodsobenc.ServicePlanejamentoProdSobEncImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.gruponecesssidadecompra.DTOGrupoNecessidadeCompra;
import com.touchcomp.touchvomodel.vo.planejamentoprodsobenc.DTOPlanejamentoProdSobEncRes;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompNecCompraPlanejamentoProdLinEnc
extends ServiceGenericImpl {
    @Autowired
    private ServicePlanejamentoProdSobEncImpl servicePlanejamentoProdSobEnc;
    @Autowired
    private ServiceGrupoNecCompraImpl serviceGrupoNecCompra;
    @Autowired
    private ServiceNecessidadeCompraImpl serviceNecessidadeCompra;

    public List<DTOPlanejamentoProdSobEncRes> gerarNecessidades(List<DTOPlanejamentoProdSobEncRes> planej, OpcoesCompraSuprimentos op) {
        if (SCompNecCompraPlanejamentoProdLinEnc.isWithData(planej)) {
            LinkedList<DTOPlanejamentoProdSobEncRes> result = new LinkedList<DTOPlanejamentoProdSobEncRes>();
            for (DTOPlanejamentoProdSobEncRes p : planej) {
                PlanejamentoProdSobEnc planejamentoProdLinhaProd = (PlanejamentoProdSobEnc)this.servicePlanejamentoProdSobEnc.get(p.getIdentificador());
                if (planejamentoProdLinhaProd == null) continue;
                GrupoNecCompra gr = this.gerarNecessidade(planejamentoProdLinhaProd, op);
                p.setGrupoNecCompra(this.serviceGrupoNecCompra.buildToDTO(gr, DTOGrupoNecessidadeCompra.class));
                result.add(p);
            }
            return result;
        }
        return new LinkedList<DTOPlanejamentoProdSobEncRes>();
    }

    public WebDTOResult salvarNecessidadePlanejProdLinhaEnc(List<DTOPlanejamentoProdSobEncRes> planejamento) throws ExceptionInvalidData {
        if (!TMethods.isWithData(planejamento)) {
            throw new ExceptionInvalidData("E.ERP.1998.003", new Object[0]);
        }
        WebDTOResult res = new WebDTOResult();
        for (DTOPlanejamentoProdSobEncRes dto : planejamento) {
            if (!this.isNotNull(dto.getGrupoNecCompra()).booleanValue()) continue;
            PlanejamentoProdSobEnc vo = (PlanejamentoProdSobEnc)this.servicePlanejamentoProdSobEnc.buildToEntity(dto);
            GrupoNecCompra grupoNecCompra = (GrupoNecCompra)this.serviceGrupoNecCompra.buildToEntity(dto.getGrupoNecCompra());
            vo.setGrupoNecCompra(grupoNecCompra);
            if (!this.isValidBeforeSave(vo, res)) continue;
            this.servicePlanejamentoProdSobEnc.saveOrUpdate(vo);
        }
        return res;
    }

    private boolean isValidBeforeSave(PlanejamentoProdSobEnc p, WebDTOResult res) {
        if (this.isNotNull(p.getGrupoNecCompra()).booleanValue()) {
            for (NecessidadeCompra nec : p.getGrupoNecCompra().getNecessidadesCompra()) {
                if (this.isAffimative(nec.getDesativarNecessidade()) && !this.isStrWithData(nec.getMotivoDesativacao())) {
                    res.addErroMessage("E.ERP.1998.009", p.getPeriodoProducao().getDescricao());
                    return false;
                }
                if (!(nec.getQuantidadeNecessidade() <= 0.0)) continue;
                res.addErroMessage("E.ERP.1998.008", nec.getGradeCor().toString(), p.getPeriodoProducao().getDescricao());
                return false;
            }
        }
        return true;
    }

    public GrupoNecCompra gerarNecessidade(PlanejamentoProdSobEnc planejamentoProdSobEnc, OpcoesCompraSuprimentos op) {
        GrupoNecCompra gr = planejamentoProdSobEnc.getGrupoNecCompra();
        if (this.isNull(gr).booleanValue()) {
            gr = new GrupoNecCompra();
            gr.setDataCadastro(new Date());
            gr.setEmpresa(planejamentoProdSobEnc.getEmpresa());
            gr.setObservacao(planejamentoProdSobEnc.getObservacao());
            gr.setUsuarioSolicitante(planejamentoProdSobEnc.getUsuarioLibCompras());
            gr.setCentroCusto(planejamentoProdSobEnc.getCentroCustoCompras());
            gr.setTipoNecessidade(Short.valueOf(EnumConstTipoNecCompra.TIPO_NECESSIDADE_NORMAL.getValue()));
        } else {
            gr.getNecessidadesCompra().clear();
        }
        for (PlanejProdSobEncPrevConsProd pp : planejamentoProdSobEnc.getPrevisaoConsProdutos()) {
            if (!(pp.getQtdCompra() > 0.0) || !this.isAffimative(pp.getEnviarParaCompras())) continue;
            NecessidadeCompra n = new NecessidadeCompra();
            if (this.isNotNull(op).booleanValue()) {
                n.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            if (this.isNotNull(pp.getGradeCor().getProdutoGrade().getProduto().getTipoIemSped()).booleanValue()) {
                n.setNaturezaOperacao(pp.getGradeCor().getProdutoGrade().getProduto().getTipoIemSped().getNaturezaOperacaoNecCompra());
            }
            n.setCentroCusto(gr.getCentroCusto());
            n.setDataCadastro(gr.getDataCadastro());
            n.setDataNecessidade(planejamentoProdSobEnc.getDataLiberacaoCompras());
            n.setDesativarNecessidade(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            n.setEmpresa(gr.getEmpresa());
            n.setEstoque(pp.getQtdeSaldo());
            n.setEstoqueMaximo(pp.getQtdeMax());
            n.setEstoqueMinimo(pp.getQtdeMin());
            n.setEstoqueRessuprimento(pp.getQtdeRessuprimento());
            n.setGradeCor(pp.getGradeCor());
            n.setGrupoNecCompra(gr);
            n.setObservacao(planejamentoProdSobEnc.getObservacao());
            n.setQuantidadeAdicional(Double.valueOf(0.0));
            n.setQuantidadeComprada(this.serviceNecessidadeCompra.findSaldoCompraAbertoGradeCor(n.getGradeCor()));
            n.setQuantidadeNecessidade(pp.getQtdCompra());
            n.setQuantidadeNecessidadeGerada(pp.getQtdCompra());
            n.setTipoGeracao(Short.valueOf(EnumConstTipoGeracaoNecCompra.TIPO_GERACAO_AUTOMATICA.getValue()));
            n.setTipoNecessidade(gr.getTipoNecessidade());
            n.setUsuarioSolicitante(gr.getUsuarioSolicitante());
            this.criarItemNecessidadeCompraPlanej(n, pp);
            gr.getNecessidadesCompra().add(n);
        }
        return gr;
    }

    private void criarItemNecessidadeCompraPlanej(NecessidadeCompra n, PlanejProdSobEncPrevConsProd pp) {
        for (ItemPlanejProdSobEncPrevConsProd i : pp.getItemPlanejProdSobEncPrevConsProd()) {
            ItemNecCompraDetalhes item = new ItemNecCompraDetalhes();
            item.setQuantidade(i.getQuantidade());
            item.setQtdReferencia(i.getQtdReferencia());
            item.setComprimento(i.getComprimento());
            item.setAltura(i.getAltura());
            item.setLargura(i.getLargura());
            item.setVolume(i.getVolume());
            item.setNecessidadeCompra(n);
            n.getItemNecCompraDetalhes().add(item);
        }
    }
}

