/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra;

import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoGeracaoNecCompra;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoNecCompra;
import com.touchcomp.basementor.model.vo.AtendPedAlmoxItemGradeNecComp;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmoxItemGrade;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SCompNecessidadeCompraPedAlmox
extends ServiceGenericImpl {
    private final String KEY_OBSERVACAO = "OBSERVACAO";
    private final String KEY_OBSERVACAO_NEC_COMPRA = "OBSERVACAO_NECESSIDADE_COMPRA";
    private final String KEY_TIPO_NECESSIDADE = "TIPO_NECESSIDADE";
    private final String KEY_LISTA = "LISTA";
    private final String KEY_NATUREZA_OPERACAO = "NATUREZA_OPERACAO";
    private final String KEY_GRADE_COR = "GRADE_COR";

    public List<NecessidadeCompra> generateNecessidadeRessuprimento(List<AtendPedidoAlmoxItemGrade> atendimentos, Usuario usuarioSolicitante, Empresa empresa, OpcoesCompraSuprimentos op, Short gerarNecCompraSepPedAlmox) {
        if (!SCompNecessidadeCompraPedAlmox.isWithData(atendimentos)) {
            return new LinkedList<NecessidadeCompra>();
        }
        List hashGradesProdutos = this.calcularHash(atendimentos, gerarNecCompraSepPedAlmox);
        return this.buildNecessidadesCompra(hashGradesProdutos, usuarioSolicitante, empresa, op);
    }

    private List<NecessidadeCompra> buildNecessidadesCompra(List<HashMap> produtosNecessidades, Usuario usuarioSolicitante, Empresa emp, OpcoesCompraSuprimentos op) {
        ArrayList<NecessidadeCompra> necessidades = new ArrayList<NecessidadeCompra>();
        CentroCusto centroCustoCompra = op.getCentroCustoNecessidadeCompra();
        for (HashMap h : produtosNecessidades) {
            GradeCor gc = (GradeCor)h.get("GRADE_COR");
            NaturezaOperacao naturezaOperacao = (NaturezaOperacao)h.get("NATUREZA_OPERACAO");
            String observacao = (String)h.get("OBSERVACAO");
            String observacaoNecessidadeCompra = (String)h.get("OBSERVACAO_NECESSIDADE_COMPRA");
            Short tipoNecessidade = (Short)h.get("TIPO_NECESSIDADE");
            List grades = (List)h.get("LISTA");
            Double qtdTotal = 0.0;
            NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
            ArrayList<AtendPedAlmoxItemGradeNecComp> gr = new ArrayList<AtendPedAlmoxItemGradeNecComp>();
            Date dataMin = null;
            for (AtendPedidoAlmoxItemGrade g : grades) {
                qtdTotal = qtdTotal + g.getQuantidadeCotar();
                AtendPedAlmoxItemGradeNecComp aux = new AtendPedAlmoxItemGradeNecComp();
                aux.setNecessidadeCompra(necessidadeCompra);
                aux.setAtendPedidoAlmoxItemGrade(g);
                gr.add(aux);
                if (this.isNull(dataMin).booleanValue() || this.isNotNull(g.getDataNecessidade()).booleanValue() && this.isNotNull(dataMin).booleanValue() && dataMin.after(g.getDataNecessidade())) {
                    dataMin = g.getDataNecessidade();
                }
                if (!this.isNotNull(g.getCentroCusto()).booleanValue()) continue;
                centroCustoCompra = g.getCentroCusto();
            }
            if (this.isNotNull(op).booleanValue()) {
                necessidadeCompra.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            necessidadeCompra.setNaturezaOperacao(naturezaOperacao);
            necessidadeCompra.setCentroCusto(centroCustoCompra);
            necessidadeCompra.setDataCadastro(new Date());
            necessidadeCompra.setEmpresa(emp);
            necessidadeCompra.setGradeCor(gc);
            necessidadeCompra.setDataNecessidade(dataMin);
            necessidadeCompra.setQuantidadeNecessidadeGerada(qtdTotal);
            necessidadeCompra.setQuantidadeNecessidade(qtdTotal);
            necessidadeCompra.setObservacao(observacao);
            if (this.isStrWithData(observacaoNecessidadeCompra)) {
                if (this.isStrWithData(necessidadeCompra.getObservacao())) {
                    necessidadeCompra.setObservacao(necessidadeCompra.getObservacao() + " " + observacaoNecessidadeCompra);
                } else {
                    necessidadeCompra.setObservacao(observacaoNecessidadeCompra);
                }
            }
            necessidadeCompra.setTipoGeracao(Short.valueOf(EnumConstTipoGeracaoNecCompra.TIPO_GERACAO_AUTOMATICA.getValue()));
            if (this.isNotNull(tipoNecessidade).booleanValue()) {
                necessidadeCompra.setTipoNecessidade(tipoNecessidade);
            } else {
                necessidadeCompra.setTipoNecessidade(Short.valueOf(EnumConstTipoNecCompra.TIPO_NECESSIDADE_NORMAL.getValue()));
            }
            necessidadeCompra.setUsuarioSolicitante(usuarioSolicitante);
            necessidadeCompra.setAtendPedAlmoxNecCompra(gr);
            necessidades.add(necessidadeCompra);
        }
        return necessidades;
    }

    private List calcularHash(List<AtendPedidoAlmoxItemGrade> produtosNecessidades, Short gerarNecCompraSepPedAlmox) {
        ArrayList<HashMap> hash = new ArrayList<HashMap>();
        for (AtendPedidoAlmoxItemGrade a : produtosNecessidades) {
            ArrayList<AtendPedidoAlmoxItemGrade> aux;
            HashMap h = null;
            if (!this.isAffimative(gerarNecCompraSepPedAlmox)) {
                for (HashMap m : hash) {
                    GradeCor gr = (GradeCor)m.get("GRADE_COR");
                    NaturezaOperacao naturezaOperacao = (NaturezaOperacao)m.get("NATUREZA_OPERACAO");
                    if (!this.isEquals(gr, a.getGradeItemPedAlmox().getGradeCor()) || !this.isEquals(naturezaOperacao, a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getPedidoAlmoxarifado().getNaturezaOperacao())) continue;
                    String observacao = String.valueOf(m.get("OBSERVACAO")) + " - " + a.getGradeItemPedAlmox().getItemPedidoAlmoxarifado().getObservacao();
                    m.put("OBSERVACAO", observacao.trim());
                    h = m;
                    break;
                }
            }
            if (this.isNull(h).booleanValue()) {
                h = new HashMap();
                aux = new ArrayList<AtendPedidoAlmoxItemGrade>();
                h.put("GRADE_COR", a.getGradeItemPedAlmox().getGradeCor());
                if (this.isNotNull(a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getPedidoAlmoxarifado().getNaturezaOperacao()).booleanValue()) {
                    h.put("NATUREZA_OPERACAO", a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getPedidoAlmoxarifado().getNaturezaOperacao());
                } else {
                    h.put("NATUREZA_OPERACAO", a.getAtendPedidoAlmoxItem().getItemPedidoAlmoxarifado().getProduto().getTipoIemSped().getNaturezaOperacaoNecCompra());
                }
                h.put("LISTA", aux);
                h.put("OBSERVACAO", a.getGradeItemPedAlmox().getItemPedidoAlmoxarifado().getObservacao());
                h.put("OBSERVACAO_NECESSIDADE_COMPRA", a.getObservacao());
                h.put("TIPO_NECESSIDADE", a.getTipoNecessidade());
                hash.add(h);
            }
            if (h == null || (aux = (ArrayList<AtendPedidoAlmoxItemGrade>)h.get("LISTA")).isEmpty()) continue;
            aux.add(a);
        }
        return hash;
    }
}

