/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoGeracaoNecCompra;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoNecCompra;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.TipoItemSped;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.necessidadecompra.ServiceNecessidadeCompraImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.tipoitemsped.ServiceTipoItemSpedImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompNecessidadeCompraRessuprimento
extends ServiceGenericImpl {
    @Autowired
    private ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    private ServiceTipoItemSpedImpl serviceTipoItemSped;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    private ServiceNecessidadeCompraImpl serviceNecessidadeCompra;

    public List<NecessidadeCompra> generateNecessidadeRessuprimento(Date dataRessuprimento, Usuario usuarioSolicitante, Fabricante fabricante, Especie especie, SubEspecie subEspecie, GrupoProdutos grupoProdutos, ClassificacaoAnaliseEstoque classificacao, Empresa empresa, Short tipoProduto, OpcoesCompraSuprimentos op) {
        List<HashMap> produtosNecessidades = this.serviceSaldoEstoque.findProdutosRessuprimentoEstoque(dataRessuprimento, fabricante, especie, subEspecie, grupoProdutos, classificacao, empresa, tipoProduto, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue());
        return this.buildNecessidadesCompra(produtosNecessidades, usuarioSolicitante, empresa, op);
    }

    private List<NecessidadeCompra> buildNecessidadesCompra(List<HashMap> produtosNecessidades, Usuario usuarioSolicitante, Empresa empresa, OpcoesCompraSuprimentos op) {
        CentroCusto centroCustoCompra = op.getCentroCustoNecessidadeCompra();
        HashMap<Long, TipoItemSped> map = new HashMap<Long, TipoItemSped>();
        ArrayList<NecessidadeCompra> necessidades = new ArrayList<NecessidadeCompra>();
        for (HashMap saldoEstProprio : produtosNecessidades) {
            TipoItemSped tipoItemSped;
            NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
            Integer idGradeCor = (Integer)saldoEstProprio.get("ID_GRADE_COR");
            Number qtd = (Number)saldoEstProprio.get("SALDO_QTD");
            Number qtdMax = (Number)saldoEstProprio.get("ESTOQUE_MAXIMO");
            Number qtdRes = (Number)saldoEstProprio.get("ESTOQUE_RESSUPRIMENTO");
            Number qtdMin = (Number)saldoEstProprio.get("ESTOQUE_MINIMO");
            Number idItemSped = (Number)saldoEstProprio.get("ID_ITEM_SPED");
            GradeCor gradeCor = (GradeCor)this.serviceGradeCor.get(idGradeCor.longValue());
            if (this.isNotNull(op).booleanValue()) {
                necessidadeCompra.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            if (this.isNull(tipoItemSped = (TipoItemSped)map.get(idItemSped)).booleanValue() && this.isNotNull(idItemSped).booleanValue()) {
                map.put(idItemSped.longValue(), (TipoItemSped)this.serviceTipoItemSped.get(idItemSped.longValue()));
            }
            if (this.isNotNull(idItemSped).booleanValue() && this.isNotNull(map.get(idItemSped.longValue())).booleanValue()) {
                necessidadeCompra.setNaturezaOperacao(((TipoItemSped)map.get(idItemSped.longValue())).getNaturezaOperacaoNecCompra());
            }
            necessidadeCompra.setCentroCusto(centroCustoCompra);
            necessidadeCompra.setQuantidadeComprada(this.serviceNecessidadeCompra.findSaldoCompraAbertoGradeCor(gradeCor));
            necessidadeCompra.setDataCadastro(new Date());
            necessidadeCompra.setDataNecessidade(necessidadeCompra.getDataCadastro());
            necessidadeCompra.setEmpresa(empresa);
            necessidadeCompra.setGradeCor(gradeCor);
            necessidadeCompra.setQuantidadeNecessidadeGerada(ToolFormatter.arrredondarNumero((Double)(qtdMax.doubleValue() - (this.isNull(qtd) != false ? 0.0 : qtd.doubleValue()) - necessidadeCompra.getQuantidadeComprada()), (int)4));
            necessidadeCompra.setTipoGeracao(Short.valueOf(EnumConstTipoGeracaoNecCompra.TIPO_GERACAO_AUTOMATICA.getValue()));
            necessidadeCompra.setTipoNecessidade(Short.valueOf(EnumConstTipoNecCompra.TIPO_NECESSIDADE_NORMAL.getValue()));
            necessidadeCompra.setUsuarioSolicitante(usuarioSolicitante);
            necessidadeCompra.setEstoqueMaximo(Double.valueOf(qtdMax.doubleValue()));
            necessidadeCompra.setQuantidadeComprada(necessidadeCompra.getQuantidadeComprada());
            necessidadeCompra.setEstoqueMinimo(Double.valueOf(qtdMin.doubleValue()));
            necessidadeCompra.setEstoqueRessuprimento(Double.valueOf(qtdRes.doubleValue()));
            necessidadeCompra.setEstoque(Double.valueOf(qtd.doubleValue()));
            necessidadeCompra.setQuantidadeNecessidade(necessidadeCompra.getQuantidadeNecessidadeGerada());
            necessidades.add(necessidadeCompra);
        }
        return necessidades;
    }
}

