/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoGeracaoNecCompra;
import com.touchcomp.basementor.constants.enums.necessidadecompra.EnumConstTipoNecCompra;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.TipoItemSped;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.necessidadecompra.ServiceNecessidadeCompraImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.tipoitemsped.ServiceTipoItemSpedImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompNecessidadeCompraRessuprimentoProduto
extends ServiceGenericImpl {
    @Autowired
    private ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    private ServiceTipoItemSpedImpl serviceTipoItemSped;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    private ServiceNecessidadeCompraImpl serviceNecessidadeCompra;

    public List<NecessidadeCompra> generateNecessidadeRessuprimento(Date dataRessuprimento, Usuario usuarioSolicitante, Fabricante fabricante, Especie especie, SubEspecie subEspecie, GrupoProdutos grupoProdutos, Empresa empresa, Integer tipoProduto, Short produtosSemMovimentacao, OpcoesCompraSuprimentos op) {
        ArrayList<HashMap> produtosNecessidades = new ArrayList<HashMap>();
        produtosNecessidades.addAll(this.serviceSaldoEstoque.getSaldoProdutoNecessidadeCompraProduto(dataRessuprimento, null, null, especie != null ? especie.getIdentificador() : null, especie != null ? especie.getIdentificador() : null, subEspecie != null ? subEspecie.getIdentificador() : null, subEspecie != null ? subEspecie.getIdentificador() : null, null, null, fabricante != null ? fabricante.getIdentificador() : null, fabricante != null ? fabricante.getIdentificador() : null, 0L, 999999999L, grupoProdutos != null ? grupoProdutos.getIdentificador() : null, tipoProduto, tipoProduto, (short)3, empresa.getIdentificador(), produtosSemMovimentacao, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_GRADE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO));
        return this.buildNecessidadesCompra(produtosNecessidades, usuarioSolicitante, empresa, op);
    }

    private List<NecessidadeCompra> buildNecessidadesCompra(List<HashMap> produtosNecessidades, Usuario usuarioSolicitante, Empresa emp, OpcoesCompraSuprimentos op) {
        CentroCusto centroCustoCompra = op.getCentroCustoNecessidadeCompra();
        HashMap<Long, TipoItemSped> map = new HashMap<Long, TipoItemSped>();
        ArrayList<NecessidadeCompra> necessidades = new ArrayList<NecessidadeCompra>();
        for (HashMap saldoEstProprio : produtosNecessidades) {
            TipoItemSped tipoItemSped;
            NecessidadeCompra necessidadeCompra = new NecessidadeCompra();
            Integer idGradeCor = (Integer)saldoEstProprio.get("ID_GRADE_COR");
            Number qtd = (Number)saldoEstProprio.get("SALDO_QTD");
            Number qtdMax = (Number)saldoEstProprio.get("QTD_MAX");
            Number qtdRes = (Number)saldoEstProprio.get("PONTO_RESSUPRIMENTO");
            Number idItemSped = (Number)saldoEstProprio.get("ID_ITEM_SPED");
            Number qtdMin = (Number)saldoEstProprio.get("QTD_MIN");
            GradeCor gradeCor = (GradeCor)this.serviceGradeCor.get(idGradeCor.longValue());
            if (this.isNotNull(op).booleanValue()) {
                necessidadeCompra.setSituacaoNecessidadeCompra(op.getSituacaoNecessidadeCadastro());
            }
            if (this.isNull(tipoItemSped = (TipoItemSped)map.get(idItemSped)).booleanValue() && this.isNotNull(idItemSped).booleanValue()) {
                map.put(idItemSped.longValue(), (TipoItemSped)this.serviceTipoItemSped.get(idItemSped.longValue()));
            }
            if (this.isNotNull(idItemSped).booleanValue() && this.isNotNull(map.get(idItemSped.longValue())).booleanValue()) {
                necessidadeCompra.setNaturezaOperacao(((TipoItemSped)map.get(idItemSped.longValue())).getNaturezaOperacaoNecCompra());
            }
            necessidadeCompra.setCentroCusto(centroCustoCompra);
            necessidadeCompra.setQuantidadeComprada(this.serviceNecessidadeCompra.findSaldoCompraAbertoGradeCor(gradeCor));
            necessidadeCompra.setDataCadastro(new Date());
            necessidadeCompra.setDataNecessidade(necessidadeCompra.getDataCadastro());
            necessidadeCompra.setEmpresa(emp);
            necessidadeCompra.setGradeCor(gradeCor);
            necessidadeCompra.setQuantidadeNecessidadeGerada(ToolFormatter.arrredondarNumero((Double)(qtdRes.doubleValue() - qtd.doubleValue() - necessidadeCompra.getQuantidadeComprada()), (int)4));
            necessidadeCompra.setTipoGeracao(Short.valueOf(EnumConstTipoGeracaoNecCompra.TIPO_GERACAO_AUTOMATICA.getValue()));
            necessidadeCompra.setTipoNecessidade(Short.valueOf(EnumConstTipoNecCompra.TIPO_NECESSIDADE_NORMAL.getValue()));
            necessidadeCompra.setUsuarioSolicitante(usuarioSolicitante);
            necessidadeCompra.setEstoqueMaximo(Double.valueOf(qtdMax.doubleValue()));
            necessidadeCompra.setEstoqueMinimo(Double.valueOf(qtdMin.doubleValue()));
            necessidadeCompra.setEstoqueRessuprimento(Double.valueOf(qtdRes.doubleValue()));
            necessidadeCompra.setEstoque(Double.valueOf(qtd.doubleValue()));
            necessidadeCompra.setQuantidadeNecessidade(necessidadeCompra.getQuantidadeNecessidadeGerada());
            if (!(necessidadeCompra.getQuantidadeNecessidadeGerada() > 0.0)) continue;
            necessidades.add(necessidadeCompra);
        }
        return necessidades;
    }
}

