/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra;

import com.touchcomp.basementor.model.vo.AtendPedidoAlmoxItemGrade;
import com.touchcomp.basementor.model.vo.ClassificacaoAnaliseEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.atendpedidoalmoxitemgrade.ServiceAtendPedidoAlmoxItemGradeImpl;
import com.touchcomp.basementorservice.service.impl.classificacaoanaliseestoque.ServiceClassificacaoAnaliseEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.especie.ServiceEspecieImpl;
import com.touchcomp.basementorservice.service.impl.fabricante.ServiceFabricanteImpl;
import com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra.SCompNecCompraPlanejamentoProdLinEnc;
import com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra.SCompNecCompraPlanejamentoProdLinProd;
import com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra.SCompNecessidadeCompraPedAlmox;
import com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra.SCompNecessidadeCompraRessuprimento;
import com.touchcomp.basementorservice.service.impl.geracaonecessidadecompra.SCompNecessidadeCompraRessuprimentoProduto;
import com.touchcomp.basementorservice.service.impl.grupoprodutos.ServiceGrupoProdutosImpl;
import com.touchcomp.basementorservice.service.impl.necessidadecompra.ServiceNecessidadeCompraImpl;
import com.touchcomp.basementorservice.service.impl.subespecie.ServiceSubEspecieImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.necessidadecompra.web.DTONecessidadeCompra;
import com.touchcomp.touchvomodel.vo.planejamentoprodlinhaprod.web.DTOPlanejamentoProdLinhaProdRes;
import com.touchcomp.touchvomodel.vo.planejamentoprodsobenc.DTOPlanejamentoProdSobEncRes;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGeracaoNecessidadeCompraImpl
extends ServiceGenericImpl {
    @Autowired
    private ServiceAtendPedidoAlmoxItemGradeImpl serviceAtendPedidoAlmoxItemGrade;
    @Autowired
    private ServiceNecessidadeCompraImpl serviceNecessidadeCompra;
    @Autowired
    private ServiceFabricanteImpl serviceFabricante;
    @Autowired
    private ServiceEspecieImpl serviceEspecie;
    @Autowired
    private ServiceSubEspecieImpl serviceSubEspecie;
    @Autowired
    private ServiceGrupoProdutosImpl serviceGrupoProdutos;
    @Autowired
    private ServiceClassificacaoAnaliseEstoqueImpl serviceClassificacaoAnaliseEstoque;
    @Autowired
    private SCompNecessidadeCompraPedAlmox compNecessidadeCompraPedAlmox;
    @Autowired
    private SCompNecessidadeCompraRessuprimento compNecessidadeCompraRessup;
    @Autowired
    private SCompNecessidadeCompraRessuprimentoProduto compNecessidadeCompraRessupProd;
    @Autowired
    private SCompNecCompraPlanejamentoProdLinProd compNecCompraPlanejamentoProdLinProd;
    @Autowired
    private SCompNecCompraPlanejamentoProdLinEnc compNecCompraPlanejamentoProdLinEnc;

    public List<DTONecessidadeCompra> generateNecessidadeRessuprimento(Long dataInicial, Long dataFinal, Usuario usuarioSolicitante, Empresa empresa, OpcoesCompraSuprimentos op, Short gerarNecCompraSepPedAlmox) throws ExceptionInvalidData {
        if (this.isNull(dataInicial).booleanValue() || dataInicial <= 0L) {
            throw new ExceptionInvalidData("E.ERP.1998.001", new Object[0]);
        }
        if (this.isNull(dataFinal).booleanValue() || dataFinal <= 0L) {
            throw new ExceptionInvalidData("E.ERP.1998.002", new Object[0]);
        }
        if (dataFinal < dataInicial) {
            throw new ExceptionInvalidData("E.ERP.1998.005", new Object[0]);
        }
        List<AtendPedidoAlmoxItemGrade> atendimentos = this.serviceAtendPedidoAlmoxItemGrade.findAtendimentosCompra(ToolDate.dataPrimHora((Date)new Date(dataInicial)), ToolDate.dataUltHora((Date)new Date(dataFinal)), empresa);
        if (!ServiceGeracaoNecessidadeCompraImpl.isWithData(atendimentos)) {
            return new ArrayList<DTONecessidadeCompra>();
        }
        return this.buildToDTOGeneric(this.compNecessidadeCompraPedAlmox.generateNecessidadeRessuprimento(atendimentos, usuarioSolicitante, empresa, op, gerarNecCompraSepPedAlmox), DTONecessidadeCompra.class);
    }

    public List<DTONecessidadeCompra> generateNecessidadeRessuprimento(Usuario usuarioSolicitante, Empresa empresa, OpcoesCompraSuprimentos op, Long idFabricante, Long idEspecie, Long idSubespecie, Long idGrupoProdutos, Short filtrarClassificacao, Long idClassificacao, Short tipoProduto) {
        Fabricante fabricante = (Fabricante)this.serviceFabricante.get(idFabricante);
        Especie especie = (Especie)this.serviceEspecie.get(idEspecie);
        SubEspecie subespecie = (SubEspecie)this.serviceSubEspecie.get(idSubespecie);
        GrupoProdutos grupoProdutos = (GrupoProdutos)this.serviceGrupoProdutos.get(idGrupoProdutos);
        ClassificacaoAnaliseEstoque classificacao = (ClassificacaoAnaliseEstoque)this.serviceClassificacaoAnaliseEstoque.get(idClassificacao);
        return this.buildToDTOGeneric(this.compNecessidadeCompraRessup.generateNecessidadeRessuprimento(new Date(), usuarioSolicitante, fabricante, especie, subespecie, grupoProdutos, classificacao, empresa, tipoProduto, op), DTONecessidadeCompra.class);
    }

    public List<DTONecessidadeCompra> generateNecessidadeRessupProduto(Usuario usuarioSolicitante, Empresa empresa, OpcoesCompraSuprimentos op, Long idFabricante, Long idEspecie, Long idSubespecie, Long idGrupoProdutos, Integer tipoProduto, Short produtosSemMovimentacao) {
        Fabricante fabricante = (Fabricante)this.serviceFabricante.get(idFabricante);
        Especie especie = (Especie)this.serviceEspecie.get(idEspecie);
        SubEspecie subespecie = (SubEspecie)this.serviceSubEspecie.get(idSubespecie);
        GrupoProdutos grupoProdutos = (GrupoProdutos)this.serviceGrupoProdutos.get(idGrupoProdutos);
        return this.buildToDTOGeneric(this.compNecessidadeCompraRessupProd.generateNecessidadeRessuprimento(new Date(), usuarioSolicitante, fabricante, especie, subespecie, grupoProdutos, empresa, tipoProduto, produtosSemMovimentacao, op), DTONecessidadeCompra.class);
    }

    public WebDTOResult salvarNecessidadesCompra(List<DTONecessidadeCompra> necessidades) throws ExceptionInvalidData {
        if (!ServiceGeracaoNecessidadeCompraImpl.isWithData(necessidades)) {
            throw new ExceptionInvalidData("E.ERP.1998.003", new Object[0]);
        }
        Object aux = this.serviceNecessidadeCompra.buildToEntity(necessidades);
        WebDTOResult res = new WebDTOResult();
        for (NecessidadeCompra necessidade : aux) {
            if (this.isNotNull(necessidade.getQuantidadeNecessidade()).booleanValue() && necessidade.getQuantidadeNecessidade() > 0.0) {
                this.serviceNecessidadeCompra.saveOrUpdate(necessidade);
                continue;
            }
            res.addErroMessage("E.ERP.1998.008", MessagesBaseMentor.getErrorMsg((String)"E.ERP.1998.008", (Object[])new Object[]{necessidade.getGradeCor().getProdutoGrade().getProduto().getNome()}));
        }
        return res;
    }

    public List<DTOPlanejamentoProdLinhaProdRes> geraNecCompraPlanejamentoProdLinProd(List<DTOPlanejamentoProdLinhaProdRes> planej, OpcoesCompraSuprimentos op) {
        return this.compNecCompraPlanejamentoProdLinProd.gerarNecessidades(planej, op);
    }

    public WebDTOResult salvarNecessidadesPlanejamentosProducaoLinha(List<DTOPlanejamentoProdLinhaProdRes> input) throws ExceptionInvalidData {
        return this.compNecCompraPlanejamentoProdLinProd.salvarNecessidadePlanejProdLinhaProd(input);
    }

    public List<DTOPlanejamentoProdSobEncRes> geraNecCompraPlanejamentoProdLinEnc(List<DTOPlanejamentoProdSobEncRes> planej, OpcoesCompraSuprimentos op) {
        return this.compNecCompraPlanejamentoProdLinEnc.gerarNecessidades(planej, op);
    }

    public WebDTOResult salvarNecessidadesPlanejamentosProducaoEnc(List<DTOPlanejamentoProdSobEncRes> input) throws ExceptionInvalidData {
        return this.compNecCompraPlanejamentoProdLinEnc.salvarNecessidadePlanejProdLinhaEnc(input);
    }
}

