/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaooutrostitulosfolha;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstCnabPagamento;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocValores5011;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.ParametrizacaoFinanceiraFolha;
import com.touchcomp.basementor.model.vo.ParametrizacaoGuiaEventoFolha;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.aberturaperiodo.ServiceAberturaPeriodoImpl;
import com.touchcomp.basementorservice.service.impl.calculoinssempresa.ServiceCalculoInssEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.carteiracobranca.ServiceCarteiraCobrancaImpl;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.esocvalores5011.ServiceEsocValores5011Impl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaofinanceirafolha.ServiceParametrizacaoFinanceiraFolhaImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoguiaeventofolha.ServiceParametrizacaoGuiaEventoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementorservice.service.impl.terminotrabalhadorsemvinculo.ServiceTerminoTrabalhadorSemVinculoImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculo.ServiceTipoCalculoImpl;
import com.touchcomp.basementorservice.service.impl.tipocalculoevento.ServiceTipoCalculoEventoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompGeracaoOutrosTitulosFolha
extends ServiceGenericImpl {
    private final ServiceFeriasColaboradorImpl serviceFeriasColaborador;
    private final CompGeracaoTitulos compGeracaoTitulos;
    private final ServiceCarteiraCobrancaImpl serviceCarteiraCobranca;
    private final ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolha;
    private final ServiceTipoCalculoImpl serviceTipoCalculo;
    private final ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidade;
    private final ServiceRecisaoImpl serviceRecisao;
    private final ServiceTerminoTrabalhadorSemVinculoImpl serviceTerminoTrabalhadorSemVinculo;
    private final ServiceMovimentoFolhaImpl serviceMovimentoFolha;
    private final ServiceEsocValores5011Impl serviceEsocValores5011;
    private final ServiceAberturaPeriodoImpl serviceAberturaPeriodo;
    private final ServiceCalculoInssEmpresaImpl serviceCalculoInssEmpresa;
    private final ServiceTipoCalculoEventoImpl serviceTipoCalculoEvento;
    private final ServiceParametrizacaoGuiaEventoFolhaImpl serviceParametrizacaoGuiaEventoFolha;

    List<ItemOutrosTitulosFolha> geracaoOutrosTitulosFolha(Long idDataPagamento, OpcoesFinanceiras opcoesFinanceiras, Empresa empresa, EmpresaRh empresaRh) throws ExceptionParametrizacao, ExceptionInvalidData {
        Date dataPagamento = new Date(idDataPagamento);
        EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidade.findByEmpresa(empresa);
        if (this.isNull(dataPagamento).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1288.001"));
        }
        return this.gerarTitulosFolha(dataPagamento, opcoesFinanceiras, empresa, empresaContabilidade, empresaRh);
    }

    private List<ItemOutrosTitulosFolha> gerarTitulosFolha(Date dataPagamento, OpcoesFinanceiras opcoesFinanceiras, Empresa empresa, EmpresaContabilidade empresaContabilidade, EmpresaRh empresaRh) throws ExceptionParametrizacao, ExceptionInvalidData {
        ArrayList<ItemOutrosTitulosFolha> titulos = new ArrayList<ItemOutrosTitulosFolha>();
        titulos.addAll(this.gerarTituloFerias(dataPagamento, empresa, opcoesFinanceiras, empresaContabilidade));
        titulos.addAll(this.gerarTituloRecisao(dataPagamento, empresa, opcoesFinanceiras, empresaContabilidade));
        titulos.addAll(this.gerarTituloValoresImpostosFolha(dataPagamento, empresa, opcoesFinanceiras, empresaContabilidade, empresaRh));
        if (this.isEquals(opcoesFinanceiras.getGerarTitulosEventosFolha(), EnumConstantsMentorSimNao.SIM.getValue())) {
            titulos.addAll(this.gerarTituloValoresGuiasEventos(dataPagamento, empresa, opcoesFinanceiras, empresaContabilidade, empresaRh));
        }
        return titulos;
    }

    private List<ItemOutrosTitulosFolha> gerarTituloFerias(Date dataPagamento, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, EmpresaContabilidade empresaContabilidade) throws ExceptionParametrizacao, ExceptionInvalidData {
        ArrayList<ItemOutrosTitulosFolha> titulos = new ArrayList<ItemOutrosTitulosFolha>();
        TipoCalculo tipoCalculo = this.serviceTipoCalculo.findTipoCalculoTipoFolha(EnumConstTipoCalculoEvento.CALCULO_FERIAS.getValue());
        List<FeriasColaborador> listFeriasColaborador = this.serviceFeriasColaborador.findFeriasColaboradorPorDataPagamentoEmpresa(dataPagamento, empresa);
        for (FeriasColaborador feriasColaborador : listFeriasColaborador) {
            List<ParametrizacaoFinanceiraFolha> parametrizacoes = this.serviceParametrizacaoFinanceiraFolha.getParamPorTipoColaboradorCentroCustoTipoFolha(feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getTipoColaborador().getIdentificador(), feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getCentroCusto().getIdentificador(), tipoCalculo.getIdentificador());
            ParametrizacaoFinanceiraFolha parametrizacao = this.getParametrizacaoFinanceiraFolha(parametrizacoes, tipoCalculo, feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getCentroCusto(), feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getTipoColaborador());
            Titulo titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getPessoa(), parametrizacao.getPlanoContaContabil(), EnumConstPessoa.COLABORADOR.getEnumId(), feriasColaborador.getDataPagamento(), feriasColaborador.getDataPagamento(), feriasColaborador.getDataPagamento(), feriasColaborador.getDataPagamento(), MessagesBaseMentor.getMsg((String)"tituloReferenteFeriasColaborador", (Object[])new Object[]{feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getPessoa().getNome()}), empresa, opcoesFinanceiras, feriasColaborador.getVrLiquidoFerias() + feriasColaborador.getVlrLiquidoAddDec(), this.verificarCarteiraDestino(feriasColaborador.getPeriodoAqFeriasColab().getColaborador(), empresa), parametrizacao.getPlanoContaGerencial(), feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getCentroCusto());
            if (this.isNotNull(titulo).booleanValue()) {
                titulos.add(this.build(titulo, feriasColaborador));
            }
            if (!ToolMethods.isWithData((Number)feriasColaborador.getVrIrrfFerias())) continue;
            if (this.isNull(empresaContabilidade.getPlanoContaIrrfFolha()).booleanValue() || this.isNull(empresaContabilidade.getPlanoIrrfGerencialFolha()).booleanValue() || this.isNull(empresaContabilidade.getPessoaIrrfFolha()).booleanValue() || this.isNull(empresaContabilidade.getDiaIrrfFolha()).booleanValue()) {
                throw new ExceptionInvalidData("E.ERP.1288.006", new Object[]{empresaContabilidade.getIdentificador()});
            }
            Titulo tituloIRRFFolha = this.gerarTituloIRRFFolha(feriasColaborador, empresa, opcoesFinanceiras, empresaContabilidade);
            if (!this.isNotNull(tituloIRRFFolha).booleanValue()) continue;
            titulos.add(this.build(tituloIRRFFolha, feriasColaborador));
        }
        return titulos;
    }

    private ItemOutrosTitulosFolha build(Titulo titulo, FeriasColaborador ferias) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setFeriasColaborador(ferias);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private ItemOutrosTitulosFolha build(Titulo titulo, Recisao recisao) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setRecisao(recisao);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private ItemOutrosTitulosFolha build(Titulo titulo, TerminoTrabalhadorSemVinculo tsv) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setTerminoTSV(tsv);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private ItemOutrosTitulosFolha buildItemOutrosTitulosFolhaFGTS(Titulo titulo, AberturaPeriodo aberturaPeriodo) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setAberturaPeriodoFgts(aberturaPeriodo);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private ItemOutrosTitulosFolha buildItemOutrosTitulosFolhaIRRF(Titulo titulo, AberturaPeriodo aberturaPeriodo) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setAberturaPeriodoIrrf(aberturaPeriodo);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private ItemOutrosTitulosFolha build(Titulo titulo, EsocValores5011 inss) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setEsocValores5011(inss);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private ItemOutrosTitulosFolha build(Titulo titulo, CalculoInssEmpresa calculoInssEmpresa) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setCalculoInssEmpresa(calculoInssEmpresa);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private ItemOutrosTitulosFolha build(Titulo titulo, TipoCalculoEvento tipoCalculoEvento) {
        ItemOutrosTitulosFolha vo = new ItemOutrosTitulosFolha();
        vo.setTipoCalculoEvento(tipoCalculoEvento);
        vo.setTitulos(Arrays.asList(titulo));
        return vo;
    }

    private Titulo gerarTituloIRRFFolha(FeriasColaborador feriasColaborador, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        if (this.isNull(empresaContabilidade.getPlanoContaIrrfFolha()).booleanValue() || this.isNull(empresaContabilidade.getPlanoIrrfGerencialFolha()).booleanValue() || this.isNull(empresaContabilidade.getPessoaIrrfFolha()).booleanValue() || this.isNull(empresaContabilidade.getDiaIrrfFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.006", new Object[]{empresaContabilidade.getIdentificador()});
        }
        return this.compGeracaoTitulos.gerarOutrosTitulosFolha(empresaContabilidade.getPessoaIrrfFolha(), empresaContabilidade.getPlanoContaIrrfFolha(), EnumConstPessoa.EMPRESA.getEnumId(), this.getDataPagamentoIrrf(feriasColaborador.getDataPagamento(), empresaContabilidade.getDiaIrrfFolha()), feriasColaborador.getDataPagamento(), feriasColaborador.getDataPagamento(), feriasColaborador.getDataPagamento(), MessagesBaseMentor.getMsg((String)"tituloReferenteIRRFFeriasColaborador", (Object[])new Object[]{feriasColaborador.getPeriodoAqFeriasColab().getColaborador().getPessoa().getNome()}), empresa, opcoesFinanceiras, feriasColaborador.getVrIrrfFerias(), null, empresaContabilidade.getPlanoIrrfGerencialFolha(), feriasColaborador.getCentroCusto());
    }

    private ParametrizacaoFinanceiraFolha getParametrizacaoFinanceiraFolha(List<ParametrizacaoFinanceiraFolha> parametrizacoes, TipoCalculo tipoCalculo, CentroCusto centroCusto, TipoColaborador tipoColaborador) throws ExceptionParametrizacao {
        if (!SCompGeracaoOutrosTitulosFolha.isWithData(parametrizacoes)) {
            throw new ExceptionParametrizacao("E.ERP.1288.002", new Object[]{centroCusto != null ? centroCusto.getNome() : "", tipoColaborador != null ? tipoColaborador.getDescricao() : "", tipoCalculo != null ? tipoCalculo.getDescricao() : ""});
        }
        if (parametrizacoes.size() > 1) {
            throw new ExceptionParametrizacao("E.ERP.1288.003", new Object[]{centroCusto != null ? centroCusto.getNome() : "", tipoColaborador != null ? tipoColaborador.getDescricao() : "", tipoCalculo != null ? tipoCalculo.getDescricao() : "", this.getIdentificadoresParametrizacoes(parametrizacoes)});
        }
        ParametrizacaoFinanceiraFolha parametrizacao = parametrizacoes.getFirst();
        if (this.isNull(parametrizacao.getPlanoContaContabil()).booleanValue()) {
            throw new ExceptionParametrizacao("E.ERP.1288.004", new Object[]{parametrizacao.getIdentificador()});
        }
        if (this.isNull(parametrizacao.getPlanoContaGerencial()).booleanValue()) {
            throw new ExceptionParametrizacao("E.ERP.1288.005", new Object[]{parametrizacao.getIdentificador()});
        }
        return parametrizacao;
    }

    private String getIdentificadoresParametrizacoes(List<ParametrizacaoFinanceiraFolha> parametrizacoes) {
        Object ret = "";
        for (ParametrizacaoFinanceiraFolha p : parametrizacoes) {
            ret = (String)ret + p.getIdentificador() + ";";
        }
        return ret;
    }

    private List<ItemOutrosTitulosFolha> gerarTituloRecisao(Date dataPagamento, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, EmpresaContabilidade empresaContabilidade) throws ExceptionParametrizacao {
        Titulo titulo;
        ArrayList<ItemOutrosTitulosFolha> titulos = new ArrayList<ItemOutrosTitulosFolha>();
        TipoCalculo tipoCalculo = this.serviceTipoCalculo.findTipoCalculoTipoFolha(EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue());
        List<Recisao> listRecisao = this.serviceRecisao.findRecisaoPorDataPagamentoEmpresa(dataPagamento, empresa);
        for (Recisao recisao : listRecisao) {
            Double totalIrrfRecisao;
            Titulo titulo2;
            if (recisao.getColaborador() == null) continue;
            List<ParametrizacaoFinanceiraFolha> parametrizacoes = this.serviceParametrizacaoFinanceiraFolha.getParamPorTipoColaboradorCentroCustoTipoFolha(recisao.getColaborador().getTipoColaborador().getIdentificador(), recisao.getColaborador().getCentroCusto().getIdentificador(), tipoCalculo.getIdentificador());
            ParametrizacaoFinanceiraFolha parametrizacao = this.getParametrizacaoFinanceiraFolha(parametrizacoes, tipoCalculo, recisao.getColaborador().getCentroCusto(), recisao.getColaborador().getTipoColaborador());
            if (ToolMethods.isWithData((Number)recisao.getVlrLiquido()) && this.isNotNull(titulo2 = this.compGeracaoTitulos.gerarOutrosTitulosFolha(recisao.getColaborador().getPessoa(), parametrizacao.getPlanoContaContabil(), EnumConstPessoa.COLABORADOR.getEnumId(), recisao.getDataPagamento(), recisao.getDataPagamento(), recisao.getDataPagamento(), recisao.getDataPagamento(), MessagesBaseMentor.getMsg((String)"tituloReferenteRecisaoColaborador", (Object[])new Object[]{recisao.getColaborador().getPessoa().getNome()}), empresa, opcoesFinanceiras, recisao.getVlrLiquido(), this.verificarCarteiraDestino(recisao.getColaborador(), empresa), parametrizacao.getPlanoContaGerencial(), recisao.getColaborador().getCentroCusto())).booleanValue()) {
                titulos.add(this.build(titulo2, recisao));
            }
            if (ToolMethods.isWithData((Number)(totalIrrfRecisao = Double.valueOf(recisao.getVrlIrrf() + recisao.getVlrIrrf13() + recisao.getVlrIrrfFerias()))) && this.isNotNull(titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(empresaContabilidade.getPessoaIrrfFolha(), empresaContabilidade.getPlanoContaIrrfFolha(), EnumConstPessoa.EMPRESA.getEnumId(), this.getDataPagamentoIrrf(recisao.getDataPagamento(), empresaContabilidade.getDiaIrrfFolha()), recisao.getDataPagamento(), recisao.getDataPagamento(), recisao.getDataPagamento(), MessagesBaseMentor.getMsg((String)"tituloReferenteIRRFRecisaoColaborador", (Object[])new Object[]{recisao.getColaborador().getPessoa().getNome()}), empresa, opcoesFinanceiras, totalIrrfRecisao, null, empresaContabilidade.getPlanoIrrfGerencialFolha(), recisao.getCentroCusto())).booleanValue()) {
                titulos.add(this.build(titulo, recisao));
            }
            if (!ToolMethods.isWithData((Number)recisao.getVlrTotalGrrf()) || !this.isNotNull(titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(empresaContabilidade.getPessoaGrrf(), empresaContabilidade.getPlanoContaGrrf(), EnumConstPessoa.EMPRESA.getEnumId(), recisao.getDataVencimentoGrrf(), recisao.getDataVencimentoGrrf(), recisao.getDataVencimentoGrrf(), recisao.getDataVencimentoGrrf(), MessagesBaseMentor.getMsg((String)"tituloReferenteGRRFRecisaoColaborador", (Object[])new Object[]{recisao.getColaborador().getPessoa().getNome()}), empresa, opcoesFinanceiras, recisao.getVlrTotalGrrf(), null, empresaContabilidade.getPlanoGrrfGerencial(), recisao.getCentroCusto())).booleanValue()) continue;
            titulos.add(this.build(titulo, recisao));
        }
        List<TerminoTrabalhadorSemVinculo> listTerminoTrabalhadorSemVinculo = this.serviceTerminoTrabalhadorSemVinculo.findTerminoTrabalhadorSemVinculoPorDataPagamentoEmpresa(dataPagamento, empresa);
        for (TerminoTrabalhadorSemVinculo terminoTrabalhadorSemVinculo : listTerminoTrabalhadorSemVinculo) {
            List<ParametrizacaoFinanceiraFolha> parametrizacoes = this.serviceParametrizacaoFinanceiraFolha.getParamPorTipoColaboradorCentroCustoTipoFolha(terminoTrabalhadorSemVinculo.getColaborador().getTipoColaborador().getIdentificador(), terminoTrabalhadorSemVinculo.getColaborador().getCentroCusto().getIdentificador(), tipoCalculo.getIdentificador());
            ParametrizacaoFinanceiraFolha parametrizacao = this.getParametrizacaoFinanceiraFolha(parametrizacoes, tipoCalculo, terminoTrabalhadorSemVinculo.getColaborador().getCentroCusto(), terminoTrabalhadorSemVinculo.getColaborador().getTipoColaborador());
            titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(terminoTrabalhadorSemVinculo.getColaborador().getPessoa(), parametrizacao.getPlanoContaContabil(), EnumConstPessoa.COLABORADOR.getEnumId(), terminoTrabalhadorSemVinculo.getDataPagamento(), terminoTrabalhadorSemVinculo.getDataPagamento(), terminoTrabalhadorSemVinculo.getDataPagamento(), terminoTrabalhadorSemVinculo.getDataPagamento(), MessagesBaseMentor.getMsg((String)"tituloReferenteTSVColaborador", (Object[])new Object[]{terminoTrabalhadorSemVinculo.getColaborador().getPessoa().getNome()}), empresa, opcoesFinanceiras, terminoTrabalhadorSemVinculo.getTotalLiquido(), this.verificarCarteiraDestino(terminoTrabalhadorSemVinculo.getColaborador(), empresa), parametrizacao.getPlanoContaGerencial(), terminoTrabalhadorSemVinculo.getColaborador().getCentroCusto());
            if (!this.isNotNull(titulo).booleanValue()) continue;
            titulos.add(this.build(titulo, terminoTrabalhadorSemVinculo));
        }
        return titulos;
    }

    private List<ItemOutrosTitulosFolha> gerarTituloValoresImpostosFolha(Date dataPagamento, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, EmpresaContabilidade empresaContabilidade, EmpresaRh empresaRh) throws ExceptionInvalidData {
        List<HashMap> listMovimentoFolhaIrrf;
        ArrayList<ItemOutrosTitulosFolha> titulos = new ArrayList<ItemOutrosTitulosFolha>();
        List<HashMap> listMovimentoFolhaFgts = this.serviceMovimentoFolha.findMovimentoFolhaPorDataPagamentoEmpresa(dataPagamento, empresa);
        if (SCompGeracaoOutrosTitulosFolha.isWithData(listMovimentoFolhaFgts)) {
            this.validarDadosFgtsEmpresaContabilidade(empresaContabilidade);
        }
        for (HashMap h : listMovimentoFolhaFgts) {
            Titulo titulo;
            Object aberturaPeriodoFgts;
            if (!ToolMethods.isWithData((Number)((Number)h.get("FGTS"))) || !this.isNotNull(aberturaPeriodoFgts = (AberturaPeriodo)this.serviceAberturaPeriodo.get((Long)h.get("ID"))).booleanValue() || !this.isNotNull(titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(empresaContabilidade.getPessoaFgtsFolha(), empresaContabilidade.getPlanoContaFgtsFolha(), EnumConstPessoa.EMPRESA.getEnumId(), this.getDataPagamento(dataPagamento, empresaContabilidade.getDiaFgtsFolha(), (Date)h.get("DATA_FINAL"), (Short)h.get("TIPO_FOLHA")), (Date)h.get("DATA_FINAL"), (Date)h.get("DATA_FINAL"), (Date)h.get("DATA_FINAL"), MessagesBaseMentor.getMsg((String)"tituloReferenteFgtsFolha", (Object[])new Object[]{empresaContabilidade.getPessoaFgtsFolha().getNome()}), empresa, opcoesFinanceiras, (Double)h.get("FGTS"), null, empresaContabilidade.getPlanoFgtsGerencialFolha(), null)).booleanValue()) continue;
            titulos.add(this.buildItemOutrosTitulosFolhaFGTS(titulo, (AberturaPeriodo)aberturaPeriodoFgts));
        }
        List<AberturaPeriodo> aberturas = this.serviceAberturaPeriodo.findAberturaPeriodoPorDataPagamentoAndEmpresa(dataPagamento, empresa);
        if (ToolMethods.isWithData(aberturas)) {
            ArrayList<EsocValores5011> listCalculoInssEmpresaInss = new ArrayList<EsocValores5011>();
            for (AberturaPeriodo aberturaPeriodo : aberturas) {
                listCalculoInssEmpresaInss.addAll(this.serviceEsocValores5011.findValores(empresa.getEmpresaDados().getGrupoEmpresa(), aberturaPeriodo.getDataFinal()));
            }
            if (SCompGeracaoOutrosTitulosFolha.isWithData(listCalculoInssEmpresaInss)) {
                this.validarDadosInssEmpresaContabilidade(empresaContabilidade);
            }
            for (EsocValores5011 esocValores5011 : listCalculoInssEmpresaInss) {
                Titulo titulo;
                if (!ToolMethods.isWithData((Number)esocValores5011.getSaldoAPagar()) || !this.isNotNull(titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(empresaContabilidade.getPessoaInssFolha(), empresaContabilidade.getPlanoContaInssFolha(), EnumConstPessoa.EMPRESA.getEnumId(), this.getDataPagamento(dataPagamento, empresaContabilidade.getDiaInssFolha(), ToolDate.getDateLastMonthDay((Date)dataPagamento), null), esocValores5011.getPeriodoApuracao(), esocValores5011.getPeriodoApuracao(), esocValores5011.getPeriodoApuracao(), MessagesBaseMentor.getMsg((String)"tituloReferenteInssFolha", (Object[])new Object[]{empresaContabilidade.getPessoaInssFolha().getNome()}), empresa, opcoesFinanceiras, esocValores5011.getSaldoAPagar(), null, empresaContabilidade.getPlanoInssGerencialFolha(), null)).booleanValue()) continue;
                titulos.add(this.build(titulo, esocValores5011));
            }
            if (!SCompGeracaoOutrosTitulosFolha.isWithData(listCalculoInssEmpresaInss)) {
                List<HashMap> listCalculoInssEmpresa = this.serviceCalculoInssEmpresa.findCalculoInssEmpresaPorDataPagamentoEmpresa(dataPagamento, empresa);
                if (SCompGeracaoOutrosTitulosFolha.isWithData(listCalculoInssEmpresa)) {
                    this.validarDadosInssEmpresaContabilidade(empresaContabilidade);
                }
                for (HashMap h : listCalculoInssEmpresa) {
                    Titulo titulo;
                    Long idCalculoInssEmpresa = (Long)h.get("ID_CALCULO_INSS_EMPRESA");
                    Double gps = (Double)h.get("GPS");
                    Date dataFinal = (Date)h.get("DATA_FINAL");
                    if (!ToolMethods.isWithData((Number)gps) || !this.isNotNull(titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(empresaContabilidade.getPessoaInssFolha(), empresaContabilidade.getPlanoContaInssFolha(), EnumConstPessoa.EMPRESA.getEnumId(), this.getDataPagamento(dataPagamento, empresaContabilidade.getDiaInssFolha(), ToolDate.getDateLastMonthDay((Date)dataPagamento), null), dataFinal, dataFinal, dataFinal, MessagesBaseMentor.getMsg((String)"tituloReferenteInssFolha", (Object[])new Object[]{empresaContabilidade.getPessoaInssFolha().getNome()}), empresa, opcoesFinanceiras, gps, null, empresaContabilidade.getPlanoInssGerencialFolha(), null)).booleanValue()) continue;
                    titulos.add(this.build(titulo, (CalculoInssEmpresa)this.serviceCalculoInssEmpresa.get(idCalculoInssEmpresa)));
                }
            }
        }
        if (SCompGeracaoOutrosTitulosFolha.isWithData(listMovimentoFolhaIrrf = this.serviceMovimentoFolha.findMovimentoFolhaPorDataPagamentoEmpresaTipoCalculo(dataPagamento, empresa, (short)3))) {
            this.validarDadoIrrfEmpresaContabilidade(empresaContabilidade);
        }
        for (HashMap hashMap : listMovimentoFolhaIrrf) {
            Titulo titulo;
            AberturaPeriodo aberturaPeriodoIrrf;
            if (!ToolMethods.isWithData((Number)((Number)hashMap.get("IRRF"))) || !this.isNotNull(aberturaPeriodoIrrf = (AberturaPeriodo)this.serviceAberturaPeriodo.get((Long)hashMap.get("ID"))).booleanValue() || !this.isNotNull(titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(empresaContabilidade.getPessoaIrrfFolha(), empresaContabilidade.getPlanoContaIrrfFolha(), EnumConstPessoa.EMPRESA.getEnumId(), this.getDataPagamentoIrrf(dataPagamento, empresaContabilidade.getDiaIrrfFolha()), (Date)hashMap.get("DATA_FINAL"), (Date)hashMap.get("DATA_FINAL"), (Date)hashMap.get("DATA_FINAL"), MessagesBaseMentor.getMsg((String)"tituloReferenteImpostoRenda", (Object[])new Object[]{empresaContabilidade.getPessoaIrrfFolha().getNome()}), empresa, opcoesFinanceiras, (Double)hashMap.get("IRRF"), null, empresaContabilidade.getPlanoIrrfGerencialFolha(), null)).booleanValue()) continue;
            titulos.add(this.buildItemOutrosTitulosFolhaIRRF(titulo, aberturaPeriodoIrrf));
        }
        return titulos;
    }

    private List<ItemOutrosTitulosFolha> gerarTituloValoresGuiasEventos(Date dataPagamento, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, EmpresaContabilidade empresaContabilidade, EmpresaRh empresaRh) throws ExceptionParametrizacao {
        ArrayList<ItemOutrosTitulosFolha> titulos = new ArrayList<ItemOutrosTitulosFolha>();
        List<HashMap> listItemMovimentoFolha = this.serviceMovimentoFolha.findItemMovimentoFolhaPorDataPagamentoEmpresa(dataPagamento, empresa);
        for (HashMap h : listItemMovimentoFolha) {
            Long idTipoCalculoEvento = (Long)h.get("ID_EVENTO");
            String descricaoEvento = (String)h.get("DESCRICAO");
            Double valor = (Double)h.get("VALOR");
            Date dataFinal = (Date)h.get("DATA_FINAL");
            if (!ToolMethods.isWithData((Number)valor)) continue;
            List<ParametrizacaoGuiaEventoFolha> listParametrizacaoGuiaEventoFolha = this.serviceParametrizacaoGuiaEventoFolha.getParamPorEvento(idTipoCalculoEvento);
            ParametrizacaoGuiaEventoFolha parametrizacao = this.getParametrizacaoGuiaEventoFolha(listParametrizacaoGuiaEventoFolha, descricaoEvento);
            Titulo titulo = this.compGeracaoTitulos.gerarOutrosTitulosFolha(parametrizacao.getPessoa(), parametrizacao.getPlanoContaContabil(), EnumConstPessoa.EMPRESA.getEnumId(), this.getDataPagamento(dataPagamento, parametrizacao.getDiaVencimento(), dataFinal, null), dataFinal, dataFinal, dataFinal, MessagesBaseMentor.getMsg((String)"tituloReferenteGuia", (Object[])new Object[]{parametrizacao.getPessoa().getNome()}), empresa, opcoesFinanceiras, valor, null, parametrizacao.getPlanoContaGerencial(), null);
            if (!this.isNotNull(titulo).booleanValue()) continue;
            titulos.add(this.build(titulo, (TipoCalculoEvento)this.serviceTipoCalculoEvento.get(idTipoCalculoEvento)));
        }
        return titulos;
    }

    private ParametrizacaoGuiaEventoFolha getParametrizacaoGuiaEventoFolha(List<ParametrizacaoGuiaEventoFolha> listParametrizacaoGuiaEventoFolha, String descricaoEvento) throws ExceptionParametrizacao {
        if (!SCompGeracaoOutrosTitulosFolha.isWithData(listParametrizacaoGuiaEventoFolha)) {
            throw new ExceptionParametrizacao("E.ERP.1288.010", new Object[]{descricaoEvento});
        }
        if (listParametrizacaoGuiaEventoFolha.size() > 1) {
            throw new ExceptionParametrizacao("E.ERP.1288.011", new Object[]{descricaoEvento});
        }
        return listParametrizacaoGuiaEventoFolha.getFirst();
    }

    private void validarDadoIrrfEmpresaContabilidade(EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        if (this.isNull(empresaContabilidade.getPlanoContaIrrfFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.006", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getPlanoIrrfGerencialFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.006", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getPessoaIrrfFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.006", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getDiaIrrfFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.006", new Object[]{empresaContabilidade.getIdentificador()});
        }
    }

    private void validarDadosInssEmpresaContabilidade(EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        if (this.isNull(empresaContabilidade.getPlanoContaInssFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.009", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getPlanoInssGerencialFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.009", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getPessoaInssFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.009", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getDiaInssFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.009", new Object[]{empresaContabilidade.getIdentificador()});
        }
    }

    private void validarDadosFgtsEmpresaContabilidade(EmpresaContabilidade empresaContabilidade) throws ExceptionInvalidData {
        if (this.isNull(empresaContabilidade.getPlanoContaFgtsFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.008", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getPlanoFgtsGerencialFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.008", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getPessoaFgtsFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.008", new Object[]{empresaContabilidade.getIdentificador()});
        }
        if (this.isNull(empresaContabilidade.getDiaFgtsFolha()).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1288.008", new Object[]{empresaContabilidade.getIdentificador()});
        }
    }

    private CarteiraCobranca verificarCarteiraDestino(Colaborador colaborador, Empresa empresa) {
        if (this.isEquals(colaborador.getTipoPagamento(), EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId()) && SCompGeracaoOutrosTitulosFolha.isWithData(colaborador.getPessoa().getContaSalarioColaborador())) {
            for (ContaSalarioColaborador contaSalarioColaborador : colaborador.getPessoa().getContaSalarioColaborador()) {
                if (!this.isEquals(contaSalarioColaborador.getAtivo(), EnumConstantsMentorSimNao.SIM.getValue()) || !this.isEquals(contaSalarioColaborador.getPreferencial(), EnumConstantsMentorSimNao.SIM.getValue())) continue;
                return this.serviceCarteiraCobranca.findCarteiraCobrancaByColaborador(contaSalarioColaborador.getInstituicaoValor().getIdentificador(), empresa.getIdentificador());
            }
        }
        return null;
    }

    private Date getDataPagamentoIrrf(Date dataPagamento, Short diaIrrfFolha) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataPagamento);
        g.add(2, 1);
        g.set(5, diaIrrfFolha.shortValue());
        return g.getTime();
    }

    private Date getDataPagamento(Date dataPagamento, Short diaVencimento, Date dataFinal, Short tipoFolha) {
        if (!this.isEquals(ToolDate.dayFromDate((Date)dataFinal), ToolDate.dayFromDate((Date)dataPagamento))) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime(dataPagamento);
            g.set(5, diaVencimento.shortValue());
            if (this.isNotNull(tipoFolha).booleanValue() && (this.isEquals(tipoFolha, EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()) || this.isEquals(tipoFolha, EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue()))) {
                g.add(2, 1);
            }
            return g.getTime();
        }
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataPagamento);
        g.add(2, 1);
        g.set(5, diaVencimento.shortValue());
        return g.getTime();
    }

    @Generated
    public SCompGeracaoOutrosTitulosFolha(ServiceFeriasColaboradorImpl serviceFeriasColaborador, CompGeracaoTitulos compGeracaoTitulos, ServiceCarteiraCobrancaImpl serviceCarteiraCobranca, ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolha, ServiceTipoCalculoImpl serviceTipoCalculo, ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidade, ServiceRecisaoImpl serviceRecisao, ServiceTerminoTrabalhadorSemVinculoImpl serviceTerminoTrabalhadorSemVinculo, ServiceMovimentoFolhaImpl serviceMovimentoFolha, ServiceEsocValores5011Impl serviceEsocValores5011, ServiceAberturaPeriodoImpl serviceAberturaPeriodo, ServiceCalculoInssEmpresaImpl serviceCalculoInssEmpresa, ServiceTipoCalculoEventoImpl serviceTipoCalculoEvento, ServiceParametrizacaoGuiaEventoFolhaImpl serviceParametrizacaoGuiaEventoFolha) {
        this.serviceFeriasColaborador = serviceFeriasColaborador;
        this.compGeracaoTitulos = compGeracaoTitulos;
        this.serviceCarteiraCobranca = serviceCarteiraCobranca;
        this.serviceParametrizacaoFinanceiraFolha = serviceParametrizacaoFinanceiraFolha;
        this.serviceTipoCalculo = serviceTipoCalculo;
        this.serviceEmpresaContabilidade = serviceEmpresaContabilidade;
        this.serviceRecisao = serviceRecisao;
        this.serviceTerminoTrabalhadorSemVinculo = serviceTerminoTrabalhadorSemVinculo;
        this.serviceMovimentoFolha = serviceMovimentoFolha;
        this.serviceEsocValores5011 = serviceEsocValores5011;
        this.serviceAberturaPeriodo = serviceAberturaPeriodo;
        this.serviceCalculoInssEmpresa = serviceCalculoInssEmpresa;
        this.serviceTipoCalculoEvento = serviceTipoCalculoEvento;
        this.serviceParametrizacaoGuiaEventoFolha = serviceParametrizacaoGuiaEventoFolha;
    }
}

