/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaooutrostitulosfolha;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GeracaoOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.dao.impl.DaoGeracaoOutrosTitulosFolhaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.empresarh.ServiceEmpresaRhImpl;
import com.touchcomp.basementorservice.service.impl.geracaooutrostitulosfolha.SCompGeracaoOutrosTitulosFolha;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.touchvomodel.vo.geracaooutrostitulosfolha.web.DTOGeracaoOutrosTitulosFolha;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGeracaoOutrosTitulosFolhaImpl
extends ServiceGenericEntityImpl<GeracaoOutrosTitulosFolha, Long, DaoGeracaoOutrosTitulosFolhaImpl> {
    ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceiras;
    ServiceEmpresaImpl serviceEmpresa;
    ServiceEmpresaRhImpl serviceEmpresaRh;
    SCompGeracaoOutrosTitulosFolha sCompGeracaoOutrosTitulosFolha;

    @Autowired
    public ServiceGeracaoOutrosTitulosFolhaImpl(DaoGeracaoOutrosTitulosFolhaImpl dao, ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceiras, ServiceEmpresaImpl serviceEmpresa, ServiceEmpresaRhImpl serviceEmpresaRh, SCompGeracaoOutrosTitulosFolha sCompGeracaoOutrosTitulosFolha) {
        super(dao);
        this.serviceOpcoesFinanceiras = serviceOpcoesFinanceiras;
        this.serviceEmpresa = serviceEmpresa;
        this.serviceEmpresaRh = serviceEmpresaRh;
        this.sCompGeracaoOutrosTitulosFolha = sCompGeracaoOutrosTitulosFolha;
    }

    public List<GeracaoOutrosTitulosFolha> findGeracaoOutrosTitulosFolhaDataPagamento(Date dataPagamento, Empresa empresa) {
        return ((DaoGeracaoOutrosTitulosFolhaImpl)this.getDao()).findGeracaoOutrosTitulosFolhaDataPagamento(dataPagamento, empresa);
    }

    @Override
    public GeracaoOutrosTitulosFolha beforeSave(GeracaoOutrosTitulosFolha vo) {
        if (ServiceGeracaoOutrosTitulosFolhaImpl.isWithData(vo.getTitulos())) {
            for (ItemOutrosTitulosFolha t : vo.getTitulos()) {
                t.setGeracaoOutrosTitulosFolha(vo);
                if (!ServiceGeracaoOutrosTitulosFolhaImpl.isWithData(t.getTitulos())) continue;
                t.getTitulos().forEach(i -> i.setGeracaoOutrosTitulosFolha(t));
            }
        }
        return vo;
    }

    public List<DTOGeracaoOutrosTitulosFolha.DTOItemOutrosTitulosFolha> geracaoOutrosTitulosFolha(Long dataPagamento, CapsEmpresa capsEmpresa) throws ExceptionParametrizacao, ExceptionInvalidData {
        Empresa empresa = (Empresa)this.serviceEmpresa.get(capsEmpresa.get());
        return this.geracaoOutrosTitulosFolha(dataPagamento, empresa);
    }

    public List<DTOGeracaoOutrosTitulosFolha.DTOItemOutrosTitulosFolha> geracaoOutrosTitulosFolha(Long dataPagamento, Empresa empresa) throws ExceptionParametrizacao, ExceptionInvalidData {
        List<ItemOutrosTitulosFolha> titulos = this.gerarOutrosTitulosFolha(dataPagamento, empresa);
        return this.buildToDTOGeneric(titulos, DTOGeracaoOutrosTitulosFolha.DTOItemOutrosTitulosFolha.class);
    }

    public List<ItemOutrosTitulosFolha> gerarOutrosTitulosFolha(Long dataPagamento, Empresa empresa) throws ExceptionParametrizacao, ExceptionInvalidData {
        OpcoesFinanceiras opcoesFinanceiras = this.serviceOpcoesFinanceiras.getByIdEmpresa(empresa.getIdentificador());
        EmpresaRh empresaRh = this.serviceEmpresaRh.getByIdEmpresa(empresa.getIdentificador());
        return this.sCompGeracaoOutrosTitulosFolha.geracaoOutrosTitulosFolha(dataPagamento, opcoesFinanceiras, empresa, empresaRh);
    }
}

