/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaoreciborpa;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GeracaoReciboRpa;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.ParametrizacaoFinanceiraFolha;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.geracaoreciborpa.CompLancamentoGeracaoReciboRpa;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoGeracaoReciboRpaImpl;
import com.touchcomp.basementorservice.helpers.impl.geracaoreciborpa.HelperGeracaoReciboRpa;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaFreteCtrcImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosFreteCtrcImp;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaofinanceirafolha.ServiceParametrizacaoFinanceiraFolhaImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.colaborador.web.DTOColaboradorRes;
import com.touchcomp.touchvomodel.vo.geracaoreciborpa.web.DTOGeracaoReciboRpa;
import com.touchcomp.touchvomodel.vo.geracaoreciborpa.web.DTONotaPropriaTerceiroRPA;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ServiceGeracaoReciboRpaImpl
extends ServiceGenericEntityImpl<GeracaoReciboRpa, Long, DaoGeracaoReciboRpaImpl> {
    ServiceNotaFiscalPropriaFreteCtrcImpl serviceNotaFiscalPropriaFreteCtrcImpl;
    ServiceNotaFiscalTerceirosFreteCtrcImp serviceNotaFiscalTerceirosFreteCtrcImp;
    ServiceColaboradorImpl serviceColaboradorImpl;
    HelperGeracaoReciboRpa helperGeracaoReciboRpa;
    ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolhaImpl;
    CompGeracaoTitulos compGeracaoTitulos;
    ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropriaImpl;
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    ServiceTituloImpl serviceTituloImpl;
    CompLancamentoGeracaoReciboRpa compLancamentoGeracaoReciboRpa;

    public ServiceGeracaoReciboRpaImpl(DaoGeracaoReciboRpaImpl genericDao, ServiceNotaFiscalPropriaFreteCtrcImpl serviceNotaFiscalPropriaFreteCtrcImpl, ServiceNotaFiscalTerceirosFreteCtrcImp serviceNotaFiscalTerceirosFreteCtrcImp, ServiceColaboradorImpl serviceColaboradorImpl, HelperGeracaoReciboRpa helperGeracaoReciboRpa, ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolhaImpl, CompGeracaoTitulos compGeracaoTitulos, ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropriaImpl, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl, ServiceTituloImpl serviceTituloImpl, CompLancamentoGeracaoReciboRpa compLancamentoGeracaoReciboRpa) {
        super(genericDao);
        this.serviceNotaFiscalPropriaFreteCtrcImpl = serviceNotaFiscalPropriaFreteCtrcImpl;
        this.serviceNotaFiscalTerceirosFreteCtrcImp = serviceNotaFiscalTerceirosFreteCtrcImp;
        this.serviceColaboradorImpl = serviceColaboradorImpl;
        this.helperGeracaoReciboRpa = helperGeracaoReciboRpa;
        this.serviceParametrizacaoFinanceiraFolhaImpl = serviceParametrizacaoFinanceiraFolhaImpl;
        this.compGeracaoTitulos = compGeracaoTitulos;
        this.serviceNotaFiscalPropriaImpl = serviceNotaFiscalPropriaImpl;
        this.serviceNotaFiscalTerceirosImpl = serviceNotaFiscalTerceirosImpl;
        this.serviceTituloImpl = serviceTituloImpl;
        this.compLancamentoGeracaoReciboRpa = compLancamentoGeracaoReciboRpa;
    }

    @Override
    public GeracaoReciboRpa beforeDeleteEntity(GeracaoReciboRpa vo) {
        if (this.isEquals(vo.getLancado(), EnumConstantsMentorSimNao.SIM.getValue())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.012"));
        }
        Long rpaPosterior = ((DaoGeracaoReciboRpaImpl)this.getGenericDao()).getRpaPosteriores(vo.getIdentificador(), vo.getColaborador().getIdentificador(), vo.getPeriodoFolha(), vo.getDataPagamento());
        if (rpaPosterior > 0L) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.013"));
        }
        return vo;
    }

    @Override
    public GeracaoReciboRpa beforeSaveEntity(GeracaoReciboRpa vo) {
        if (this.isEquals(vo.getGerarTitulo(), EnumConstantsMentorSimNao.SIM.getValue()) && this.isNull(vo.getTitulo()).booleanValue()) {
            OpcoesFinanceiras opcoesFinanceira = this.getSharedData().getOpcoesFinanceiras(vo.getEmpresa());
            if (this.isNull(opcoesFinanceira).booleanValue()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.014"));
            }
            TipoDoc tipoDocRPA = opcoesFinanceira.getTipoDocFinanceiroFolhaPagamento();
            ClassificacaoClientes classClientesRPA = opcoesFinanceira.getClassificacaoClientes();
            MeioPagamento meioPagamentoRPA = opcoesFinanceira.getMeioPagamento();
            CarteiraCobranca carteiraRPA = opcoesFinanceira.getCarteiraCobrancaTitPag();
            List<ParametrizacaoFinanceiraFolha> paramFin = this.serviceParametrizacaoFinanceiraFolhaImpl.getParamPorTipoColaboradorCentroCustoTipoFolha(vo.getColaborador().getTipoColaborador().getIdentificador(), vo.getColaborador().getCentroCusto().getIdentificador(), vo.getTipoCalculoEvento().getTipoCalculo().getIdentificador());
            if (paramFin.size() > 1) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.015", new String[]{vo.getColaborador().getCentroCusto().getNome(), vo.getColaborador().getTipoColaborador().getDescricao(), vo.getTipoCalculoEvento().getTipoCalculo().getDescricao()}));
            }
            if (this.isNull(paramFin).booleanValue() || this.isEquals(paramFin.size(), 0)) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.016", new String[]{vo.getColaborador().getCentroCusto().getNome(), vo.getColaborador().getTipoColaborador().getDescricao(), vo.getTipoCalculoEvento().getTipoCalculo().getDescricao()}));
            }
            PlanoConta planoConta = paramFin.getFirst().getPlanoContaContabil();
            PlanoContaGerencial planoContaGerencial = paramFin.getFirst().getPlanoContaGerencial();
            this.compGeracaoTitulos.gerarTitulos(vo, opcoesFinanceira, tipoDocRPA, carteiraRPA, planoConta, planoContaGerencial, classClientesRPA, meioPagamentoRPA);
        }
        return vo;
    }

    public Double getValorUtilizadoRPA(GeracaoReciboRpa geracao) {
        Double freteNFPropria = this.serviceNotaFiscalPropriaFreteCtrcImpl.getValorUtilizadoRPA(geracao);
        Double freteNFTerceiro = this.serviceNotaFiscalTerceirosFreteCtrcImp.getValorUtilizadoRPA(geracao);
        return freteNFPropria + freteNFTerceiro;
    }

    public DTOColaboradorRes buscarColaboradoresAutonomos(Long idColaborador, Empresa empresa) throws ExceptionObjNotFound {
        Colaborador colaborador = (Colaborador)this.serviceColaboradorImpl.getOrThrow(idColaborador);
        this.validColaborador(colaborador, empresa);
        return this.buildToDTOGeneric(colaborador, DTOColaboradorRes.class);
    }

    private void validColaborador(Colaborador colaborador, Empresa empresa) {
        if (!this.isEquals(colaborador.getAtivo(), EnumConstantsMentorSimNao.SIM.getValue())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.001", new String[]{colaborador.getPessoa().getNome()}));
        }
        Object[] tipoColaboradoresNecessarios = new Object[]{1L, 2L};
        if (!ToolMethods.containsInArray((Object[])tipoColaboradoresNecessarios, (Object)colaborador.getTipoColaborador().getIdentificador())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.002", new String[]{colaborador.getPessoa().getNome()}));
        }
        if (!this.isEquals(colaborador.getEmpresa(), empresa)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.003", new String[]{colaborador.getPessoa().getNome()}));
        }
    }

    public DTOGeracaoReciboRpa calcularValoresRpa(DTOGeracaoReciboRpa input, EmpresaRh empresaRh) {
        this.validCalcularValoresRpa(input, empresaRh);
        input.setPeriodoFolha(ToolDate.getDateFirstMonthDay((Date)input.getPeriodoFolha()));
        Map valoresRpaAnteriorInss = new HashMap();
        if (this.isNull(input.getIdentificador()).booleanValue()) {
            GeracaoReciboRpa ultimaGeracaoRpaColaborador = this.getUltimaGeracaoReciboRpaPorColaborador(input.getColaboradorIdentificador());
            valoresRpaAnteriorInss = this.getValoresRpaAnteriorInss(ultimaGeracaoRpaColaborador.getIdentificador(), input.getColaboradorIdentificador(), input.getPeriodoFolha(), true);
        } else {
            valoresRpaAnteriorInss = this.getValoresRpaAnteriorInss(input.getIdentificador(), input.getColaboradorIdentificador(), input.getPeriodoFolha(), false);
        }
        Map valoresRpaAnteriorIrrf = this.getValoresRpaAnteriorIrrf(this.isNotNull(input.getIdentificador()) != false ? input.getIdentificador() : 0L, input.getColaboradorIdentificador(), input.getDataPagamento());
        GeracaoReciboRpa dto = this.helperGeracaoReciboRpa.calcularValoresRpa((GeracaoReciboRpa)this.buildToEntity(input), empresaRh, valoresRpaAnteriorInss, valoresRpaAnteriorIrrf);
        return this.buildToDTOGeneric(dto, DTOGeracaoReciboRpa.class);
    }

    private void validCalcularValoresRpa(DTOGeracaoReciboRpa input, EmpresaRh empresaRh) {
        if (this.isNull(input.getColaboradorIdentificador()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.004"));
        }
        if (this.isNull(input.getPeriodoFolha()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.005"));
        }
        if (this.isNull(input.getDataPagamento()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.006"));
        }
        if (this.isNull(input.getTipoCalculoEventoIdentificador()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.007"));
        }
        Integer diferencaDias = ToolDate.daysBetweenInclusive((Date)new Date(), (Date)input.getPeriodoFolha());
        if ((long)diferencaDias.intValue() >= empresaRh.getDiasToleranciaRPA()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.008"));
        }
    }

    public Map getValoresRpaAnteriorInss(Long geracaoReciboRpa, Long colaborador, Date periodoFolha, Boolean novoRegistro) {
        return ((DaoGeracaoReciboRpaImpl)this.getGenericDao()).getValoreRpaAnteriorInss(geracaoReciboRpa, colaborador, periodoFolha, novoRegistro);
    }

    public Map getValoresRpaAnteriorIrrf(Long geracaoReciboRpa, Long colaborador, Date dataPagamento) {
        return ((DaoGeracaoReciboRpaImpl)this.getGenericDao()).getValoreRpaAnteriorIrrf(geracaoReciboRpa, colaborador, dataPagamento);
    }

    public List<DTONotaPropriaTerceiroRPA> buscarNotasRpa(Long geracaoReciboRpa) {
        List<NotaFiscalTerceiros> listNotaFiscalTerceiro = this.serviceNotaFiscalTerceirosImpl.getNotaFiscalTerceirosRPA(geracaoReciboRpa);
        List<NotaFiscalPropria> listNotaFiscalPropria = this.serviceNotaFiscalPropriaImpl.getNotaFiscalPropriaRPA(geracaoReciboRpa);
        ArrayList<DTONotaPropriaTerceiroRPA> dto = new ArrayList<DTONotaPropriaTerceiroRPA>();
        dto.addAll(listNotaFiscalTerceiro.stream().map(i -> {
            DTONotaPropriaTerceiroRPA item = new DTONotaPropriaTerceiroRPA();
            item.setTipoNota("Nota Terceiros");
            item.setNumeroNota(i.getNumeroNota());
            item.setDataMovimento(i.getDataEntrada());
            item.setPessoa(i.getUnidadeFatFornecedor().getPessoa().getNome());
            return item;
        }).collect(Collectors.toList()));
        dto.addAll(listNotaFiscalPropria.stream().map(i -> {
            DTONotaPropriaTerceiroRPA item = new DTONotaPropriaTerceiroRPA();
            item.setTipoNota("Nota Pr\u00f3pria");
            item.setNumeroNota(i.getNumeroNota());
            item.setDataMovimento(i.getDataEntradaSaida());
            item.setPessoa(i.getUnidadeFatCliente().getCliente().getPessoa().getNome());
            return item;
        }).collect(Collectors.toList()));
        return dto;
    }

    public void estornarFinanceiroRpa(Long idGeracaoReciboRpa) {
        GeracaoReciboRpa vo = (GeracaoReciboRpa)this.get(idGeracaoReciboRpa);
        if (this.isNull(vo.getTitulo()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.11446.017"));
        }
        this.serviceTituloImpl.delete(vo.getTitulo());
    }

    public void contabilizarRpa(Long dtInicial, Long dtFinal, WebDTOResult result) throws ExceptionInvalidData {
        Date dataInicial = new Date(dtInicial);
        Date dataFinal = new Date(dtFinal);
        this.validarDatas(dataInicial, dataFinal);
        List<GeracaoReciboRpa> listaRpa = this.getGeracaoReciboRpaPorPeriodoFolha(dataInicial, dataFinal);
        if (!ServiceGeracaoReciboRpaImpl.isWithData(listaRpa)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.022"));
        }
        List<GeracaoReciboRpa> dto = this.compLancamentoGeracaoReciboRpa.contabilizarRpa(listaRpa);
        this.beforeSave(dto);
        result.setMessage(MessagesBaseMentor.getMsg((String)"E.ERP.1146.027", (Object[])new Object[0]));
        result.setStatus(EnumConstantsMentorStatus.SUCESSO);
    }

    private void validarDatas(Date dataInicial, Date dataFinal) {
        if (this.isNull(dataInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.019"));
        }
        if (this.isNull(dataFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.020"));
        }
        if (dataFinal.before(dataInicial)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1146.021"));
        }
    }

    private List<GeracaoReciboRpa> getGeracaoReciboRpaPorPeriodoFolha(Date dataInicial, Date dataFinal) {
        return ((DaoGeracaoReciboRpaImpl)this.getGenericDao()).getGeracaoReciboRpaPorPeriodoFolha(dataInicial, dataFinal);
    }

    private GeracaoReciboRpa getUltimaGeracaoReciboRpaPorColaborador(Long idColaborador) {
        return ((DaoGeracaoReciboRpaImpl)this.getGenericDao()).getUltimaGeracaoReciboRpaPorColaborador(idColaborador);
    }
}

