/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaotitulosfolhapagamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstCnabPagamento;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ContaSalarioColaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.ParametrizacaoFinanceiraFolha;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.service.impl.aberturaperiodo.ServiceAberturaPeriodoImpl;
import com.touchcomp.basementorservice.service.impl.carteiracobranca.ServiceCarteiraCobrancaImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaofinanceirafolha.ServiceParametrizacaoFinanceiraFolhaImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

class AuxGeracaoTitulosFolhaPagamentoImpl {
    private final ServiceAberturaPeriodoImpl serviceAberturaPeriodoImpl;
    private final ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl;
    private final ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolhaImpl;
    private final ServiceCarteiraCobrancaImpl serviceCarteiraCobrancaImpl;
    private final CompGeracaoTitulos compGeracaoTitulos;

    protected AuxGeracaoTitulosFolhaPagamentoImpl(ServiceAberturaPeriodoImpl serviceAberturaPeriodoImpl, ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl, ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolhaImpl, ServiceCarteiraCobrancaImpl serviceCarteiraCobrancaImpl, CompGeracaoTitulos compGeracaoTitulos) {
        this.serviceAberturaPeriodoImpl = serviceAberturaPeriodoImpl;
        this.serviceMovimentoFolhaImpl = serviceMovimentoFolhaImpl;
        this.serviceParametrizacaoFinanceiraFolhaImpl = serviceParametrizacaoFinanceiraFolhaImpl;
        this.serviceCarteiraCobrancaImpl = serviceCarteiraCobrancaImpl;
        this.compGeracaoTitulos = compGeracaoTitulos;
    }

    List<Titulo> gerarTitulosFolha(Long idAbertura, Long dtPagamento, OpcoesFinanceiras opcoesFinanceiras, Empresa empresa) throws ExceptionObjNotFound {
        this.validGerarTitulosFolha(idAbertura, dtPagamento, opcoesFinanceiras);
        AberturaPeriodo aberturaPeriodo = (AberturaPeriodo)this.serviceAberturaPeriodoImpl.getOrThrow(idAbertura);
        List<MovimentoFolha> itensFolha = this.serviceMovimentoFolhaImpl.findMovimentosByAberturaPeriodo(aberturaPeriodo.getIdentificador());
        if (!BaseMethods.isWithData(itensFolha)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.003"));
        }
        List<Titulo> titulos = itensFolha.stream().map(mov -> {
            this.validValoresGeracaoTituloColaborador((MovimentoFolha)mov);
            ParametrizacaoFinanceiraFolha parametrizacao = this.findParametrizacaoFinanceiraFolha((MovimentoFolha)mov);
            CarteiraCobranca cartCobrancaDestino = this.findCarteiraCobrancaDestino((MovimentoFolha)mov);
            Titulo titulo = this.compGeracaoTitulos.gerarTitulosFolhaPagamento(parametrizacao, cartCobrancaDestino, opcoesFinanceiras, (MovimentoFolha)mov, aberturaPeriodo, empresa, new Date(dtPagamento));
            return titulo;
        }).collect(Collectors.toList());
        return titulos;
    }

    private void validGerarTitulosFolha(Long idAbertura, Long dtPagamento, OpcoesFinanceiras opcoesFinanceiras) {
        if (ToolMethods.isNull((Object)idAbertura).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.001"));
        }
        if (ToolMethods.isNull((Object)dtPagamento).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.002"));
        }
        if (ToolMethods.isNull((Object)opcoesFinanceiras).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.009"));
        }
    }

    private void validValoresGeracaoTituloColaborador(MovimentoFolha mov) {
        Double vrLiquido = 0.0;
        Double totalProventos = 0.0;
        Double totalDescontos = 0.0;
        Double vrIrrf = 0.0;
        Double vrInss = 0.0;
        Double totalCalculo = 0.0;
        vrLiquido = mov.getVrSalarioLiquido();
        vrIrrf = mov.getVrIrrf13Sal() + mov.getVrIrrfFerias() + mov.getVrIrrfSalario();
        vrInss = mov.getVrInss13Sal() + mov.getVrInssFerias() + mov.getVrInssSalario();
        for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
            if (ToolMethods.isEquals((Object)item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo(), (Object)"1")) {
                totalProventos = totalProventos + item.getValor();
                continue;
            }
            if (!ToolMethods.isEquals((Object)item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo(), (Object)"2")) continue;
            totalDescontos = totalDescontos + item.getValor();
        }
        totalCalculo = ToolNumber.arredondarNumero((Double)(totalProventos - (totalDescontos + vrIrrf + vrInss)), (Integer)2, (Integer)0);
        if (!ToolMethods.isEquals((Object)vrLiquido, (Object)totalCalculo)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.004", new String[]{mov.getColaborador().toString(), mov.getIdentificador().toString()}));
        }
    }

    private ParametrizacaoFinanceiraFolha findParametrizacaoFinanceiraFolha(MovimentoFolha mov) {
        List<ParametrizacaoFinanceiraFolha> paramFin = this.serviceParametrizacaoFinanceiraFolhaImpl.getParamPorTipoColaboradorCentroCustoTipoFolha(mov.getColaborador().getTipoColaborador().getIdentificador(), mov.getColaborador().getCentroCusto().getIdentificador(), mov.getAberturaPeriodo().getTipoCalculo().getIdentificador());
        if (ToolMethods.isNull(paramFin).booleanValue() || ToolMethods.isEquals((Object)paramFin.size(), (Object)0)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.005", new String[]{mov.getColaborador().getCentroCusto().getCodigo(), mov.getColaborador().getTipoColaborador().getDescricao(), mov.getAberturaPeriodo().getTipoCalculo().getDescricao()}));
        }
        if (paramFin.size() > 1) {
            String idParam = paramFin.stream().map(i -> i.getIdentificador().toString()).collect(Collectors.joining(","));
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.006", new String[]{mov.getColaborador().getCentroCusto().getNome(), mov.getColaborador().getTipoColaborador().getDescricao(), mov.getAberturaPeriodo().getTipoCalculo().getDescricao(), idParam}));
        }
        if (ToolMethods.isNull((Object)paramFin.getFirst().getPlanoContaContabil()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.007", new Object[]{paramFin.getFirst().getIdentificador()}));
        }
        if (ToolMethods.isNull((Object)paramFin.getFirst().getPlanoContaGerencial()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1260.008", new Object[]{paramFin.getFirst().getIdentificador()}));
        }
        return paramFin.getFirst();
    }

    private CarteiraCobranca findCarteiraCobrancaDestino(MovimentoFolha mov) {
        ContaSalarioColaborador contaColaborador = mov.getColaborador().getPessoa().getContaSalarioColaborador().stream().filter(i -> ToolMethods.isEquals((Object)i.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)i.getPreferencial(), (Object)EnumConstantsMentorSimNao.SIM.getValue())).findFirst().orElse(null);
        if (ToolMethods.isNull((Object)contaColaborador).booleanValue() || ToolMethods.isNull((Object)contaColaborador.getAtivo()).booleanValue() || !ToolMethods.isEquals((Object)contaColaborador.getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) || ToolMethods.isEquals((Object)mov.getColaborador().getTipoPagamento(), (Object)EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId())) {
            return null;
        }
        return this.serviceCarteiraCobrancaImpl.findCarteiraCobrancaByColaborador(contaColaborador.getInstituicaoValor().getIdentificador(), mov.getColaborador().getEmpresa().getIdentificador());
    }
}

