/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.geracaotitulosfolhapagamento;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoTitulosFolhaPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoGeracaoTitulosFolhaPagamentoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.aberturaperiodo.ServiceAberturaPeriodoImpl;
import com.touchcomp.basementorservice.service.impl.carteiracobranca.ServiceCarteiraCobrancaImpl;
import com.touchcomp.basementorservice.service.impl.geracaotitulosfolhapagamento.AuxGeracaoTitulosFolhaPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaofinanceirafolha.ServiceParametrizacaoFinanceiraFolhaImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.touchvomodel.vo.titulo.web.DTOTitulo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGeracaoTitulosFolhaPagamentoImpl
extends ServiceGenericEntityImpl<GeracaoTitulosFolhaPagamento, Long, DaoGeracaoTitulosFolhaPagamentoImpl> {
    ServiceAberturaPeriodoImpl serviceAberturaPeriodoImpl;
    ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl;
    ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolhaImpl;
    ServiceCarteiraCobrancaImpl serviceCarteiraCobrancaImpl;
    CompGeracaoTitulos compGeracaoTitulos;

    @Autowired
    public ServiceGeracaoTitulosFolhaPagamentoImpl(DaoGeracaoTitulosFolhaPagamentoImpl dao, ServiceAberturaPeriodoImpl serviceAberturaPeriodoImpl, ServiceMovimentoFolhaImpl serviceMovimentoFolhaImpl, ServiceParametrizacaoFinanceiraFolhaImpl serviceParametrizacaoFinanceiraFolhaImpl, ServiceCarteiraCobrancaImpl serviceCarteiraCobrancaImpl, CompGeracaoTitulos compGeracaoTitulos, ServiceTituloImpl serviceTituloImpl) {
        super(dao);
        this.serviceAberturaPeriodoImpl = serviceAberturaPeriodoImpl;
        this.serviceMovimentoFolhaImpl = serviceMovimentoFolhaImpl;
        this.serviceParametrizacaoFinanceiraFolhaImpl = serviceParametrizacaoFinanceiraFolhaImpl;
        this.serviceCarteiraCobrancaImpl = serviceCarteiraCobrancaImpl;
        this.compGeracaoTitulos = compGeracaoTitulos;
    }

    @Override
    public GeracaoTitulosFolhaPagamento beforeSaveEntity(GeracaoTitulosFolhaPagamento vo) {
        vo.getTitulos().forEach(i -> i.setTitulosFolha(vo));
        return vo;
    }

    @Override
    public GeracaoTitulosFolhaPagamento afterSaveEntity(GeracaoTitulosFolhaPagamento vo) {
        vo.getTitulos().forEach(titulo -> titulo.getLancCtbGerencial().forEach(lanc -> {
            String obs = "Titulo: " + titulo.getIdentificador().toString() + " - " + lanc.getHistorico();
            lanc.setHistorico(obs);
        }));
        return vo;
    }

    public List<DTOTitulo> gerarTitulosFolha(Long idAbertura, Long dtPagamento, OpcoesFinanceiras opcoesFinanceiras, Empresa empresa) throws ExceptionObjNotFound {
        List<Titulo> titulos = new AuxGeracaoTitulosFolhaPagamentoImpl(this.serviceAberturaPeriodoImpl, this.serviceMovimentoFolhaImpl, this.serviceParametrizacaoFinanceiraFolhaImpl, this.serviceCarteiraCobrancaImpl, this.compGeracaoTitulos).gerarTitulosFolha(idAbertura, dtPagamento, opcoesFinanceiras, empresa);
        return this.buildToDTOGeneric(titulos, DTOTitulo.class);
    }
}

