/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.gradecor;

import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoGradeCorImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceGradeCor;
import com.touchcomp.touchvomodel.res.DTOGradeCorRes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGradeCorImpl
extends ServiceGenericEntityImpl<GradeCor, Long, DaoGradeCorImpl>
implements ServiceGradeCor {
    @Autowired
    public ServiceGradeCorImpl(DaoGradeCorImpl genericDao) {
        super(genericDao);
    }

    @Override
    public List<GradeCor> get(Produto produto) {
        return ((DaoGradeCorImpl)this.getGenericDao()).get(produto);
    }

    @Override
    public GradeCor getByCodigoBarras(String codigo) {
        return ((DaoGradeCorImpl)this.getGenericDao()).getByCodigoBarras(codigo);
    }

    public GradeCor getFirstGradeCor(Produto produto) {
        if (produto == null) {
            return null;
        }
        return ((DaoGradeCorImpl)this.getDao()).getFirstGradeCor(produto);
    }

    public GradeCor getGradeCorProdutoNome(Produto produto, String gradeCor) {
        return ((DaoGradeCorImpl)this.getDao()).getGradeCorProdutoNome(produto, gradeCor);
    }

    public List<GradeCor> getByIdProduto(Long idProduto) {
        return ((DaoGradeCorImpl)this.getDao()).getByIdProduto(idProduto);
    }

    public List<GradeCor> getByCodAuxProduto(String codigoAuxiliar) {
        return ((DaoGradeCorImpl)this.getDao()).getByCodAuxProduto(codigoAuxiliar);
    }

    public List<DTOGradeCorRes> getGrades(Long idProduto, String strTyped, boolean useIlike) {
        return ((DaoGradeCorImpl)this.getDao()).getGrades(idProduto, strTyped, useIlike);
    }

    public GradeCor getGradePrincipalbyProduto(Produto produto) {
        return ((DaoGradeCorImpl)this.getDao()).getGradePrincipalbyProduto(produto);
    }

    public List<?> getByIdProduto(Long idProduto, Class<?> aClass) {
        List<GradeCor> grades = this.getByIdProduto(idProduto);
        return this.buildToDTO(grades, aClass);
    }

    public GradeCor getFirstByCodAuxProduto(String codAuxProd) {
        return ((DaoGradeCorImpl)this.getDao()).getFirstByCodAuxProduto(codAuxProd);
    }

    public GradeCor getFirstByCodigoBarrasProduto(String codBarrasProd) {
        return ((DaoGradeCorImpl)this.getDao()).getFirstByCodigoBarrasProduto(codBarrasProd);
    }

    public GradeCor getFirtByIdProduto(Long idProd) {
        return ((DaoGradeCorImpl)this.getDao()).getFirtByIdProduto(idProd);
    }

    public List<GradeCor> findGradeItemPedidoByProdutoExcAll(Produto produto, List<GradeItemPedido> grades) {
        return ((DaoGradeCorImpl)this.getDao()).findGradeItemPedidoByProdutoExcAll(produto, grades);
    }

    public List<GradeCor> getGradesAtivasByProduto(Long produto) {
        if (produto == null) {
            return new ArrayList<GradeCor>();
        }
        return ((DaoGradeCorImpl)this.getDao()).getGradesAtivasByProduto(produto);
    }

    public GradeCor getGradeSeProdutoAtivo(Long identificador) throws ExceptionInvalidData {
        GradeCor vo = ((DaoGradeCorImpl)this.getGenericDao()).getGradeSeProdutoAtivo(identificador);
        if (vo == null) {
            throw new ExceptionInvalidData("E.ERP.0064.004", new Object[]{identificador});
        }
        return vo;
    }

    public List<GradeCor> getByIdProdutoAtivo(Long idProduto) {
        return ((DaoGradeCorImpl)this.getDao()).getByIdProdutoAtivo(idProduto);
    }

    public List<GradeCor> getByCodAuxProdutoAtivo(String codAux) {
        return ((DaoGradeCorImpl)this.getDao()).getByCodAuxProdutoAtivo(codAux);
    }

    public Map<String, Object> getMapDadosBaseGradeCor(GradeCor grade) {
        return ((DaoGradeCorImpl)this.getGenericDao()).getMapDadosBaseGradeCor(grade);
    }
}

