/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.gradeformulaproduto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEnc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProduto;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.ServiceAnalisePrVendaProdImpl;
import com.touchcomp.basementorservice.service.impl.gradeformulaproduto.ServiceGradeFormulaProdutoImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompGradeFormulaProduto
extends ServiceGenericImpl {
    private final ServiceAnalisePrVendaProdImpl serviceAnalisePrVendaProd;

    public GradeFormulaProduto criarRoteiroProducao(AnalisePrVendaProd analisePrecoVenda, GradeCor grade, OpcoesPCP opcoesPCP, Empresa empresa) {
        ArrayList<GradeFormulaProduto> listGradeFormulaProduto = new ArrayList<GradeFormulaProduto>();
        for (AnalisePrVendaProdCelEnc al : analisePrecoVenda.getAnalisePrVendaPCPEnc().getItensCelulaAnalPreco()) {
            GradeCor gradecor;
            if (!this.isNull(al.getFormulacaoProduto()).booleanValue() || !this.isNull(al.getRoteiroProducao()).booleanValue()) continue;
            GradeCor gradeCor = gradecor = this.isNotNull(al.getProdutoIntermediario()) != false ? al.getProdutoIntermediario() : grade;
            if (this.verificarExisteGradeCorGradeFormulaProduto(listGradeFormulaProduto, gradecor)) {
                this.criarGradeFormulaProduto(listGradeFormulaProduto, al, gradecor, opcoesPCP, empresa);
                continue;
            }
            this.atualizarGradeFormulaProduto(listGradeFormulaProduto, al, gradecor, opcoesPCP);
        }
        AnalisePrVendaProd analisePrVendaProd = this.serviceAnalisePrVendaProd.saveOrUpdate(analisePrecoVenda);
        return this.setarGradeFormulaProduto(analisePrVendaProd, grade);
    }

    private void criarGradeFormulaProduto(List<GradeFormulaProduto> listGradeFormulaProduto, AnalisePrVendaProdCelEnc al, GradeCor gradeCor, OpcoesPCP opcoesPCP, Empresa empresa) {
        GradeFormulaProduto grade = this.getBean(ServiceGradeFormulaProdutoImpl.class).findMelhorGradeFormulaProduto(gradeCor);
        GradeFormulaProduto gradeFormulaProduto = new GradeFormulaProduto();
        gradeFormulaProduto.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        gradeFormulaProduto.setDataCadastro(new Date());
        gradeFormulaProduto.setEmpresa(empresa);
        gradeFormulaProduto.setFormulacaoPrincipal(Short.valueOf(grade != null ? EnumConstantsMentorSimNao.NAO.getValue() : EnumConstantsMentorSimNao.SIM.getValue()));
        gradeFormulaProduto.setRevisao((String)(grade != null ? grade.getRevisao() + "1" : "1"));
        gradeFormulaProduto.setGradeCor(gradeCor);
        gradeFormulaProduto.setDescricao(gradeFormulaProduto.getGradeCor().getProdutoGrade().getProduto().getNome());
        gradeFormulaProduto.setQuantidadeReferenciaProd(Double.valueOf(0.0));
        gradeFormulaProduto.getItemGradeFormulaProduto().addAll(this.criarItemGradeFormulaProduto(al, gradeFormulaProduto, opcoesPCP));
        al.setFormulacaoProduto(gradeFormulaProduto);
        listGradeFormulaProduto.add(gradeFormulaProduto);
    }

    private List<ItemGradeFormulaProduto> criarItemGradeFormulaProduto(AnalisePrVendaProdCelEnc al, GradeFormulaProduto gradeFormulaProduto, OpcoesPCP opcoesPCP) {
        Integer indice = gradeFormulaProduto.getItemGradeFormulaProduto().size() + 1;
        ArrayList<ItemGradeFormulaProduto> listItemGradeFormulaProduto = new ArrayList<ItemGradeFormulaProduto>();
        for (AnalisePrVendaProdCelMatEnc mat : al.getItemMatCelulas()) {
            ItemGradeFormulaProduto itemGradeFormulaProduto = new ItemGradeFormulaProduto();
            itemGradeFormulaProduto.setGradeFormulaProduto(gradeFormulaProduto);
            itemGradeFormulaProduto.setGradeCor(mat.getGradeCor());
            itemGradeFormulaProduto.setQuantidade(mat.getQuantidade());
            itemGradeFormulaProduto.setNaturezaRequisicao(opcoesPCP.getNaturezaRequisicao());
            itemGradeFormulaProduto.setNaoRequisitarAutomatico(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            itemGradeFormulaProduto.setQtdReferencia(mat.getQuantidadeRef());
            itemGradeFormulaProduto.setPercAdicional(Double.valueOf(0.0));
            itemGradeFormulaProduto.setIndice(Short.valueOf(indice.shortValue()));
            itemGradeFormulaProduto.setComprimento(mat.getComprimento());
            itemGradeFormulaProduto.setAltura(mat.getAltura());
            itemGradeFormulaProduto.setLargura(mat.getLargura());
            itemGradeFormulaProduto.setVolume(mat.getVolume());
            itemGradeFormulaProduto.setNaoUtilizarPesagem(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            listItemGradeFormulaProduto.add(itemGradeFormulaProduto);
            Integer n = indice;
            indice = indice + 1;
        }
        return listItemGradeFormulaProduto;
    }

    private boolean verificarExisteGradeCorGradeFormulaProduto(List<GradeFormulaProduto> listGradeFormulaProduto, GradeCor gradecor) {
        return listGradeFormulaProduto.stream().noneMatch(gradeFormulaProduto -> this.isEquals(gradeFormulaProduto.getGradeCor(), gradecor));
    }

    private void atualizarGradeFormulaProduto(List<GradeFormulaProduto> listGradeFormulaProduto, AnalisePrVendaProdCelEnc al, GradeCor gradeCor, OpcoesPCP opcoesPCP) {
        listGradeFormulaProduto.stream().filter(gradeFormulaProduto -> this.isEquals(gradeFormulaProduto.getGradeCor(), gradeCor)).findFirst().ifPresent(gradeFormulaProduto -> {
            gradeFormulaProduto.getItemGradeFormulaProduto().addAll(this.criarItemGradeFormulaProduto(al, (GradeFormulaProduto)gradeFormulaProduto, opcoesPCP));
            al.setFormulacaoProduto(gradeFormulaProduto);
        });
    }

    private GradeFormulaProduto setarGradeFormulaProduto(AnalisePrVendaProd analisePrVendaProd, GradeCor grade) {
        return analisePrVendaProd.getAnalisePrVendaPCPEnc().getItensCelulaAnalPreco().stream().filter(al -> this.isEquals(al.getFormulacaoProduto().getGradeCor(), grade)).map(AnalisePrVendaProdCelEnc::getFormulacaoProduto).findFirst().orElse(null);
    }

    @Generated
    public SCompGradeFormulaProduto(ServiceAnalisePrVendaProdImpl serviceAnalisePrVendaProd) {
        this.serviceAnalisePrVendaProd = serviceAnalisePrVendaProd;
    }
}

