/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.gradeformulaproduto;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.VOEngenhariaProdutos;
import com.touchcomp.basementor.model.vo.AlteracaoFormulacaoProduto;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.ItemGradeFormulaProdutoSubstituto;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidStateRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.dao.impl.DaoGradeFormulaProdutoImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.gradeformulaproduto.SCompGradeFormulaProduto;
import com.touchcomp.basementorservice.service.impl.opcoespcp.ServiceOpcoesPCPImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceGradeFormulaProduto;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGradeFormulaProdutoImpl
extends ServiceGenericEntityImpl<GradeFormulaProduto, Long, DaoGradeFormulaProdutoImpl>
implements ServiceGradeFormulaProduto {
    SCompGradeFormulaProduto sCompGradeFormulaProduto;
    ServiceOpcoesPCPImpl serviceOpcoesPCP;
    ServiceEmpresaImpl serviceEmpresa;
    HelperOpcoesPCP helperOpcoesPCP;

    @Autowired
    public ServiceGradeFormulaProdutoImpl(DaoGradeFormulaProdutoImpl genericDao, SCompGradeFormulaProduto sCompGradeFormulaProduto, ServiceOpcoesPCPImpl serviceOpcoesPCP, ServiceEmpresaImpl serviceEmpresa, HelperOpcoesPCP helperOpcoesPCP) {
        super(genericDao);
        this.sCompGradeFormulaProduto = sCompGradeFormulaProduto;
        this.serviceOpcoesPCP = serviceOpcoesPCP;
        this.serviceEmpresa = serviceEmpresa;
        this.helperOpcoesPCP = helperOpcoesPCP;
    }

    @Override
    public List<VOEngenhariaProdutos> getFormulacoesByGrupoProdutosEngProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getFormulacoesByGrupoProdutosEngProd(idInicial, idFinal, filtraEspecie, idInicialEspecie, idFinalEspecie, filtraSubEspecie, idInicialSubEspecie, idFinalSubEspecie, somenteFormAtivas);
    }

    @Override
    public List<VOEngenhariaProdutos> getFormulacoesEngProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getFormulacoesEngProd(idInicial, idFinal, filtraEspecie, idInicialEspecie, idFinalEspecie, filtraSubEspecie, idInicialSubEspecie, idFinalSubEspecie, somenteFormAtivas);
    }

    @Override
    public List<VOEngenhariaProdutos> getFormulacoesByProdutoEngProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getFormulacoesByProdutoEngProd(idInicial, idFinal, filtraEspecie, idInicialEspecie, idFinalEspecie, filtraSubEspecie, idInicialSubEspecie, idFinalSubEspecie, somenteFormAtivas);
    }

    @Override
    public List<VOEngenhariaProdutos> getItensFormulacaoEngProd(Long idFormulacao) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getItensFormulacaoEngProd(idFormulacao);
    }

    @Override
    public Long getPrimeiroIdGradeFormulaProdutoAtiva(Long idGradeCor, EnumConstantsMentorSimNao somenteFormAtivas) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getPrimeiroIdGradeFormulaProdutoAtivaEngProd(idGradeCor, somenteFormAtivas);
    }

    @Override
    public List<VOEngenhariaProdutos> getFormulacoesEngProdPrincProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getFormulacoesEngProdPrincProd(idInicial, idFinal, filtraEspecie, idInicialEspecie, idFinalEspecie, filtraSubEspecie, idInicialSubEspecie, idFinalSubEspecie, somenteFormAtivas);
    }

    @Override
    public GradeFormulaProduto get(TipoProducaoSped tipoProducaoSped, GradeCor gradeCor) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).get(tipoProducaoSped, gradeCor);
    }

    public List<GradeFormulaProduto> getFormulacoesAltCriadas(Date dataAlteracao, Long idGrupo) {
        return ((DaoGradeFormulaProdutoImpl)this.getDao()).getFormulacoesAltCriadas(dataAlteracao, idGrupo);
    }

    public GradeFormulaProduto findMelhorGradeFormulaProduto(GradeCor gradeCor) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).findMelhorGradeFormulaProduto(gradeCor);
    }

    public GradeFormulaProduto getByCodProdRevisao(String codigoAuxiliar, String revisao) {
        if (!TMethods.isStrWithData((String)revisao)) {
            revisao = null;
        }
        return ((DaoGradeFormulaProdutoImpl)this.getDao()).getByCodProdRevisao(codigoAuxiliar, revisao);
    }

    @Override
    public GradeFormulaProduto beforeSave(GradeFormulaProduto entity) {
        return this.beforeSaveEntity(entity);
    }

    @Override
    public GradeFormulaProduto beforeSaveEntity(GradeFormulaProduto entity) {
        GradeFormulaProduto grade;
        if (this.isEquals(entity.getFormulacaoPrincipal(), EnumConstantsMentorSimNao.SIM.getValue()) && (grade = ((DaoGradeFormulaProdutoImpl)this.getDao()).getFormulacaoPrincipal(entity.getGradeCor(), entity.getIdentificador())) != null) {
            throw new ExceptionInvalidStateRuntime(new ExcepCodeDetail("E.ERP.0425.001", new Object[]{grade}));
        }
        if (this.isStrWithData(entity.getRevisao()) && (grade = ((DaoGradeFormulaProdutoImpl)this.getDao()).getByGradeCorRevisao(entity.getGradeCor(), entity.getRevisao(), entity.getIdentificador())) != null) {
            throw new ExceptionInvalidStateRuntime(new ExcepCodeDetail("E.ERP.0425.005", new Object[]{grade}));
        }
        entity.getFichasTecnicas().forEach(i -> i.setGradeFormulaProduto(entity));
        entity.getGradeFormProdTpSpedProd().forEach(i -> i.setGradeFormulaProduto(entity));
        entity.getItemGradeFormulaProduto().forEach(i -> {
            i.setGradeFormulaProduto(entity);
            if (TMethods.isWithData((Number)i.getAltura()) && TMethods.isWithData((Number)i.getComprimento()) && TMethods.isWithData((Number)i.getLargura())) {
                i.setVolume(Double.valueOf(i.getAltura() * i.getComprimento() * i.getLargura()));
            }
            if (i.getItensSubstitutos() != null) {
                short indice = 0;
                if (i.getItensSubstitutos() != null) {
                    for (ItemGradeFormulaProdutoSubstituto k : i.getItensSubstitutos()) {
                        k.setItemGradeFormulaProduto(i);
                        k.setIndice(Short.valueOf(indice));
                        indice = (short)(indice + 1);
                    }
                }
            }
        });
        entity.getItemPerda().forEach(i -> i.setGradeFormulaProduto(entity));
        entity.getItemSobra().forEach(i -> i.setGradeFormulaProduto(entity));
        entity.getAlteracoesFormulacao().forEach(i -> i.setGradeFormulaProduto(entity));
        return entity;
    }

    public GradeFormulaProduto getByCodProdRevisao(Long idProduto, String revisao) {
        if (!TMethods.isStrWithData((String)revisao)) {
            revisao = null;
        }
        return ((DaoGradeFormulaProdutoImpl)this.getDao()).getByCodProdRevisao(idProduto, revisao);
    }

    public GradeFormulaProduto getByIdGradeCorRevisao(Long idGradeCor, String revisao) {
        if (!TMethods.isStrWithData((String)revisao)) {
            revisao = null;
        }
        return ((DaoGradeFormulaProdutoImpl)this.getDao()).getByIdGradeCorRevisao(idGradeCor, revisao);
    }

    public AlteracaoFormulacaoProduto save(AlteracaoFormulacaoProduto al) {
        if (al == null) {
            return al;
        }
        if (!al.getStatusAnterior().equals(al.getGradeFormulaProduto().getAtivo())) {
            al.getGradeFormulaProduto().getAlteracoesFormulacao().add(al);
            al.setDataModificacao(new Timestamp(new Date().getTime()));
            this.saveOrUpdate(al.getGradeFormulaProduto());
        }
        return al;
    }

    public void inativarFormulacoesDifRevisao(GradeCor gradeCorProdForm, String revisao, TipoProducaoSped tipoProducao) {
        GradeFormulaProduto grade = null;
        grade = ((DaoGradeFormulaProdutoImpl)this.getDao()).get(tipoProducao, gradeCorProdForm);
        if (grade != null && !TMethods.isEquals((Object)grade.getRevisao(), (Object)revisao)) {
            grade.setAtivo(Short.valueOf((short)0));
            grade.setDataVigFinal(new Date());
            this.saveOrUpdate(grade);
        }
    }

    public GradeFormulaProduto getFormulacaoPrincipal(Long idGradeFormula) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getFormulacaoPrincipal(idGradeFormula);
    }

    public List<GradeFormulaProduto> getGradesFormulas(Long gradeCor) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getGradesFormulas(gradeCor);
    }

    public List<GradeFormulaProduto> getGradesFormulasAtivos(Long gradeCor) {
        return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getGradesFormulas(gradeCor, EnumConstantsMentorSimNao.SIM);
    }

    public GradeFormulaProduto criarGradeFormulaProduto(AnalisePrVendaProd analisePrecoVenda, GradeCor grade, Short expMelhorRotForm, CapsEmpresa capsEmpresa) {
        OpcoesPCP opcoesPCP = this.serviceOpcoesPCP.getByIdEmpresa(capsEmpresa.get());
        Empresa empresa = (Empresa)this.serviceEmpresa.get(capsEmpresa.get());
        Short rotProducaoFormProdutosPlanProd = (Short)CompOpcoes.getOption(this.helperOpcoesPCP.build(opcoesPCP).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.ROT_PRODUCAO_FORM_PRODUTOS_PLAN_PROD, Short.class);
        if (this.isEquals(rotProducaoFormProdutosPlanProd, EnumConstantsMentorSimNao.SIM.getValue()) && this.isNotNull(analisePrecoVenda).booleanValue()) {
            return this.sCompGradeFormulaProduto.criarRoteiroProducao(analisePrecoVenda, grade, opcoesPCP, empresa);
        }
        if (this.isEquals(expMelhorRotForm, EnumConstantsMentorSimNao.SIM.getValue())) {
            return ((DaoGradeFormulaProdutoImpl)this.getGenericDao()).getFormulacaoPrincipal(grade, null);
        }
        return null;
    }
}

