/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupocompensacao;

import com.touchcomp.basementor.constants.enums.tipocompesacaocheque.EnumConstTipoCompesacaoCheque;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.CompensacaoCheque;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.GrupoCompensacao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.bderrors.CompBDErrors;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.compensacaochequeproprio.CompCompensacaoChequeProprio;
import com.touchcomp.basementorservice.components.movimentobancario.CompMovimentoBancario;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoCompensacao;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cheque.ServiceChequeImpl;
import com.touchcomp.basementorservice.service.impl.contavalores.ServiceContaValoresImpl;
import com.touchcomp.basementorservice.service.impl.movimentobancario.ServiceMovimentoBancarioImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.compensacaocheque.web.DTOCompensacaoCheque;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoCompensacaoImpl
extends ServiceGenericEntityImpl<GrupoCompensacao, Long, DaoGrupoCompensacao> {
    ServiceContaValoresImpl serviceContaValoresImpl;
    ServiceChequeImpl serviceChequeImpl;
    ServiceMovimentoBancarioImpl serviceMovimentoBancarioImpl;
    CompCompensacaoChequeProprio compCompensacaoChequeProprio;
    CompMovimentoBancario compMovimentoBancario;

    public ServiceGrupoCompensacaoImpl(DaoGrupoCompensacao dao, ServiceChequeImpl serviceChequeImpl, ServiceContaValoresImpl serviceContaValoresImpl, ServiceMovimentoBancarioImpl serviceMovimentoBancarioImpl, CompCompensacaoChequeProprio compCompensacaoChequeProprio, CompMovimentoBancario compMovimentoBancario) {
        super(dao);
        this.serviceContaValoresImpl = serviceContaValoresImpl;
        this.serviceChequeImpl = serviceChequeImpl;
        this.serviceMovimentoBancarioImpl = serviceMovimentoBancarioImpl;
        this.compCompensacaoChequeProprio = compCompensacaoChequeProprio;
        this.compMovimentoBancario = compMovimentoBancario;
    }

    @Override
    public GrupoCompensacao beforeSaveEntity(GrupoCompensacao aux) {
        try {
            aux.getCompensacaoCheques().forEach(i -> i.setGrupoCompensacao(aux));
            if (this.isNotNull(aux.getHistorico()).booleanValue() && this.isNull(aux.getDescricaoHistorico()).booleanValue()) {
                aux.setDescricaoHistorico(aux.getHistorico().getDescricao());
            }
            if (this.isNotNull(this.getSharedData().getOpcoesContabeis(aux.getEmpresa())).booleanValue()) {
                PlanoConta pcPrescricao = this.getSharedData().getOpcoesContabeis(aux.getEmpresa()).getContaPrescricaoCheque();
                this.compCompensacaoChequeProprio.criaLoteContabil(aux, pcPrescricao);
                this.compMovimentoBancario.newMovimentoBancario(aux, pcPrescricao, aux.getContaValor());
            }
            for (CompensacaoCheque compensacao : aux.getCompensacaoCheques()) {
                if (this.isEquals(compensacao.getTipoCompensacao(), EnumConstTipoCompesacaoCheque.NORMAL.getValue())) {
                    this.serviceMovimentoBancarioImpl.updateMovimentoBancario(compensacao, false);
                    continue;
                }
                if (!this.isEquals(compensacao.getTipoCompensacao(), EnumConstTipoCompesacaoCheque.NAO_COMPENSADO.getValue())) continue;
                this.serviceMovimentoBancarioImpl.updateMovimentoBancario(compensacao, true);
            }
            aux.getCompensacaoCheques().removeIf(i -> TMethods.isEquals((Object)i.getTipoCompensacao(), (Object)EnumConstTipoCompesacaoCheque.NAO_COMPENSADO.getValue()));
            return aux;
        }
        catch (ExceptionInvalidData ex) {
            throw new ExceptionRuntimeBase(ex.getFormattedMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ExceptionRuntimeBase(CompBDErrors.getProcessedMessage(ex), (Throwable)ex);
        }
    }

    @Override
    public GrupoCompensacao beforeDeleteEntity(GrupoCompensacao aux) {
        for (CompensacaoCheque compensacao : aux.getCompensacaoCheques()) {
            this.serviceMovimentoBancarioImpl.updateMovimentoBancario(compensacao, true);
        }
        return aux;
    }

    public List<DTOCompensacaoCheque> filtrarCheques(Long dtInicial, Long dtFinal, Long idConta) throws ExceptionObjNotFound {
        Date dataInicial = new Date(dtInicial);
        Date dataFinal = new Date(dtFinal);
        this.isValidBeforeFind(dataInicial, dataFinal, idConta);
        ContaValores contaValor = (ContaValores)this.serviceContaValoresImpl.getOrThrow(idConta);
        List<Cheque> listaCheques = this.serviceChequeImpl.getChequeDataEmissaoPorConta(contaValor, dataInicial, dataFinal);
        ArrayList<CompensacaoCheque> compensacoes = new ArrayList<CompensacaoCheque>();
        if (ServiceGrupoCompensacaoImpl.isWithData(listaCheques)) {
            for (Cheque cheque : listaCheques) {
                CompensacaoCheque compensacaoCheque = new CompensacaoCheque();
                compensacaoCheque.setCheque(cheque);
                compensacoes.add(compensacaoCheque);
            }
        } else {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0326.005"));
        }
        return this.buildToDTOGeneric(compensacoes, DTOCompensacaoCheque.class);
    }

    private void isValidBeforeFind(Date dataInicial, Date dataFinal, Long idConta) {
        if (this.isNull(dataInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0326.001", new Object[]{dataInicial}));
        }
        if (this.isNull(dataFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0326.002", new Object[]{dataFinal}));
        }
        if (dataInicial.after(dataFinal)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0326.003", new Object[]{dataFinal}));
        }
        if (this.isNull(idConta).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0326.004", new Object[]{dataFinal}));
        }
    }

    public WebDTOResult getCheque(Long[] ids) {
        WebDTOResult res = new WebDTOResult();
        List cheques = this.serviceChequeImpl.gets(ids);
        ArrayList listCompensacao = new ArrayList();
        cheques.forEach(i -> {
            if (this.isNull(i.getCompensacaoCheque()).booleanValue()) {
                CompensacaoCheque compensacao = new CompensacaoCheque();
                compensacao.setCheque(i);
                listCompensacao.add(compensacao);
            }
        });
        if (cheques.size() != listCompensacao.size()) {
            res.setMessage(MessagesBaseMentor.getMsg((String)"M.ERP.0326.002", (Object[])new Object[0]));
        }
        res.setResult(this.buildToDTOGeneric(listCompensacao, DTOCompensacaoCheque.class));
        return res;
    }
}

