/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupocompensacaoterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.borderochequesterceiros.EnumConstChequeTerceiros;
import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.CompensacaoChequeTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoCompensacaoTerceiros;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.titulos.impl.CompGeraTituloChequeTerceiros;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoCompensacaoTerceirosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.borderochequeterceirosmovbancario.ServiceBorderoChequeTerceirosMovBancarioImpl;
import com.touchcomp.basementorservice.service.impl.chequeterceiros.ServiceChequeTerceirosImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.compensacaochequeterceiros.web.DTOCompensacaoChequeTerceiros;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoCompensacaoTerceirosImpl
extends ServiceGenericEntityImpl<GrupoCompensacaoTerceiros, Long, DaoGrupoCompensacaoTerceirosImpl> {
    ServiceChequeTerceirosImpl serviceChequeTerceirosImpl;
    ServiceBorderoChequeTerceirosMovBancarioImpl serviceBorderoChequeTerceirosMovBancarioImpl;
    CompGeraTituloChequeTerceiros compGeraTituloChequeTerceiros;

    @Autowired
    public ServiceGrupoCompensacaoTerceirosImpl(DaoGrupoCompensacaoTerceirosImpl dao, ServiceChequeTerceirosImpl serviceChequeTerceirosImpl, ServiceBorderoChequeTerceirosMovBancarioImpl serviceBorderoChequeTerceirosMovBancarioImpl, CompGeraTituloChequeTerceiros compGeraTituloChequeTerceiros) {
        super(dao);
        this.serviceChequeTerceirosImpl = serviceChequeTerceirosImpl;
        this.serviceBorderoChequeTerceirosMovBancarioImpl = serviceBorderoChequeTerceirosMovBancarioImpl;
        this.compGeraTituloChequeTerceiros = compGeraTituloChequeTerceiros;
    }

    public List<DTOCompensacaoChequeTerceiros> getFiltrarCheques(Long dtInicial, Long dtFinal, GrupoEmpresa grupoEmpresa, Empresa empresa, Short visualizarSaldosMovFinancOutEmp) {
        Date dataInicial = new Date(dtInicial);
        Date dataFinal = new Date(dtFinal);
        this.isValidDate(dataInicial, dataFinal);
        List<ChequeTerceiros> chequesTerceiros = this.serviceChequeTerceirosImpl.getChequesTerceirosByDataVencimento(dataInicial, dataFinal, grupoEmpresa, empresa, visualizarSaldosMovFinancOutEmp);
        if (!ServiceGrupoCompensacaoTerceirosImpl.isWithData(chequesTerceiros)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0331.004", new Object[]{chequesTerceiros}));
        }
        ArrayList<CompensacaoChequeTerceiros> compensacoes = new ArrayList<CompensacaoChequeTerceiros>();
        for (ChequeTerceiros cheque : chequesTerceiros) {
            CompensacaoChequeTerceiros compensacao = new CompensacaoChequeTerceiros();
            compensacao.setCheque(cheque);
            compensacoes.add(compensacao);
        }
        return this.buildToDTOGeneric(compensacoes, DTOCompensacaoChequeTerceiros.class);
    }

    private void isValidDate(Date dataInicial, Date dataFinal) {
        if (this.isNull(dataInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0331.001", new Object[]{dataInicial}));
        }
        if (this.isNull(dataFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0331.002", new Object[]{dataFinal}));
        }
        if (dataFinal.before(dataInicial)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0331.003", new Object[]{dataFinal}));
        }
    }

    public List<DTOCompensacaoChequeTerceiros> getPesquisarBorderoChequeTerceiro(List<Long> idBordero, Short visualizarSaldosMovFinancOutEmp, Empresa empresa) {
        List<ChequeTerceiros> listaCheque = this.getBorderos(idBordero, visualizarSaldosMovFinancOutEmp, empresa);
        ArrayList<CompensacaoChequeTerceiros> compensacao = new ArrayList<CompensacaoChequeTerceiros>();
        for (ChequeTerceiros cheque : listaCheque) {
            CompensacaoChequeTerceiros compensacaoCheque = new CompensacaoChequeTerceiros();
            compensacaoCheque.setCheque(cheque);
            compensacao.add(compensacaoCheque);
        }
        return this.buildToDTOGeneric(compensacao, DTOCompensacaoChequeTerceiros.class);
    }

    private List<ChequeTerceiros> getBorderos(List<Long> idBordero, Short visualizarSaldosMovFinancOutEmp, Empresa empresa) {
        ArrayList<ChequeTerceiros> listaCheque = new ArrayList<ChequeTerceiros>();
        for (Long bordero : idBordero) {
            if (this.isEquals(visualizarSaldosMovFinancOutEmp, EnumConstantsMentorSimNao.NAO.getValue())) {
                listaCheque.addAll(this.serviceChequeTerceirosImpl.getChequeTerceirosPeloBorderoNaoCompensados(bordero, empresa, EnumConstantsMentorSimNao.SIM.getValue()));
                continue;
            }
            listaCheque.addAll(this.serviceChequeTerceirosImpl.getChequeTerceirosPeloBorderoNaoCompensados(bordero, null, EnumConstantsMentorSimNao.NAO.getValue()));
        }
        return listaCheque;
    }

    public List<DTOCompensacaoChequeTerceiros> getPesquisarCheque(List<Long> idCheque, Short visualizarSaldosMovFinancOutEmp, Empresa empresa) {
        List<ChequeTerceiros> cheques = this.getCheques(idCheque, visualizarSaldosMovFinancOutEmp, empresa);
        ArrayList<CompensacaoChequeTerceiros> compensacao = new ArrayList<CompensacaoChequeTerceiros>();
        for (ChequeTerceiros cheque : cheques) {
            CompensacaoChequeTerceiros compensacaoCheque = new CompensacaoChequeTerceiros();
            compensacaoCheque.setCheque(cheque);
            compensacao.add(compensacaoCheque);
        }
        return this.buildToDTOGeneric(compensacao, DTOCompensacaoChequeTerceiros.class);
    }

    private List<ChequeTerceiros> getCheques(List<Long> idCheque, Short visualizarSaldosMovFinancOutEmp, Empresa empresa) {
        ArrayList<ChequeTerceiros> listaCheques = new ArrayList<ChequeTerceiros>();
        for (Long cheque : idCheque) {
            if (this.isEquals(visualizarSaldosMovFinancOutEmp, EnumConstantsMentorSimNao.NAO.getValue())) {
                listaCheques.add(this.serviceChequeTerceirosImpl.getChequeTerceirosNaoCompensados(cheque, empresa, EnumConstantsMentorSimNao.SIM.getValue()));
                continue;
            }
            listaCheques.add(this.serviceChequeTerceirosImpl.getChequeTerceirosNaoCompensados(cheque, null, EnumConstantsMentorSimNao.NAO.getValue()));
        }
        return listaCheques;
    }

    @Override
    public GrupoCompensacaoTerceiros beforeSaveEntity(GrupoCompensacaoTerceiros aux) {
        aux.getCompensacaoChequesTerceiros().forEach(i -> i.setGrupoCompensacao(aux));
        if (this.isNotNull(this.getSharedData()).booleanValue()) {
            this.salvarCompensacaoChequeTerceiros(aux, this.getSharedData().getOpcoesFinanceiras(aux.getEmpresa()), this.getSharedData().getOpcoesContabeis(aux.getEmpresa()));
        }
        return super.beforeSaveEntity(aux);
    }

    private void salvarCompensacaoChequeTerceiros(GrupoCompensacaoTerceiros grupoCompensacaoTerceiros, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) {
        Boolean gerarTit = this.isEquals(opcoesFinanceiras.getGerarTitChequeDev(), EnumConstantsMentorSimNao.SIM.getValue());
        for (CompensacaoChequeTerceiros compensacao : grupoCompensacaoTerceiros.getCompensacaoChequesTerceiros()) {
            BorderoChequeTerceirosMovBancario bordero = this.serviceBorderoChequeTerceirosMovBancarioImpl.pesquisarUltimoBorderoChequeTerceiro(compensacao.getCheque());
            if (this.isNotNull(bordero).booleanValue() && this.isNotNull(bordero.getMovimentoBancarioCredito()).booleanValue()) {
                bordero.getMovimentoBancarioCredito().setDataCompensacao(compensacao.getDataCompensacao());
                bordero.getMovimentoBancarioDebito().setDataCompensacao(compensacao.getDataCompensacao());
                this.serviceBorderoChequeTerceirosMovBancarioImpl.saveOrUpdate(bordero);
            }
            if (gerarTit.booleanValue() && this.isNotNull(bordero).booleanValue() && this.isEquals(compensacao.getTipoCompensacaoChTerceiros().getCodigo(), EnumConstChequeTerceiros.DEVOLVIDO.getValue()) && this.isNotNull(bordero.getMovimentoBancarioCredito().getContaValor().getPlanoConta()).booleanValue() && this.isEquals(bordero.getMovimentoBancarioCredito().getContaValor().getGerarLancamentoContabil(), EnumConstantsMentorSimNao.SIM.getValue())) {
                PlanoConta planoConta = bordero.getMovimentoBancarioCredito().getContaValor().getPlanoConta();
                compensacao.setPlanoConta(planoConta);
                this.compGeraTituloChequeTerceiros.gerarTitulo(compensacao, opcoesContabeis.getPlanoChequeTerceirosGerencial(), grupoCompensacaoTerceiros.getEmpresa());
            }
            if (!this.isNotNull(grupoCompensacaoTerceiros.getObservacao()).booleanValue() || !this.isStrWithData(grupoCompensacaoTerceiros.getObservacao())) continue;
            compensacao.getCheque().setObservacao(compensacao.getCheque().getObservacao() + " " + grupoCompensacaoTerceiros.getObservacao());
            if (!ToolMethods.isStrWithDataLengthG((String)compensacao.getCheque().getObservacao(), (int)5000)) continue;
            compensacao.getCheque().setObservacao(compensacao.getCheque().getObservacao().substring(0, 5000));
        }
    }

    @Override
    public GrupoCompensacaoTerceiros beforeDeleteEntity(GrupoCompensacaoTerceiros entity) {
        this.deletarCompensacaoChequeTerceiro(entity);
        return super.beforeDeleteEntity(entity);
    }

    private void deletarCompensacaoChequeTerceiro(GrupoCompensacaoTerceiros entity) {
        for (CompensacaoChequeTerceiros compensacao : entity.getCompensacaoChequesTerceiros()) {
            BorderoChequeTerceirosMovBancario borderoChequesTerceiros = this.serviceBorderoChequeTerceirosMovBancarioImpl.pesquisarUltimoBorderoChequeTerceiro(compensacao.getCheque());
            if (!this.isNotNull(borderoChequesTerceiros).booleanValue()) continue;
            borderoChequesTerceiros.getMovimentoBancarioCredito().setDataCompensacao(null);
            borderoChequesTerceiros.getMovimentoBancarioDebito().setDataCompensacao(null);
            this.serviceBorderoChequeTerceirosMovBancarioImpl.saveOrUpdate(borderoChequesTerceiros);
        }
    }
}

