/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupodebaixa;

import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoDeBaixaFormasImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.grupodebaixasformas.web.DTOGrupoDeBaixaFormasRes;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.LockMode;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoDeBaixaFormas
extends ServiceGenericEntityImpl<GrupoDeBaixaFormas, Long, DaoGrupoDeBaixaFormasImpl> {
    public ServiceGrupoDeBaixaFormas(DaoGrupoDeBaixaFormasImpl genericDao) {
        super(genericDao);
    }

    public GrupoDeBaixaFormas getGrupoDeBaixaVinculadoCompensacao(GrupoDeBaixa grupo) {
        return ((DaoGrupoDeBaixaFormasImpl)this.getGenericDao()).getGrupoDeBaixaVinculadoCompensacao(grupo);
    }

    public List<GrupoDeBaixaFormas> baixasPorPeriodo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoGrupoDeBaixaFormasImpl)this.getGenericDao()).baixasPorPeriodo(dataInicial, dataFinal, grupoEmpresa);
    }

    @Async
    public CompletableFuture<List> baixasPorPeriodoAsync(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        ((DaoGrupoDeBaixaFormasImpl)this.getGenericDao()).getSession().lock((Object)grupoEmpresa, LockMode.NONE);
        List<GrupoDeBaixaFormas> baixas = this.baixasPorPeriodo(dataInicial, dataFinal, grupoEmpresa);
        return CompletableFuture.completedFuture(this.buildToDTO(baixas, DTOGrupoDeBaixaFormasRes.class));
    }
}

