/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupofaturatitulos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaturaTitulos;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GrupoFaturaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.titulos.impl.CompTitulosFaturaTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoFaturaTitulosImpl;
import com.touchcomp.basementorservice.dao.impl.DaoInfPagamentoNfTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.grupofaturatitulos.HelperGrupoFaturaTitulos;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.faturatitulos.ServiceFaturaTitulosImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.grupofaturatitulos.auxiliar.AuxBuildFaturaTitulos;
import com.touchcomp.basementorservice.service.impl.infpagamentonfpropria.InfPagamentoNfPropriaService;
import com.touchcomp.basementorservice.service.impl.infpagamentonfterceiros.ServiceInfPagamentoNfTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.grupofaturatitulos.web.DTOGrupoFaturaTitulos;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoFaturaTitulosImpl
extends ServiceGenericEntityImpl<GrupoFaturaTitulos, Long, DaoGrupoFaturaTitulosImpl> {
    private final ServiceInfPagamentoNfTerceirosImpl serviceInfPagamentoNfTerceiros;
    private final InfPagamentoNfPropriaService serviceInfPagamentoNfPropria;
    private final ServiceFaturaTitulosImpl serviceFaturaTitulos;
    private final ServiceFornecedorImpl serviceFornecedor;
    private final ServiceClienteImpl serviceCliente;
    private final CompTitulosFaturaTitulos compTitulos;
    private final HelperGrupoFaturaTitulos helper;
    private final ServiceTituloImpl serviceTitulo;

    @Autowired
    public ServiceGrupoFaturaTitulosImpl(DaoGrupoFaturaTitulosImpl dao, ServiceInfPagamentoNfTerceirosImpl serviceInfPagamentoNfTerceiros, HelperLancamentoCtbGerencial helperLancamentoGerencial, InfPagamentoNfPropriaService serviceInfPagamentoNfPropria, ServiceFaturaTitulosImpl serviceFaturaTitulos, ServiceFornecedorImpl serviceFornecedor, ServiceClienteImpl serviceCliente, CompTitulosFaturaTitulos compTitulos, HelperGrupoFaturaTitulos helper, ServiceTituloImpl serviceTitulo) {
        super(dao);
        this.serviceInfPagamentoNfTerceiros = serviceInfPagamentoNfTerceiros;
        this.serviceInfPagamentoNfPropria = serviceInfPagamentoNfPropria;
        this.serviceFaturaTitulos = serviceFaturaTitulos;
        this.serviceFornecedor = serviceFornecedor;
        this.serviceCliente = serviceCliente;
        this.compTitulos = compTitulos;
        this.helper = helper;
        this.serviceTitulo = serviceTitulo;
    }

    @Override
    public GrupoFaturaTitulos beforeSave(GrupoFaturaTitulos vo) {
        if (TMethods.isWithData((Collection)vo.getFaturaTitulos())) {
            for (FaturaTitulos fatura : vo.getFaturaTitulos()) {
                fatura.setGrupoFaturaTitulos(vo);
                if (TMethods.isWithData((Collection)fatura.getFaturaTituloNF())) {
                    fatura.getFaturaTituloNF().forEach(i -> i.setFaturaTitulos(fatura));
                }
                if (!TMethods.isWithData((Collection)fatura.getTitulos())) continue;
                for (Titulo titulo : fatura.getTitulos()) {
                    titulo.setFaturaTitulos(fatura);
                    this.serviceTitulo.beforeSave(titulo);
                }
            }
        }
        return vo;
    }

    public List<DTOGrupoFaturaTitulos.DTOFaturaTitulos> processarFatura(Long dataInicial, Long dataFinal, Long dataFatura, Short tipoTitulo, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) throws ExceptionValidacaoDados, ExceptionTitulo, ExceptionInvalidData {
        if (TMethods.isNull((Object)dataInicial).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0809.001", new Object[0]);
        }
        if (TMethods.isNull((Object)dataInicial).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0809.002", new Object[0]);
        }
        if (TMethods.isNull((Object)dataInicial).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0809.003", new Object[0]);
        }
        ((DaoGrupoFaturaTitulosImpl)this.getGenericDao()).getSession().load((Object)empresa, (Serializable)empresa.getIdentificador());
        ((DaoGrupoFaturaTitulosImpl)this.getGenericDao()).getSession().load((Object)opcoesFinanceiras, (Serializable)opcoesFinanceiras.getIdentificador());
        EnumConstTipoTitulo tipo = EnumConstTipoTitulo.get((Object)tipoTitulo);
        if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoTitulo.PAGAMENTO)) {
            return this.getFaturaPagamento(new Date(dataInicial), new Date(dataFinal), new Date(dataFatura), empresa, opcoesFinanceiras, opcoesContabeis);
        }
        if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoTitulo.RECEBIMENTO)) {
            return this.getFaturaRecebimento(new Date(dataInicial), new Date(dataFinal), new Date(dataFatura), empresa, opcoesFinanceiras, opcoesContabeis);
        }
        if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoTitulo.AMBOS)) {
            LinkedList<DTOGrupoFaturaTitulos.DTOFaturaTitulos> result = new LinkedList<DTOGrupoFaturaTitulos.DTOFaturaTitulos>();
            result.addAll(this.getFaturaPagamento(new Date(dataInicial), new Date(dataFinal), new Date(dataFatura), empresa, opcoesFinanceiras, opcoesContabeis));
            result.addAll(this.getFaturaRecebimento(new Date(dataInicial), new Date(dataFinal), new Date(dataFatura), empresa, opcoesFinanceiras, opcoesContabeis));
            return result;
        }
        return new LinkedList<DTOGrupoFaturaTitulos.DTOFaturaTitulos>();
    }

    public DTOGrupoFaturaTitulos.DTOFaturaTitulos reprocessarFatura(DTOGrupoFaturaTitulos.DTOFaturaTitulos input, OpcoesFinanceiras opFin, OpcoesContabeis opcoesContabeis) throws ExceptionValidacaoDados, ExceptionInvalidData {
        if (this.isNull(input).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0809.004", new Object[0]);
        }
        ((DaoGrupoFaturaTitulosImpl)this.getGenericDao()).getSession().load((Object)opFin, (Serializable)opFin.getIdentificador());
        FaturaTitulos fatura = (FaturaTitulos)this.serviceFaturaTitulos.buildToEntity(input);
        AuxBuildFaturaTitulos aux = new AuxBuildFaturaTitulos(this.serviceInfPagamentoNfPropria, this.serviceInfPagamentoNfTerceiros, this.helper, this.compTitulos);
        if (this.isEquals(fatura.getPagRec(), EnumConstTipoTitulo.PAGAMENTO.getValue())) {
            return this.processarFaturaPagamento(this.serviceFornecedor.get(fatura.getPessoa()), fatura.getDataInicial(), fatura.getDataFinal(), fatura.getDataFatura(), fatura.getEmpresa(), opFin, aux, fatura.getCondicoesPagamento(), opcoesContabeis);
        }
        if (this.isEquals(fatura.getPagRec(), EnumConstTipoTitulo.RECEBIMENTO.getValue())) {
            return this.processarFaturaRecebimento(this.serviceCliente.findClienteByPessoa(fatura.getPessoa()), fatura.getDataInicial(), fatura.getDataFinal(), fatura.getDataFatura(), fatura.getEmpresa(), opFin, aux, fatura.getCondicoesPagamento(), opcoesContabeis);
        }
        return input;
    }

    private List<DTOGrupoFaturaTitulos.DTOFaturaTitulos> getFaturaRecebimento(Date dataInicial, Date dataFinal, Date dataFatura, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        ArrayList<DTOGrupoFaturaTitulos.DTOFaturaTitulos> faturas = new ArrayList<DTOGrupoFaturaTitulos.DTOFaturaTitulos>();
        List<Cliente> clientes = this.serviceInfPagamentoNfPropria.getClientesFatura(dataInicial, dataFinal);
        if (TMethods.isWithData(clientes)) {
            AuxBuildFaturaTitulos aux = new AuxBuildFaturaTitulos(this.serviceInfPagamentoNfPropria, this.serviceInfPagamentoNfTerceiros, this.helper, this.compTitulos);
            for (Cliente cliente : clientes) {
                faturas.add(this.processarFaturaRecebimento(cliente, dataInicial, dataFinal, dataFatura, empresa, opcoesFinanceiras, aux, null, opcoesContabeis));
            }
        }
        return faturas;
    }

    private DTOGrupoFaturaTitulos.DTOFaturaTitulos processarFaturaRecebimento(Cliente cliente, Date dataInicial, Date dataFinal, Date dataFatura, Empresa empresa, OpcoesFinanceiras opFin, AuxBuildFaturaTitulos builder, CondicoesPagamento condicoesFatura, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        DTOGrupoFaturaTitulos.DTOFaturaTitulos dto;
        FaturaTitulos f = this.helper.buildFaturaTitulos(cliente, dataInicial, dataFinal, dataFatura, empresa, condicoesFatura, EnumConstTipoTitulo.RECEBIMENTO, opcoesContabeis);
        try {
            builder.gerarFaturaTitulosRecebimento(f, opFin);
            dto = this.buildToDTOGeneric(f, DTOGrupoFaturaTitulos.DTOFaturaTitulos.class);
        }
        catch (ExceptionTitulo ex) {
            dto = this.buildToDTOGeneric(f, DTOGrupoFaturaTitulos.DTOFaturaTitulos.class);
            this.doProcessExceptionTitulo(dto, ex);
        }
        return dto;
    }

    private List<DTOGrupoFaturaTitulos.DTOFaturaTitulos> getFaturaPagamento(Date dataInicial, Date dataFinal, Date dataFatura, Empresa empresa, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        ArrayList<DTOGrupoFaturaTitulos.DTOFaturaTitulos> faturas = new ArrayList<DTOGrupoFaturaTitulos.DTOFaturaTitulos>();
        List<Fornecedor> fornecedores = this.serviceInfPagamentoNfTerceiros.getFornecedoresFatura(dataInicial, dataFinal);
        if (TMethods.isWithData(fornecedores)) {
            AuxBuildFaturaTitulos aux = new AuxBuildFaturaTitulos(this.serviceInfPagamentoNfPropria, this.serviceInfPagamentoNfTerceiros, this.helper, this.compTitulos);
            for (Fornecedor fornecedor : fornecedores) {
                ((DaoInfPagamentoNfTerceirosImpl)this.serviceInfPagamentoNfTerceiros.getGenericDao()).getSession().clear();
                faturas.add(this.processarFaturaPagamento(fornecedor, dataInicial, dataFinal, dataFatura, empresa, opcoesFinanceiras, aux, null, opcoesContabeis));
            }
        }
        return faturas;
    }

    private DTOGrupoFaturaTitulos.DTOFaturaTitulos processarFaturaPagamento(Fornecedor fornecedor, Date dataInicial, Date dataFinal, Date dataFatura, Empresa empresa, OpcoesFinanceiras opFin, AuxBuildFaturaTitulos builder, CondicoesPagamento condicoesFatura, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        DTOGrupoFaturaTitulos.DTOFaturaTitulos dto;
        FaturaTitulos f = this.helper.buildFaturaTitulos(fornecedor, dataInicial, dataFinal, dataFatura, empresa, condicoesFatura, EnumConstTipoTitulo.PAGAMENTO, opcoesContabeis);
        try {
            builder.gerarFaturaTitulosPagamento(f, opFin);
            dto = this.buildToDTOGeneric(f, DTOGrupoFaturaTitulos.DTOFaturaTitulos.class);
        }
        catch (ExceptionTitulo ex) {
            dto = this.buildToDTOGeneric(f, DTOGrupoFaturaTitulos.DTOFaturaTitulos.class);
            this.doProcessExceptionTitulo(dto, ex);
        }
        return dto;
    }

    private void doProcessExceptionTitulo(DTOGrupoFaturaTitulos.DTOFaturaTitulos dto, ExceptionTitulo ex) {
        dto.setObservacoes(ex.getFormattedMessage());
        dto.setStatus(Short.valueOf(EnumConstantsMentorStatus.ERRO.getValue()));
    }
}

