/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupofaturatitulos.auxiliar;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.FaturaTituloNF;
import com.touchcomp.basementor.model.vo.FaturaTitulos;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.titulos.impl.CompTitulosFaturaTitulos;
import com.touchcomp.basementorservice.helpers.impl.grupofaturatitulos.HelperGrupoFaturaTitulos;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.impl.infpagamentonfpropria.InfPagamentoNfPropriaService;
import com.touchcomp.basementorservice.service.impl.infpagamentonfterceiros.ServiceInfPagamentoNfTerceirosImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class AuxBuildFaturaTitulos {
    private final InfPagamentoNfPropriaService serviceInfPagamentoNfPropria;
    private final ServiceInfPagamentoNfTerceirosImpl serviceInfPagamentoNfTerceiros;
    private final HelperGrupoFaturaTitulos helper;
    private final CompTitulosFaturaTitulos compTitulos;

    public void gerarFaturaTitulosRecebimento(FaturaTitulos vo, OpcoesFinanceiras op) throws ExceptionTitulo {
        List<InfPagamentoNfPropria> dados = this.serviceInfPagamentoNfPropria.getDadosFatNfPropria(vo.getPessoa(), vo.getDataInicial(), vo.getDataFinal());
        Double valorTotal = this.helper.getValorTotalNfPropria(dados, vo);
        this.setTitulos(vo, valorTotal, op);
        this.setComissaoTitulos(vo);
        this.setLancamentosGerenciais(vo, this.setLancamentosGerenciaisNFPropria(vo));
    }

    public void gerarFaturaTitulosPagamento(FaturaTitulos vo, OpcoesFinanceiras op) throws ExceptionTitulo {
        List<InfPagamentoNfTerceiros> dados = this.serviceInfPagamentoNfTerceiros.getDadosFatNfTerceiros(vo.getPessoa(), vo.getDataInicial(), vo.getDataFinal());
        Double valorTotal = this.helper.getValorTotalNfTerceiros(dados, vo);
        this.setTitulos(vo, valorTotal, op);
        this.setLancamentosGerenciais(vo, this.setLancamentosGerenciaisNFTerceiros(vo));
    }

    private void setTitulos(FaturaTitulos vo, Double valorTotal, OpcoesFinanceiras op) throws ExceptionTitulo {
        vo.setTitulos(this.compTitulos.criaTitulos(vo, valorTotal, op));
    }

    private void setComissaoTitulos(FaturaTitulos vo) {
        LinkedList<RepresentateComissao> aux = new LinkedList<RepresentateComissao>();
        if (TMethods.isWithData((Collection)vo.getFaturaTituloNF())) {
            for (FaturaTituloNF faturaTituloNF : vo.getFaturaTituloNF()) {
                Double percPag = faturaTituloNF.getInfPagamentoNfPropria().getValor() / faturaTituloNF.getInfPagamentoNfPropria().getNotaFiscalPropria().getValoresNfPropria().getValorTotal();
                for (ItemNotaFiscalPropria itemNF : faturaTituloNF.getInfPagamentoNfPropria().getNotaFiscalPropria().getItensNotaPropria()) {
                    RepresentateComissao repc;
                    if (!TMethods.isNotNull((Object)itemNF.getRepresentante()).booleanValue()) continue;
                    Optional<RepresentateComissao> found = aux.stream().filter(i -> Objects.equals(itemNF.getRepresentante(), i.getRepresentante())).findFirst();
                    if (found.isPresent()) {
                        repc = found.get();
                    } else {
                        repc = new RepresentateComissao(this);
                        repc.setRepresentante(itemNF.getRepresentante());
                        aux.add(repc);
                    }
                    repc.setValorBCComissao(repc.getValorBCComissao() + itemNF.getItemNotaLivroFiscal().getValorTotal() * percPag);
                    repc.setValorComissao(repc.getValorComissao() + itemNF.getItemNotaLivroFiscal().getValorTotal() * percPag);
                }
            }
        }
        ArrayList<TituloRepresentante> lanc = new ArrayList<TituloRepresentante>();
        for (Titulo t : vo.getTitulos()) {
            for (RepresentateComissao k : aux) {
                TituloRepresentante l = new TituloRepresentante();
                l.setPercComissao(Double.valueOf(k.getValorComissao() / k.getValorBCComissao() * 100.0));
                l.setRepresentante(k.getRepresentante());
                l.setTitulo(t);
                l.setVrBCComissao(Double.valueOf(k.getValorComissao() / (double)vo.getTitulos().size()));
                lanc.add(l);
            }
            t.getRepresentantes().addAll(lanc);
        }
    }

    private List<LancamentoGerPC> setLancamentosGerenciaisNFPropria(FaturaTitulos vo) {
        LinkedList<LancamentoGerPC> aux = new LinkedList<LancamentoGerPC>();
        for (FaturaTituloNF faturaTituloNF : vo.getFaturaTituloNF()) {
            Double percPag = faturaTituloNF.getInfPagamentoNfPropria().getValor() / faturaTituloNF.getInfPagamentoNfPropria().getNotaFiscalPropria().getValoresNfPropria().getValorTotal();
            for (ItemNotaFiscalPropria itemNF : faturaTituloNF.getInfPagamentoNfPropria().getNotaFiscalPropria().getItensNotaPropria()) {
                LancamentoGerPC repc;
                Optional<LancamentoGerPC> found = aux.stream().filter(i -> Objects.equals(itemNF.getPlanoContaGerencial(), i.getPlanoContaGerencial())).findFirst();
                if (found.isPresent()) {
                    repc = found.get();
                } else {
                    repc = new LancamentoGerPC(this);
                    repc.setPlanoContaGerencial(itemNF.getPlanoContaGerencial());
                    aux.add(repc);
                }
                repc.setValor(repc.getValor() + itemNF.getItemNotaLivroFiscal().getValorTotal() * percPag);
            }
        }
        return aux;
    }

    private List<LancamentoGerPC> setLancamentosGerenciaisNFTerceiros(FaturaTitulos vo) {
        LinkedList<LancamentoGerPC> aux = new LinkedList<LancamentoGerPC>();
        if (TMethods.isWithData((Collection)vo.getFaturaTituloNF())) {
            for (FaturaTituloNF faturaTituloNF : vo.getFaturaTituloNF()) {
                Double percPag = faturaTituloNF.getInfPagamentoNfTerceiros().getValor() / faturaTituloNF.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getValoresNfTerceiros().getValorTotal();
                for (ItemNotaTerceiros itemNF : faturaTituloNF.getInfPagamentoNfTerceiros().getNotaFiscalTerceiros().getItemNotaTerceiros()) {
                    LancamentoGerPC repc;
                    Optional<LancamentoGerPC> found = aux.stream().filter(i -> Objects.equals(itemNF.getPlanoContaGerencial(), i.getPlanoContaGerencial())).findFirst();
                    if (found.isPresent()) {
                        repc = found.get();
                    } else {
                        repc = new LancamentoGerPC(this);
                        repc.setPlanoContaGerencial(itemNF.getPlanoContaGerencial());
                        aux.add(repc);
                    }
                    repc.setValor(repc.getValor() + itemNF.getItemNotaLivroFiscal().getValorTotal() * percPag);
                }
            }
        }
        return aux;
    }

    private void setLancamentosGerenciais(FaturaTitulos vo, List<LancamentoGerPC> aux) {
        ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
        if (TMethods.isWithData((Collection)vo.getTitulos())) {
            for (Titulo t : vo.getTitulos()) {
                for (LancamentoGerPC k : aux) {
                    LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, vo.getDataCadastro(), t.getDataVencimento(), EnumLancamentoCTBGerencial.CREDITO.getValue(), vo.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), MessagesBaseMentor.getMsg((String)"lancamentoGeradoFaturaTitulos", (Object[])new Object[0]), k.getPlanoContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), null, k.getValor() / (double)vo.getTitulos().size(), null);
                    lanc.add(l);
                }
                t.setLancCtbGerencial(lanc);
            }
        }
    }

    @Generated
    public AuxBuildFaturaTitulos(InfPagamentoNfPropriaService serviceInfPagamentoNfPropria, ServiceInfPagamentoNfTerceirosImpl serviceInfPagamentoNfTerceiros, HelperGrupoFaturaTitulos helper, CompTitulosFaturaTitulos compTitulos) {
        this.serviceInfPagamentoNfPropria = serviceInfPagamentoNfPropria;
        this.serviceInfPagamentoNfTerceiros = serviceInfPagamentoNfTerceiros;
        this.helper = helper;
        this.compTitulos = compTitulos;
    }

    class RepresentateComissao {
        private Representante representante;
        private Double valorBCComissao = 0.0;
        private Double valorComissao = 0.0;

        public RepresentateComissao(AuxBuildFaturaTitulos this$0) {
        }

        @Generated
        public Representante getRepresentante() {
            return this.representante;
        }

        @Generated
        public Double getValorBCComissao() {
            return this.valorBCComissao;
        }

        @Generated
        public Double getValorComissao() {
            return this.valorComissao;
        }

        @Generated
        public void setRepresentante(Representante representante) {
            this.representante = representante;
        }

        @Generated
        public void setValorBCComissao(Double valorBCComissao) {
            this.valorBCComissao = valorBCComissao;
        }

        @Generated
        public void setValorComissao(Double valorComissao) {
            this.valorComissao = valorComissao;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepresentateComissao)) {
                return false;
            }
            RepresentateComissao other = (RepresentateComissao)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$valorBCComissao = this.getValorBCComissao();
            Double other$valorBCComissao = other.getValorBCComissao();
            if (this$valorBCComissao == null ? other$valorBCComissao != null : !((Object)this$valorBCComissao).equals(other$valorBCComissao)) {
                return false;
            }
            Double this$valorComissao = this.getValorComissao();
            Double other$valorComissao = other.getValorComissao();
            if (this$valorComissao == null ? other$valorComissao != null : !((Object)this$valorComissao).equals(other$valorComissao)) {
                return false;
            }
            Representante this$representante = this.getRepresentante();
            Representante other$representante = other.getRepresentante();
            return !(this$representante == null ? other$representante != null : !this$representante.equals(other$representante));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RepresentateComissao;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $valorBCComissao = this.getValorBCComissao();
            result = result * 59 + ($valorBCComissao == null ? 43 : ((Object)$valorBCComissao).hashCode());
            Double $valorComissao = this.getValorComissao();
            result = result * 59 + ($valorComissao == null ? 43 : ((Object)$valorComissao).hashCode());
            Representante $representante = this.getRepresentante();
            result = result * 59 + ($representante == null ? 43 : $representante.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuxBuildFaturaTitulos.RepresentateComissao(representante=" + String.valueOf(this.getRepresentante()) + ", valorBCComissao=" + this.getValorBCComissao() + ", valorComissao=" + this.getValorComissao() + ")";
        }
    }

    class LancamentoGerPC {
        private PlanoContaGerencial planoContaGerencial;
        private Double valor = 0.0;

        public LancamentoGerPC(AuxBuildFaturaTitulos this$0) {
        }

        @Generated
        public PlanoContaGerencial getPlanoContaGerencial() {
            return this.planoContaGerencial;
        }

        @Generated
        public Double getValor() {
            return this.valor;
        }

        @Generated
        public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
            this.planoContaGerencial = planoContaGerencial;
        }

        @Generated
        public void setValor(Double valor) {
            this.valor = valor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LancamentoGerPC)) {
                return false;
            }
            LancamentoGerPC other = (LancamentoGerPC)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$valor = this.getValor();
            Double other$valor = other.getValor();
            if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
                return false;
            }
            PlanoContaGerencial this$planoContaGerencial = this.getPlanoContaGerencial();
            PlanoContaGerencial other$planoContaGerencial = other.getPlanoContaGerencial();
            return !(this$planoContaGerencial == null ? other$planoContaGerencial != null : !this$planoContaGerencial.equals(other$planoContaGerencial));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LancamentoGerPC;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $valor = this.getValor();
            result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
            PlanoContaGerencial $planoContaGerencial = this.getPlanoContaGerencial();
            result = result * 59 + ($planoContaGerencial == null ? 43 : $planoContaGerencial.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuxBuildFaturaTitulos.LancamentoGerPC(planoContaGerencial=" + String.valueOf(this.getPlanoContaGerencial()) + ", valor=" + this.getValor() + ")";
        }
    }
}

