/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.gruponeccompra;

import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoNecCompraImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoNecCompraImpl
extends ServiceGenericEntityImpl<GrupoNecCompra, Long, DaoGrupoNecCompraImpl> {
    @Autowired
    public ServiceGrupoNecCompraImpl(DaoGrupoNecCompraImpl dao) {
        super(dao);
    }

    @Override
    public GrupoNecCompra beforeSave(GrupoNecCompra aux) {
        if (aux.getNecessidadesCompra() != null) {
            for (NecessidadeCompra n : aux.getNecessidadesCompra()) {
                n.setCentroCusto(aux.getCentroCusto());
                n.setAtivo(aux.getAtivo());
                n.setEmpresa(aux.getEmpresa());
                n.setGrupoNecCompra(aux);
                n.setDataCadastro(aux.getDataCadastro());
                n.setEstoque(Double.valueOf(0.0));
                n.setEstoqueMaximo(Double.valueOf(0.0));
                n.setEstoqueMinimo(Double.valueOf(0.0));
                n.setEstoqueRessuprimento(Double.valueOf(0.0));
                n.setTipoGeracao(Short.valueOf((short)0));
                n.setTipoNecessidade(aux.getTipoNecessidade());
                n.setUsuarioComprador(aux.getUsuarioComprador());
                n.setUsuarioSolicitante(aux.getUsuarioSolicitante());
                n.setQuantidadeComprada(Double.valueOf(0.0));
                n.setQuantidadeNecessidade(n.getQuantidadeAdicional());
                n.setQuantidadeNecessidadeGerada(Double.valueOf(0.0));
                n.getEmailGrupoNecCompra().clear();
                for (EmailGrupoNecCompra emG : aux.getEmailGrupoNecCompra()) {
                    EmailGrupoNecCompra e = new EmailGrupoNecCompra();
                    e.setEmail(emG.getEmail());
                    e.setNecessidadeCompra(n);
                    n.getEmailGrupoNecCompra().add(e);
                }
                if (n.getItemNecCompraDetalhes() == null) continue;
                n.getItemNecCompraDetalhes().forEach(i -> i.setNecessidadeCompra(n));
            }
        }
        if (aux.getEmailGrupoNecCompra() != null) {
            for (EmailGrupoNecCompra em : aux.getEmailGrupoNecCompra()) {
                em.setGrupoNecCompra(aux);
            }
        }
        return aux;
    }

    @Override
    public GrupoNecCompra beforeSaveEntity(GrupoNecCompra vo) {
        if (vo.getNecessidadesCompra() != null) {
            for (NecessidadeCompra n : vo.getNecessidadesCompra()) {
                n.setGrupoNecCompra(vo);
                if (n.getItemNecCompraDetalhes() == null) continue;
                n.getItemNecCompraDetalhes().forEach(i -> i.setNecessidadeCompra(n));
            }
            if (vo.getEmailGrupoNecCompra() != null) {
                vo.getEmailGrupoNecCompra().forEach(i -> i.setGrupoNecCompra(vo));
            }
        }
        return vo;
    }
}

