/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupousuarios;

import com.touchcomp.basementor.model.vo.NodoGrupo;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.grupo.web.DTONodoGrupo;
import java.util.Collections;
import java.util.List;

public class AuxMontaNodosGrupo {
    public DTONodoGrupo getDTONodoGrupoPrincipal(List<NodoGrupo> nodos) {
        NodoGrupo principalNodo = nodos.get(0);
        DTONodoGrupo voNodo = this.toVONodoGrupo(principalNodo);
        this.montaGrupoInternal(voNodo, nodos);
        this.ordenar(voNodo);
        return voNodo;
    }

    private void montaGrupoInternal(DTONodoGrupo aux, List<NodoGrupo> nodos) {
        for (int i = 0; i < nodos.size(); ++i) {
            NodoGrupo nodo = nodos.get(i);
            if (nodo.getNodoGrupoPai() == null || !TMethods.isEquals((Object)nodo.getNodoGrupoPai().getIdentificador(), (Object)aux.getIdentificador())) continue;
            DTONodoGrupo d = this.toVONodoGrupo(nodo);
            aux.getNodoGrupo().add(d);
            nodos.remove(nodo);
            this.montaGrupoInternal(d, nodos);
            i = -1;
        }
    }

    private void ordenar(DTONodoGrupo df) {
        if (df == null || df.getNodoGrupo() == null) {
            return;
        }
        Collections.sort(df.getNodoGrupo(), (o1, o2) -> {
            if (o1 != null && o1.getNodoDescricao() != null && o2 != null && o2.getNodoDescricao() != null) {
                return o1.getNodoDescricao().compareTo(o2.getNodoDescricao());
            }
            return 0;
        });
        for (DTONodoGrupo aux : df.getNodoGrupo()) {
            this.ordenar(aux);
        }
    }

    private DTONodoGrupo toVONodoGrupo(NodoGrupo nodoGrupo) {
        DTONodoGrupo dto = new DTONodoGrupo();
        dto.setAcessar(nodoGrupo.getAcessar());
        dto.setClonar(nodoGrupo.getClonar());
        dto.setEditar(nodoGrupo.getEditar());
        dto.setExcluir(nodoGrupo.getExcluir());
        dto.setExcluirMultiplos(nodoGrupo.getExcluirMultiplos());
        dto.setIdentificador(nodoGrupo.getIdentificador());
        dto.setInserir(nodoGrupo.getInserir());
        dto.setNodoIdentificador(nodoGrupo.getNodo().getIdentificador());
        dto.setPesquisar(nodoGrupo.getPesquisar());
        dto.setNodoDescricao(nodoGrupo.getNodo().getDescricao());
        dto.setNodoPathWeb(nodoGrupo.getNodo().getPathWeb());
        return dto;
    }
}

