/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupousuarios;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemaWEB;
import com.touchcomp.basementor.model.vo.NodoGrupo;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.grupo.web.DTONodoGrupo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class AuxMontaNodosGrupoWEB {
    AuxMontaNodosGrupoWEB() {
    }

    public DTONodoGrupo getDTONodoGrupoPrincipal(List<NodoGrupo> nodos, EnumConstTipoSistemaWEB tipo) {
        NodoGrupo principalNodo = nodos.get(0);
        DTONodoGrupo voNodo = this.toVONodoGrupo(principalNodo);
        this.montaGrupoInternal(voNodo, nodos);
        voNodo = this.filtrarWeb(voNodo, tipo);
        this.ordernar(voNodo);
        return voNodo;
    }

    private DTONodoGrupo filtrarWeb(DTONodoGrupo aux, EnumConstTipoSistemaWEB tipo) {
        LinkedList<DTONodoGrupo> ret = new LinkedList<DTONodoGrupo>();
        if (this.isValidNodo(aux, tipo)) {
            return aux;
        }
        for (DTONodoGrupo dTONodoGrupo : aux.getNodoGrupo()) {
            DTONodoGrupo temp = this.filtrarWeb(dTONodoGrupo, tipo);
            if (temp == null) continue;
            ret.add(temp);
        }
        aux.setNodoGrupo(ret);
        if (aux.getNodoGrupo().isEmpty()) {
            return null;
        }
        return aux;
    }

    private void montaGrupoInternal(DTONodoGrupo aux, List<NodoGrupo> nodos) {
        for (int i = 0; i < nodos.size(); ++i) {
            NodoGrupo nodo = nodos.get(i);
            if (nodo.getNodoGrupoPai() == null || !TMethods.isEquals((Object)nodo.getNodoGrupoPai().getIdentificador(), (Object)aux.getIdentificador())) continue;
            DTONodoGrupo d = this.toVONodoGrupo(nodo);
            aux.getNodoGrupo().add(d);
            nodos.remove(nodo);
            this.montaGrupoInternal(d, nodos);
            i = -1;
        }
    }

    private void ordernar(DTONodoGrupo df) {
        if (df == null || df.getNodoGrupo() == null) {
            return;
        }
        Collections.sort(df.getNodoGrupo(), (o1, o2) -> {
            if (o1 != null && o1.getNodoDescricao() != null && o2 != null && o2.getNodoDescricao() != null) {
                return o1.getNodoDescricao().compareTo(o2.getNodoDescricao());
            }
            return 0;
        });
        for (DTONodoGrupo aux : df.getNodoGrupo()) {
            this.ordernar(aux);
        }
    }

    private DTONodoGrupo toVONodoGrupo(NodoGrupo n) {
        DTONodoGrupo v = new DTONodoGrupo();
        v.setAcessar(n.getAcessar());
        v.setClonar(n.getClonar());
        v.setEditar(n.getEditar());
        v.setExcluir(n.getExcluir());
        v.setExcluirMultiplos(n.getExcluirMultiplos());
        v.setNodoVoClasses(n.getNodo().getVoClasses());
        v.setIdentificador(n.getIdentificador());
        v.setTipoSistema(EnumConstTipoSistemaWEB.get((Object)n.getNodo().getTipoAcessoSistema()));
        v.setInserir(n.getInserir());
        v.setNodoIdentificador(n.getNodo().getIdentificador());
        v.setPesquisar(n.getPesquisar());
        v.setNodoDescricao(n.getNodo().getDescricao());
        v.setNodoPathWeb(n.getNodo().getPathWeb());
        return v;
    }

    private boolean isValidNodo(DTONodoGrupo aux, EnumConstTipoSistemaWEB tipo) {
        if (!ToolMethods.isStrWithData((String)aux.getNodoPathWeb())) {
            return false;
        }
        if (aux.getNodoPathWeb().equalsIgnoreCase("null")) {
            return false;
        }
        EnumConstTipoSistemaWEB tipoNodo = aux.getTipoSistema();
        if (tipoNodo == null) {
            tipoNodo = EnumConstTipoSistemaWEB.WEB;
        }
        return ToolMethods.isEquals((Object)tipo, (Object)tipoNodo);
    }
}

