/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.grupousuarios;

import com.touchcomp.basementor.constants.enums.grupo.EnumConstGrupoOP;
import com.touchcomp.basementor.constants.enums.grupo.EnumConstGrupoSections;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemaWEB;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.GrupoOp;
import com.touchcomp.basementor.model.vo.GrupoUsuariosTipoDoc;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.NodoGrupo;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoUsuariosImpl;
import com.touchcomp.basementorservice.helpers.impl.grupousuarios.HelperGrupoUsuarios;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.grupousuarios.AuxMontaNodos;
import com.touchcomp.basementorservice.service.impl.grupousuarios.AuxMontaNodosGrupoWEB;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.tipodoc.ServiceTipoDocImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.grupo.web.DTOGrupo;
import com.touchcomp.touchvomodel.vo.grupo.web.DTONodoGrupo;
import com.touchcomp.touchvomodel.vo.grupo.web.DTONodoGrupoList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoUsuariosImpl
extends ServiceGenericEntityImpl<Grupo, Long, DaoGrupoUsuariosImpl> {
    ServiceNodoImpl serviceNodoImpl;
    ServiceTipoDocImpl serviceTipoDocImpl;
    HelperGrupoUsuarios helperGrupo;

    @Autowired
    public ServiceGrupoUsuariosImpl(DaoGrupoUsuariosImpl genericDao, ServiceNodoImpl serviceNodoImpl, ServiceTipoDocImpl serviceTipoDocImpl, HelperGrupoUsuarios helperGrupo) {
        super(genericDao);
        this.serviceNodoImpl = serviceNodoImpl;
        this.serviceTipoDocImpl = serviceTipoDocImpl;
        this.helperGrupo = helperGrupo;
    }

    public DTONodoGrupo getDTONodoGrPrincipalAcessoWEB(Grupo grupo, EnumConstTipoSistemaWEB tipoSistema) {
        List<NodoGrupo> nodos = ((DaoGrupoUsuariosImpl)this.getGenericDao()).getNodosGrupos(grupo);
        return new AuxMontaNodosGrupoWEB().getDTONodoGrupoPrincipal(nodos, tipoSistema);
    }

    public DTONodoGrupo getDTONodoGrupoFull() {
        List<Nodo> nodos = this.serviceNodoImpl.getNodosMenuLiberados();
        return new AuxMontaNodos().getDTONodoGrupoPrincipal(nodos);
    }

    @Override
    public Grupo beforeSave(Grupo aux) {
        aux.getGrupoUsuarioConfiguracoes().setGrupo(aux);
        if (aux.getNodosGrupo() != null) {
            this.preencherCodigoNodosVinculados(aux.getNodosGrupo());
            ArrayList<NodoGrupo> nodos = new ArrayList<NodoGrupo>();
            for (NodoGrupo nodoGrupo : aux.getNodosGrupo()) {
                Optional<NodoGrupo> found;
                if (!this.isAffimative(nodoGrupo.getAcessar())) continue;
                if (!nodos.contains(nodoGrupo)) {
                    nodos.add(nodoGrupo);
                }
                if ((found = aux.getNodosGrupo().stream().filter(i -> this.isEquals(i.getCodigoNodo(), nodoGrupo.getCodigoNodoVinculado())).findFirst()).isPresent()) {
                    nodoGrupo.setNodoGrupoPai(found.get());
                    nodoGrupo.getNodoGrupoPai().setGrupo(aux);
                    if (!nodos.contains(nodoGrupo.getNodoGrupoPai())) {
                        nodos.add(nodoGrupo.getNodoGrupoPai());
                    }
                }
                nodoGrupo.setGrupo(aux);
            }
            aux.setNodosGrupo(nodos);
        }
        if (aux.getGrupoUsuarioConfiguracoes() != null) {
            if (aux.getGrupoUsuarioConfiguracoes().getGrupoClassModulo() != null) {
                aux.getGrupoUsuarioConfiguracoes().getGrupoClassModulo().forEach(i -> i.setGrupoUsuarioConfiguracoes(aux.getGrupoUsuarioConfiguracoes()));
            }
            if (aux.getGrupoUsuarioConfiguracoes().getTiposDoc() != null) {
                aux.getGrupoUsuarioConfiguracoes().getTiposDoc().forEach(i -> i.setGrupoUsuarioConfiguracoes(aux.getGrupoUsuarioConfiguracoes()));
            }
            for (GrupoOp op : aux.getGrupoUsuarioConfiguracoes().getOpcoesGrupo()) {
                op.setGrupoUsuarioConfiguracoes(aux.getGrupoUsuarioConfiguracoes());
            }
        }
        return aux;
    }

    private void preencherCodigoNodosVinculados(List<NodoGrupo> nodos) {
        for (NodoGrupo nodoGrupo : nodos) {
            nodoGrupo.setCodigoNodoVinculado(this.getCodigoPai(nodoGrupo.getCodigoNodo()));
        }
    }

    private String getCodigoPai(String codigo) {
        if (TMethods.isStrWithData((String)codigo)) {
            String[] niveis = codigo.split("\\.");
            if (niveis.length <= 1) {
                return null;
            }
            Object aux = "";
            for (int i = 0; i < niveis.length - 1; ++i) {
                aux = (String)aux + niveis[i] + ".";
            }
            return ((String)aux).substring(0, ((String)aux).length() - 1);
        }
        return null;
    }

    public List<DTONodoGrupoList> getNodosDTO(Long idGrupoUsuario) {
        Grupo g = (Grupo)this.get(idGrupoUsuario);
        return this.buildToDTOGeneric(g.getNodosGrupo(), DTONodoGrupoList.class);
    }

    public Grupo getOrThrowNotExists(Long id) throws ExceptionObjNotFound {
        Grupo found = (Grupo)this.get(id);
        if (found == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0053.001", new Object[]{id}));
        }
        return found;
    }

    public List<DTOGrupo.DTOGrupoUsuariosTipoDoc> getTipoDocGrupo(Long[] idTipoDocs) {
        List tipos = this.serviceTipoDocImpl.gets(idTipoDocs);
        LinkedList<GrupoUsuariosTipoDoc> tiposGR = new LinkedList<GrupoUsuariosTipoDoc>();
        for (TipoDoc tipo : tipos) {
            GrupoUsuariosTipoDoc g = new GrupoUsuariosTipoDoc();
            g.setTipoDoc(tipo);
            tiposGR.add(g);
        }
        return this.buildToDTOGeneric(tiposGR, DTOGrupo.DTOGrupoUsuariosTipoDoc.class);
    }

    public DTOOpcoesDinamicas getOptions(Long idGrupo) throws ExceptionObjNotFound {
        Grupo op = (Grupo)this.getOrThrow(idGrupo);
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helperGrupo.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstGrupoSections.values(), (EnumOpDinamicasInterface[])EnumConstGrupoOP.values());
        return din;
    }

    public List<Grupo> findAllOrderByDesc() {
        return ((DaoGrupoUsuariosImpl)this.getDao()).findAllOrderByDesc();
    }
}

