/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.hibernate;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.dao.impl.DaoHibernateImpl;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementortools.model.reflection.ClassInfo;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.touchvomodel.res.DTOEnumChaveDescricao;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOClassFieldInfo;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOClassInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceHibernateImpl
extends ServiceGenericImpl {
    @Autowired
    DaoHibernateImpl daoHibernateImpl;

    public List<Class> getMappedClass() {
        return this.daoHibernateImpl.getMappedClass();
    }

    public List<ClassInfo> getMappedClassInfo() {
        List<Class> values = this.getMappedClass();
        List<ClassInfo> ret = this.getListaClasses(values);
        Collections.sort(ret, (o1, o2) -> o1.getDescricao().compareTo(o2.getDescricao()));
        return ret;
    }

    public String getIdProperty(Class voClass) {
        return this.daoHibernateImpl.getIdPropertyName(voClass);
    }

    public String getIdProperty(String voClass) {
        return this.daoHibernateImpl.getIdPropertyNameByClassName(voClass);
    }

    private List<ClassInfo> getListaClasses(List<Class> dados) {
        LinkedList<ClassInfo> lista = new LinkedList<ClassInfo>();
        for (Class c : dados) {
            String descricao = ToolReflections.getDescName((Class)c);
            ClassInfo cl = new ClassInfo();
            cl.setDescricao(descricao);
            cl.setClassType(c);
            cl.setName(c.getCanonicalName());
            cl.setSimpleName(c.getSimpleName());
            lista.add(cl);
        }
        return lista;
    }

    public List<DTOClassInfo> getDTOMappedClassInfo() {
        List<ClassInfo> some = this.getMappedClassInfo();
        LinkedList<DTOClassInfo> ret = new LinkedList<DTOClassInfo>();
        for (ClassInfo ci : some) {
            DTOClassInfo d = new DTOClassInfo();
            d.setDescricao(ci.getDescricao());
            d.setTipoClass(ci.getName());
            ret.add(d);
        }
        return ret;
    }

    public List<DTOClassInfo> getDTOMappedClassFieldsInfo() {
        List<ClassInfo> some = this.getMappedClassInfo();
        LinkedList<DTOClassInfo> ret = new LinkedList<DTOClassInfo>();
        for (ClassInfo ci : some) {
            DTOClassInfo d = new DTOClassInfo();
            d.setDescricao(ci.getDescricao());
            d.setTipoClass(ci.getName());
            ret.add(d);
        }
        return ret;
    }

    public List<DTOClassFieldInfo> getDTOMappedFieldClassInfo(String entity) throws ExceptionReflection {
        LinkedList<DTOClassFieldInfo> ret = new LinkedList<DTOClassFieldInfo>();
        try {
            Class<?> entityClazz = Class.forName(entity);
            Method[] m = entityClazz.getDeclaredMethods();
            for (int i = 0; i < m.length; ++i) {
                if (!this.isValidToAdd(m[i], entityClazz)) continue;
                Method met = m[i];
                String descricao = ToolReflections.getDescName((Method)met);
                String nomeAtributo = this.transformerMetodoEmAtributo(m[i]);
                String classe = ToolReflections.getHibernateReturnType((Method)met).getName();
                Class<?> returnClass = ToolReflections.getHibernateEntityClass((Method)met);
                if (returnClass == null) {
                    returnClass = met.getReturnType();
                }
                DTOClassFieldInfo d = new DTOClassFieldInfo();
                d.setDescricao(descricao);
                d.setField(nomeAtributo);
                d.setTipoClass(returnClass.getCanonicalName());
                if (returnClass.getAnnotation(Entity.class) != null) {
                    d.setIsEntity(Short.valueOf((short)1));
                } else {
                    d.setIsEntity(Short.valueOf((short)0));
                }
                ret.add(d);
            }
            Collections.sort(ret, (t, t1) -> {
                DTOClassFieldInfo c = (DTOClassFieldInfo)t;
                DTOClassFieldInfo c1 = (DTOClassFieldInfo)t1;
                return c.getDescricao().compareTo(c1.getDescricao());
            });
            return ret;
        }
        catch (ClassNotFoundException ex) {
            this.logError(ex);
            throw new ExceptionReflection(ex);
        }
    }

    private String transformerMetodoEmAtributo(Method m) {
        String nomeMetodo = m.getName();
        Object nomeAtributo = nomeMetodo.substring(3, nomeMetodo.length());
        nomeAtributo = ((String)nomeAtributo).substring(0, 1).toLowerCase() + ((String)nomeAtributo).substring(1, ((String)nomeAtributo).length());
        return nomeAtributo;
    }

    private boolean isValidToAdd(Method m, Class classe) {
        Field[] f;
        if (m.getAnnotation(Transient.class) != null) {
            return false;
        }
        if (!m.getName().startsWith("get")) {
            return false;
        }
        for (Field fi : f = classe.getDeclaredFields()) {
            if (!m.getName().toLowerCase().contains(fi.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public List<DTOEnumChaveDescricao> getNodosToCombo() {
        List<ClassInfo> listClassInfo = this.getMappedClassInfo();
        ArrayList<DTOEnumChaveDescricao> nodo = new ArrayList<DTOEnumChaveDescricao>();
        listClassInfo.forEach(i -> {
            try {
                nodo.add(new DTOEnumChaveDescricao(ToolReflections.toModelVOClass((String)i.getName()).getSimpleName(), i.getDescricao()));
            }
            catch (ClassNotFoundException ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
            }
        });
        return nodo;
    }
}

