/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.horariotrabalho;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroHorario;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementorclientwebservices.ponto.model.horario.DTOPontoHorario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoHorarioTrabalhoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esoctipocontratohorario.ServiceEsocTipoContratoHorarioImpl;
import com.touchcomp.basementorservice.service.impl.esoctipojornadatrabalho.ServiceEsocTipoJornadaTrabalhoImpl;
import com.touchcomp.touchvomodel.res.DTOInfoHorarioTrabalhoRes;
import com.touchcomp.touchvomodel.vo.horariotrabalho.web.DTOHorarioTrabalho;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceHorarioTrabalhoImpl
extends ServiceGenericEntityImpl<HorarioTrabalho, Long, DaoHorarioTrabalhoImpl> {
    ServiceEsocTipoContratoHorarioImpl serviceEsocTipoContratoHorarioImpl;
    ServiceEsocTipoJornadaTrabalhoImpl serviceEsocTipoJornadaTrabalhoImpl;

    public ServiceHorarioTrabalhoImpl(DaoHorarioTrabalhoImpl dao, ServiceEsocTipoContratoHorarioImpl serviceEsocTipoContratoHorarioImpl, ServiceEsocTipoJornadaTrabalhoImpl serviceEsocTipoJornadaTrabalhoImpl) {
        super(dao);
        this.serviceEsocTipoContratoHorarioImpl = serviceEsocTipoContratoHorarioImpl;
        this.serviceEsocTipoJornadaTrabalhoImpl = serviceEsocTipoJornadaTrabalhoImpl;
    }

    public HorarioTrabalho getHorarioTrabalho(Empresa empresa, Date dataAbertura, Double horasEmNumero) {
        return ((DaoHorarioTrabalhoImpl)this.getDao()).getHorarioTrabalho(empresa, dataAbertura, horasEmNumero);
    }

    public List<DTOPontoHorario> findHorariosTrabalhoPonto() {
        return ((DaoHorarioTrabalhoImpl)this.getGenericDao()).findHorariosTrabalhoPonto();
    }

    public DTOHorarioTrabalho carregarHorarioTrabalho(Long idHorarioTrabalho) throws ExceptionObjNotFound {
        HorarioTrabalho horarioTrabalho = (HorarioTrabalho)this.getOrThrow(idHorarioTrabalho);
        return this.buildToDTOGeneric(horarioTrabalho, DTOHorarioTrabalho.class);
    }

    public HorarioTrabalho getHorarioTrabalhoDescricao(String descricao) {
        return ((DaoHorarioTrabalhoImpl)this.getDao()).getHorarioTrabalhoDescricao(descricao);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public HorarioTrabalho getAndSaveHorario(String descJornada, Short horarioNoturno, Double qtdHrsSem, String codigoTipoContratoHorario, String codigoTipoJornada, Empresa empresa) {
        HorarioTrabalho hor = new HorarioTrabalho();
        hor.setDescricao(descJornada);
        hor.setDataCadastro(new Date());
        hor.setDataInicial(new Date());
        hor.setDescricaoHorario(descJornada);
        hor.setEmpresa(empresa);
        EsocCadastroHorario esoc = new EsocCadastroHorario();
        esoc.setAtivo(Short.valueOf((short)1));
        esoc.setDescricaoEscalaDiferenciada(descJornada);
        esoc.setDataInicio(hor.getDataInicial());
        esoc.setPossuiHoraNoturna(horarioNoturno);
        esoc.setEsocTipoContrato(this.serviceEsocTipoContratoHorarioImpl.getByCodigo(codigoTipoContratoHorario));
        esoc.setTipoJornada(this.serviceEsocTipoJornadaTrabalhoImpl.getByCodigo(codigoTipoJornada));
        hor.setEsocCadastroHorario(esoc);
        return this.saveOrUpdateOnly(hor);
    }

    public List<DTOInfoHorarioTrabalhoRes> carregarComboListaHorario(Long idHorarioTrabalho) throws ExceptionObjNotFound {
        HorarioTrabalho horarioTrabalho = (HorarioTrabalho)this.getOrThrow(idHorarioTrabalho);
        if (this.isNull(horarioTrabalho.getEsocCadastroHorario()).booleanValue() || !ServiceHorarioTrabalhoImpl.isWithData(horarioTrabalho.getEsocCadastroHorario().getListaHorario()) && this.isNull(horarioTrabalho.getEsocCadastroHorario().getInfoHorario()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0085.001", new Object[]{horarioTrabalho}));
        }
        ArrayList<InfoHorarioTrabalho> listInfoHorarioTrabalho = new ArrayList<InfoHorarioTrabalho>();
        if (this.isNotNull(horarioTrabalho.getEsocCadastroHorario().getInfoHorario()).booleanValue()) {
            listInfoHorarioTrabalho.add(horarioTrabalho.getEsocCadastroHorario().getInfoHorario());
        }
        if (ServiceHorarioTrabalhoImpl.isWithData(horarioTrabalho.getEsocCadastroHorario().getListaHorario())) {
            listInfoHorarioTrabalho.addAll(horarioTrabalho.getEsocCadastroHorario().getListaHorario());
        }
        return this.buildToDTOGeneric(horarioTrabalho.getEsocCadastroHorario().getListaHorario(), DTOInfoHorarioTrabalhoRes.class);
    }
}

