/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.implantacaosaldos;

import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemImpSaldo;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.ItemControleEquipamento;
import com.touchcomp.basementor.model.vo.ItemImplantaSaldo;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SCompImplantacaoSaldosImpl
extends ServiceGenericImpl {
    ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;

    public void criarImplantacaoSaldo(ControleEntregaEquipamento vo) {
        ImplantacaoSaldos implantacaoSaldos = new ImplantacaoSaldos();
        implantacaoSaldos.setDataCadastro(new Date());
        implantacaoSaldos.setEmpresa(vo.getEmpresa());
        implantacaoSaldos.setDataEntradaSaida(vo.getDataEntrega());
        this.criarItemImplantaSaldo(vo, implantacaoSaldos);
        vo.setImplantacaoSaldos(implantacaoSaldos);
    }

    private void criarItemImplantaSaldo(ControleEntregaEquipamento vo, ImplantacaoSaldos implantacaoSaldos) {
        List itemImplantaSaldo = vo.getItemControleEquipamentos().stream().map(i -> {
            ItemImplantaSaldo item = new ItemImplantaSaldo();
            item.setProduto(i.getGradeCor().getProdutoGrade().getProduto());
            item.setUnidadeMedida(i.getGradeCor().getProdutoGrade().getProduto().getUnidadeMedida());
            item.setQuantidadeTotal(i.getQuantidade());
            item.setCentroEstoque(i.getCentroEstoque());
            item.setImplantacaoSaldos(implantacaoSaldos);
            this.criarGradeItemImpSaldo((ItemControleEquipamento)i, item, vo.getDataEntrega(), vo.getEmpresa());
            return item;
        }).collect(Collectors.toList());
        implantacaoSaldos.setItemImplantaSaldo(itemImplantaSaldo);
    }

    private void criarGradeItemImpSaldo(ItemControleEquipamento itemControleEquipamento, ItemImplantaSaldo itemImplantaSaldo, Date dataEntrega, Empresa empresa) {
        ArrayList<GradeItemImpSaldo> listGradeItemImpSaldos = new ArrayList<GradeItemImpSaldo>();
        GradeItemImpSaldo gradeItemImpSaldo = new GradeItemImpSaldo();
        gradeItemImpSaldo.setQuantidade(itemControleEquipamento.getQuantidade());
        gradeItemImpSaldo.setGradeCor(itemControleEquipamento.getGradeCor());
        gradeItemImpSaldo.setLoteFabricacao(itemControleEquipamento.getLoteFabricacao());
        gradeItemImpSaldo.setItemImplantaSaldo(itemImplantaSaldo);
        gradeItemImpSaldo.setDataMovimentacao(dataEntrega);
        gradeItemImpSaldo.setEmpresa(empresa);
        gradeItemImpSaldo.setCentroEstoque(itemControleEquipamento.getCentroEstoque());
        Double valorMedio = 0.0;
        if (this.isNull(itemControleEquipamento.getItemDevolvido()).booleanValue() || this.isNull(itemControleEquipamento.getItemDevolvido().getControleEntregaEquipamento()).booleanValue() || this.isNull(itemControleEquipamento.getItemDevolvido().getControleEntregaEquipamento().getRequisicao()).booleanValue() || !SCompImplantacaoSaldosImpl.isWithData(itemControleEquipamento.getItemDevolvido().getControleEntregaEquipamento().getRequisicao().getItensRequisicao())) {
            valorMedio = this.serviceSaldoEstoqueImpl.findPrecoMedioIdProduto(itemControleEquipamento.getGradeCor().getProdutoGrade().getProduto().getIdentificador(), empresa.getIdentificador(), dataEntrega);
            gradeItemImpSaldo.setValorUnitario(valorMedio);
        } else {
            for (ItemRequisicao itemRequisicao : itemControleEquipamento.getItemDevolvido().getControleEntregaEquipamento().getRequisicao().getItensRequisicao()) {
                if (!this.isEquals(itemControleEquipamento.getItemDevolvido().getGradeCor().getProdutoGrade().getProduto(), itemRequisicao.getProduto())) continue;
                valorMedio = itemRequisicao.getValorPrecoMedioCont();
                if (ToolMethods.isNegative((Number)valorMedio)) {
                    valorMedio = this.serviceSaldoEstoqueImpl.findPrecoMedioIdProduto(itemRequisicao.getProduto().getIdentificador(), empresa.getIdentificador(), itemRequisicao.getRequisicao().getDataRequisicao());
                }
                gradeItemImpSaldo.setValorUnitario(valorMedio);
            }
        }
        itemImplantaSaldo.setValorUnitario(gradeItemImpSaldo.getValorUnitario());
        listGradeItemImpSaldos.add(gradeItemImpSaldo);
        itemImplantaSaldo.setGradeItem(listGradeItemImpSaldos);
    }

    @Generated
    public SCompImplantacaoSaldosImpl(ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl) {
        this.serviceSaldoEstoqueImpl = serviceSaldoEstoqueImpl;
    }
}

